/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bill.common.bean.AccountContractReport;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.IndexHolder;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class AccountContractReportDao
extends AbstractDao<AccountContractReport> {
    public AccountContractReportDao(Connection con, int moduleId) {
        super(con, "", moduleId);
    }

    public void searchAccountContractReport(SearchResult<AccountContractReport> searchResult, List<Integer> contractIds) throws BGException {
        if (searchResult != null && contractIds != null) {
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            String sql = "SELECT " + "cid, yy, mm, summa1, c.title AS contractTitle, c.comment AS contractComment" + " FROM " + "contract_balance" + " AS balance" + " LEFT JOIN contract AS c ON c.id=balance.cid" + " WHERE " + " balance.cid IN (" + Utils.toString(contractIds) + ")" + (period != null && period.getDateFrom() != null ? " AND yy*12+mm >= ?" : "") + (period != null && period.getDateTo() != null ? " AND yy*12+mm <= ?" : "") + " GROUP BY " + "balance.cid" + " ORDER BY " + "yy, mm";
            try (PreparedStatement psSelect = this.con.prepareStatement(sql);){
                IndexHolder index = new IndexHolder();
                if (period != null) {
                    this.psSetInt(psSelect, period.getDateFrom() != null, index, this.calculateMonth(period.getDateFrom()));
                    this.psSetInt(psSelect, period.getDateTo() != null, index, this.calculateMonth(period.getDateTo()));
                }
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        list.add(this.getFromRS(rs));
                    }
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    private int calculateMonth(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return 12 * calendar.get(1) + calendar.get(2) + 1;
    }

    protected AccountContractReport getFromRS(ResultSet resultSet) throws SQLException, BGException {
        AccountContractReport accountContractReport = new AccountContractReport();
        accountContractReport.setContractId(resultSet.getInt("cid"));
        accountContractReport.setContractTitle(resultSet.getString("contractTitle"));
        accountContractReport.setContractComment(resultSet.getString("contractComment"));
        BigDecimal saldoIn = resultSet.getBigDecimal("balance.summa1");
        if (saldoIn.compareTo(BigDecimal.ZERO) > 0) {
            accountContractReport.setSaldoCreditIn(saldoIn);
        } else if (saldoIn.compareTo(BigDecimal.ZERO) < 0) {
            accountContractReport.setSaldoDebetIn(saldoIn.negate());
        }
        return accountContractReport;
    }

    protected void updateImpl(AccountContractReport accountContractReport) throws SQLException {
    }
}

