/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.service;

import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.jasperreports.engine.JasperReport;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigData;
import ru.bitel.bgbilling.kernel.config.server.bean.ConfigDAO;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.bill.common.bean.Attribute;
import ru.bitel.bgbilling.modules.bill.common.bean.AttributeType;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.common.bean.BillDocument;
import ru.bitel.bgbilling.modules.bill.common.bean.BillListFilter;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.DocTypes;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentPosition;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentSendParameters;
import ru.bitel.bgbilling.modules.bill.common.bean.InvoiceDocument;
import ru.bitel.bgbilling.modules.bill.common.bean.NumerationPool;
import ru.bitel.bgbilling.modules.bill.common.bean.Organization;
import ru.bitel.bgbilling.modules.bill.common.bean.Position;
import ru.bitel.bgbilling.modules.bill.common.bean.accounts.BillAccountsReceivableDetail;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.BillPositionType;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.bean.link.BillLink;
import ru.bitel.bgbilling.modules.bill.common.export.BillDocumentExport;
import ru.bitel.bgbilling.modules.bill.common.export.BillExportInfo;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.bgbilling.modules.bill.server.bean.AbstractManager;
import ru.bitel.bgbilling.modules.bill.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.bill.server.bean.AttributeDao;
import ru.bitel.bgbilling.modules.bill.server.bean.AttributeTypeDao;
import ru.bitel.bgbilling.modules.bill.server.bean.Bill;
import ru.bitel.bgbilling.modules.bill.server.bean.BillAccountsReceivableManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDocumentDao;
import ru.bitel.bgbilling.modules.bill.server.bean.BillLinkDao;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocType;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.DocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceDocumentDao;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.modules.bill.server.bean.NumerationPoolManager;
import ru.bitel.bgbilling.modules.bill.server.bean.OrganizationDao;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionDao;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.modules.bill.server.bean.TemplateBill;
import ru.bitel.bgbilling.modules.bill.server.bean.TemplateBillManager;
import ru.bitel.bgbilling.modules.bill.server.event.BillCreatedEvent;
import ru.bitel.bgbilling.modules.bill.server.task.BillDocsSender;
import ru.bitel.bgbilling.modules.bill.server.task.BillDocsSenderForAll;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportTemplate;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.FOUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.LogEntry;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.bill.common.service.BillService")
public class BillServiceImpl
extends AbstractService
implements BillService {
    public Result<BillDocument> billDocumentListForContract(int contractId, Page page) throws BGException {
        return new Result(new BillDocumentDao(this.getSetup(), (ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId).list(contractId, page), page);
    }

    public void billDelete(List<Integer> billIds) throws BGException {
        this.tryCall(() -> {
            BillManager billManager = new BillManager(this.getConnection(), this.moduleId);
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionDeleteBill", (int)this.moduleId, (int)this.userId);
            if (closedDate != null) {
                for (Integer iddoc : billIds) {
                    BillDoc doc = billManager.getBillDocInfo(iddoc);
                    if (doc == null) continue;
                    LocalDate month = LocalDate.of(doc.getYy(), doc.getMm() + 1, 1);
                    ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (LocalDate)month);
                }
            }
            billManager.delete(billIds);
        });
    }

    public void billDocumentDelete(int contractId, int id, boolean customer) throws BGException {
        this.tryCall(() -> {
            if (contractId <= 0) {
                throw new BGIllegalArgumentException("contractId");
            }
            BillManager billManager = new BillManager(this.getConnection(), this.moduleId);
            Bill bill = billManager.getBill(id);
            Calendar closedDate = null;
            if (bill != null && (closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"BillService.billDocumentDelete", (int)this.moduleId, (int)this.userId)) != null) {
                LocalDate month = LocalDate.of(bill.getYy(), bill.getMm() + 1, 1);
                ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (LocalDate)month);
            }
            if (customer) {
                int result = billManager.deleteBill(contractId, id, !customer);
                switch (result) {
                    case 1: {
                        throw new BGMessageException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0439 \u0441\u0447\u0435\u0442", "bill.deleteError.userId");
                    }
                    case 2: {
                        throw new BGMessageException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0439 \u0441\u0447\u0435\u0442", "bill.deleteError.status");
                    }
                    case 4: {
                        throw new BGMessageException("\u0421\u0447\u0435\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", "bill.deleteError.notFound");
                    }
                }
            } else {
                if (bill == null || bill.getContractId() != contractId) {
                    throw new BGIllegalArgumentException("contractId");
                }
                billManager.delete(id);
            }
        });
    }

    public List<DocType> documentSpecListForCustomer(int contractId) throws BGException {
        ArrayList<DocType> billTypeList = new ArrayList<DocType>();
        Set allowedWebBillTypes = Utils.toIntegerSet((String)this.getModuleSetup().get("allowed.web.bill.types", null));
        for (DocType type : new ContractDocTypeManager(this.getConnection(), this.moduleId).getContractDocTypeList(contractId, DocumentType.BILL)) {
            if (!allowedWebBillTypes.contains(type.getId())) continue;
            billTypeList.add(type);
        }
        return billTypeList;
    }

    public List<BankAccount> bankAccountList() throws BGException {
        return (List)this.tryReturn(() -> new AccountManager(this.getConnection(), this.moduleId).getAccountList().stream().map(a -> a.toBankAccount()).collect(Collectors.toList()));
    }

    public List<DocumentPosition> templateDocumentPositionList(int contractId, int documentSpecId, int year, int month) throws BGException {
        return (List)this.tryReturn(() -> {
            DocTypeManager docTypeManager = new DocTypeManager(this.getConnection(), this.moduleId);
            DocType docType = docTypeManager.getType(documentSpecId);
            PositionDao positionDao = new PositionDao(this.getConnection(), this.moduleId, docType.getDocumentType());
            try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
                TemplateBill templateBill = new TemplateBill();
                TemplateBillManager templateBillManager = new TemplateBillManager(this.getConnection(), this.moduleId, docType.getDocumentType());
                templateBillManager.getTemplatePositions(contractDao, templateBill, new GregorianCalendar(year, month, 1), contractId, String.valueOf(contractId), null, docType, positionDao.getPositionMap());
                List list = templateBill.getPositionList() == null ? null : templateBill.getPositionList().stream().map(e -> e.toDocumentPosition()).collect(Collectors.toList());
                return list;
            }
        });
    }

    public int billDocumentCreate(int contractId, int documentSpecId, int bankAccountId, int year, int month, List<DocumentPosition> documentPositionList) throws BGException {
        return (Integer)this.tryReturn(() -> {
            if (!this.documentSpecListForCustomer(contractId).stream().anyMatch(s -> s.getId() == documentSpecId)) {
                new BGIllegalArgumentException("documentSpecId");
            }
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"BillService.billDocumentCreate", (int)this.moduleId, (int)this.userId);
            if (closedDate != null) {
                LocalDate datemonth = LocalDate.of(year, month + 1, 1);
                ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (LocalDate)datemonth, (LocalDate)datemonth);
            }
            List<DocumentPosition> templateDocumentPositionList = this.templateDocumentPositionList(contractId, documentSpecId, year, month);
            ArrayList<PositionValue> posList = new ArrayList<PositionValue>();
            BigDecimal total = BigDecimal.ZERO;
            for (DocumentPosition pos : documentPositionList) {
                if (!templateDocumentPositionList.stream().anyMatch(s -> s.getPositionId() == pos.getPositionId())) {
                    new BGIllegalArgumentException("positionId=" + pos.getPositionId());
                }
                PositionValue val = new PositionValue();
                val.setPositionId(pos.getPositionId());
                val.setName(pos.getName());
                val.setSum(pos.getAmount());
                val.setUnit(Utils.maskNull((String)pos.getUnit()));
                pos.setInTotal(true);
                val.setInSumm(true);
                val.setQuantity(Utils.parseBigDecimal((String)this.getModuleSetup().get("web.bill.generate.position.quantity", "0"), (BigDecimal)BigDecimal.ZERO));
                posList.add(val);
                total = total.add(val.getSum());
            }
            Bill bill = new Bill().setContractId(contractId).setTypeId(documentSpecId).setAccountId(bankAccountId).setBankAccount(new AccountManager(this.getConnection(), this.moduleId).getBankAccount(bankAccountId)).setYy(year).setMm(month).setSumm(total).setCreateDate(new Date()).setUserId(-1).setNpid(new DocTypeManager(this.getConnection(), this.moduleId).getType(documentSpecId).getNpid());
            int billId = new BillManager(this.getConnection(), this.moduleId).addBillDoc(this.userId, bill, posList, Collections.emptyList());
            this.context.publishAfterCommit((Event)new BillCreatedEvent(this.userId, this.moduleId, contractId, billId));
            return billId;
        });
    }

    public FileDto billDocumentDownload(int contractId, int id) throws BGException {
        return this.documentDownload(contractId, id, false);
    }

    private FileDto documentDownload(int contractId, int id, boolean invoice) throws BGException {
        return (FileDto)this.tryReturn(() -> {
            if (this.moduleId <= 0 || contractId <= 0 || id <= 0) {
                throw new BGIllegalArgumentException();
            }
            Connection con = this.getConnection();
            AbstractManager manager = invoice ? new InvoiceManager(con, this.moduleId) : new BillManager(con, this.moduleId);
            String patternName = BillUtil.getPatternName(invoice ? DocumentSendParameters.SendingDataType.INVOICE : DocumentSendParameters.SendingDataType.BILL, con, this.moduleId, id);
            byte[] xmlData = manager.getXMLData(contractId, id);
            if (xmlData == null) {
                throw new BGIllegalArgumentException("documentNotFoundForContract");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2000);
            FileDto fileDto = new FileDto();
            fileDto.setContentType("application/pdf");
            fileDto.setFileName(this.docl2PDF(con, xmlData, patternName, invoice, baos));
            fileDto.setData(Base64.getEncoder().encodeToString(baos.toByteArray()));
            return fileDto;
        });
    }

    private String docl2PDF(Connection con, byte[] data, String patternName, boolean invoice, OutputStream out) throws BGException {
        return (String)this.tryReturn(() -> {
            Date date;
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            Document doc = XMLUtils.parseDocument((InputSource)new InputSource(bis));
            Element bill = (Element)doc.getDocumentElement().getElementsByTagName("bill").item(0);
            StringBuilder fileName = new StringBuilder(50);
            if (invoice) {
                fileName.append("Invoice_");
            } else {
                fileName.append("Bill_");
            }
            String contract = bill.getAttribute("contract");
            if (Utils.notBlankString((String)contract)) {
                fileName.append(contract).append("_");
            }
            if ((date = TimeUtils.parseDate((String)bill.getAttribute("date"), (String)"dd.MM.yyyy")) != null) {
                fileName.append(TimeUtils.format((Date)date, (String)"yyyyMMdd"));
            }
            fileName.append(".pdf");
            bill.setAttribute("with_stamp", "1");
            if (patternName.endsWith(".jrxml")) {
                JasperReport report = BGReportTemplate.getJasperReport((ParameterMap)this.getSetup(), (URI)new File(XSLManager.getInstance().getXslRootPath() + patternName).toURI());
                BGReportFilter reportFilter = new BGReportFilter(Collections.emptyMap(), (Preferences)this.getSetup(), this.userId);
                BGReportTemplate.fillReportToPdfStream((JasperReport)report, (BGReportFilter)reportFilter, (Connection)con, (Document)doc, (OutputStream)out);
            } else {
                XSLManager.getInstance().transform((Source)new DOMSource(doc), patternName, (javax.xml.transform.Result)FOUtils.renderSAXResult((OutputStream)out, (String)"application/pdf"));
            }
            return fileName.toString();
        });
    }

    public Result<InvoiceDocument> invoiceDocumentListForContract(int contractId, boolean onlyReady, Page page) throws BGException {
        return new Result(new InvoiceDocumentDao(this.getSetup(), (ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId).list(contractId, onlyReady, page), page);
    }

    public void invoiceDelete(List<Integer> invoiceIds) throws BGException {
        this.tryCall(() -> {
            InvoiceManager invoiceManager = new InvoiceManager(this.getConnection(), this.moduleId);
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionDeleteInvoice", (int)this.moduleId, (int)this.userId);
            if (closedDate != null) {
                for (Integer iddoc : invoiceIds) {
                    BillDoc doc = invoiceManager.getBillDocInfo(iddoc);
                    if (doc == null) continue;
                    LocalDate month = LocalDate.of(doc.getYy(), doc.getMm() + 1, 1);
                    ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (LocalDate)month);
                }
            }
            invoiceManager.delete(invoiceIds);
        });
    }

    public FileDto invoiceDocumentDownload(int contractId, int id) throws BGException {
        return this.documentDownload(contractId, id, true);
    }

    public List<IdTitle> getBankAccountTitleList(int contractId, int organizationId, Boolean inUse, Holder<Integer> selectedItemId) throws BGException {
        return (List)this.tryReturn(() -> {
            ContractModuleConfigDao configDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);
            selectedItemId.value = Utils.parseInteger((String)configDao.get(contractId, "bank.account.id"), (Integer)0);
            return new AccountManager(this.getConnection(), this.moduleId).getAccountTitleList(organizationId, inUse);
        });
    }

    public void setBankAccount(int contractId, int selectedBabkAccountId) throws BGException {
        this.tryCall(() -> {
            ContractModuleConfigDao configDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);
            if (selectedBabkAccountId == 0) {
                configDao.delete(contractId, "bank.account.id");
            } else {
                configDao.update(contractId, "bank.account.id", String.valueOf(selectedBabkAccountId));
            }
        });
    }

    public void copyBankAccount(int fromContractId, int toContractId) throws BGException {
        this.tryCall(() -> {
            ContractModuleConfigDao configDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);
            int bankAccountId = Utils.parseInteger((String)configDao.get(fromContractId, "bank.account.id"), (Integer)0);
            this.setBankAccount(toContractId, bankAccountId);
        });
    }

    public List<BankAccount> getBankAccountList(int organizationId, Boolean inUse) throws BGException {
        return (List)this.tryReturn(() -> new AccountManager(this.getConnection(), this.moduleId).getBankAccountList(organizationId, inUse));
    }

    public void setDefaultBankAccount(BankAccount bankAccount) throws BGException {
        this.tryCall(() -> new AccountManager(this.getConnection(), this.moduleId).setDefaultBankAccount(bankAccount.getId(), bankAccount.getOrganizationId()));
    }

    public BankAccount getDefaultBankAccount(int organizationId) throws BGException {
        return new AccountManager(this.getConnection(), this.moduleId).getDefaultBankAccount(organizationId);
    }

    public void updateBankAccount(BankAccount bankAccount) throws BGException {
        new AccountManager(this.getConnection(), this.moduleId).updateBankAccount(bankAccount);
    }

    public void deleteBankAccount(int bankAccountId) throws BGException {
        this.tryCall(() -> new AccountManager(this.getConnection(), this.moduleId).deleteBankAccount(bankAccountId));
    }

    public BankAccount getBankAccount(int bankAccountId) throws BGException {
        return (BankAccount)this.tryReturn(() -> new AccountManager(this.getConnection(), this.moduleId).getBankAccount(bankAccountId));
    }

    public List<Organization> getOrganizationList() throws BGException {
        return (List)this.tryReturn(() -> new OrganizationDao(this.getConnection(), this.moduleId).getOrganizationList());
    }

    public void updateOrganization(Organization organization) throws BGException {
        this.tryCall(() -> new OrganizationDao(this.getConnection(), this.moduleId).update(organization));
    }

    public void deleteOrganization(int organizationId) throws BGException {
        this.tryCall(() -> new OrganizationDao(this.getConnection(), this.moduleId).deleteOrganization(organizationId));
    }

    public void setDefaultOrganization(int organizationId) throws BGException {
        this.tryCall(() -> new OrganizationDao(this.getConnection(), this.moduleId).setDefaultOrganization(organizationId));
    }

    public void setOrganization(int contractId, int selectedOrganizationId) throws BGException {
        this.tryCall(() -> {
            ContractModuleConfigDao configDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);
            if (selectedOrganizationId == 0) {
                configDao.delete(contractId, "organization.id");
            } else {
                configDao.update(contractId, "organization.id", String.valueOf(selectedOrganizationId));
            }
        });
    }

    public void copyOrganization(int fromContractId, int toContractId) throws BGException {
        this.tryCall(() -> {
            ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);
            int organizationId = Utils.parseInteger((String)contractModuleConfigDao.get(fromContractId, "organization.id"), (Integer)0);
            this.setOrganization(toContractId, organizationId);
        });
    }

    public List<IdTitle> getOrganizationTitleList(int contractId, Boolean inUse, Holder<Integer> selectedItemId) throws BGException {
        return (List)this.tryReturn(() -> {
            ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);
            selectedItemId.value = Utils.parseInteger((String)contractModuleConfigDao.get(contractId, "organization.id"), (Integer)0);
            return new OrganizationDao(this.getConnection(), this.moduleId).getOrganizationTitleList(inUse);
        });
    }

    public Organization getOrganization(int organizationId) throws BGException {
        return (Organization)this.tryReturn(() -> new OrganizationDao(this.getConnection(), this.moduleId).getOrganization(organizationId));
    }

    public Organization getDefaultOrganization() throws BGException {
        return (Organization)this.tryReturn(() -> new OrganizationDao(this.getConnection(), this.moduleId).getDefaultOrganization());
    }

    public DocType docTypeGet(int id) throws BGException {
        return (DocType)this.tryReturn(() -> new DocTypeManager(this.getConnection(), this.moduleId).getType(id));
    }

    public void docTypeUpdate(DocType dt) throws BGException {
        new DocTypeManager(this.getConnection(), this.moduleId).updateType(dt);
    }

    public void docTypeDelete(int id) throws BGException {
        this.tryCall(() -> new DocTypeManager(this.getConnection(), this.moduleId).deleteType(id));
    }

    public List<DocType> docTypeList(DocumentType documentType) throws BGException {
        return (List)this.tryReturn(() -> new DocTypeManager(this.getConnection(), this.moduleId).getTypeList(documentType));
    }

    public List<DocType> docTypeListForContract(int contractId, DocumentType documentType) throws BGException {
        return (List)this.tryReturn(() -> {
            ArrayList<DocType> list = new ArrayList<DocType>();
            ContractDocTypeManager cdtm = new ContractDocTypeManager(this.getConnection(), this.moduleId);
            List<ContractDocType> selected = cdtm.getContractTypeList(contractId, documentType, null);
            block0: for (DocType docType : new DocTypeManager(this.getConnection(), this.moduleId).getTypeList(documentType)) {
                for (ContractDocType contractDocType : selected) {
                    if (contractDocType.getDocTypeId() != docType.getId()) continue;
                    list.add(docType);
                    continue block0;
                }
            }
            return list;
        });
    }

    public List<IdTitle> positionList(DocumentType documentType) throws BGException {
        return (List)this.tryReturn(() -> {
            PositionDao positionDao = new PositionDao(this.getConnection(), this.moduleId, documentType);
            return positionDao.getPositonList().stream().map(p -> new IdTitle(p.getId(), p.getTitle())).toList();
        });
    }

    public MapHolder<Integer, List<IdTitle>> xmlComposition() throws BGException {
        MapHolder map = new MapHolder();
        ArrayList<IdTitle> moduleList = new ArrayList<IdTitle>();
        ArrayList<IdTitle> pluginList = new ArrayList<IdTitle>();
        for (BGModule module : ModuleCache.getInstance().getModulesList()) {
            moduleList.add(new IdTitle(module.getId(), module.getTitle()));
        }
        for (BGPluginServer pluginServer : BGPluginManagerServer.getManager().getPluginsMap().values()) {
            pluginList.add(new IdTitle(pluginServer.getPluginUID(), pluginServer.getName()));
        }
        map.getMap().put(1, moduleList);
        map.getMap().put(2, pluginList);
        return map;
    }

    public SearchResult<Position> searchPositionList(DocumentType documentType, Page page) throws BGException {
        return (SearchResult)this.tryReturn(() -> new PositionDao(this.getConnection(), this.moduleId, documentType).searchPositionList(page));
    }

    public Position positionGet(DocumentType documentType, int positionId) throws BGException {
        return (Position)this.tryReturn(() -> new PositionDao(this.getConnection(), this.moduleId, documentType).getPosition(positionId));
    }

    public Position positionUpdate(DocumentType documentType, Position position) throws BGException {
        return (Position)this.tryReturn(() -> new PositionDao(this.getConnection(), this.moduleId, documentType).updatePosition(position));
    }

    public boolean positionDelete(DocumentType documentType, int positionId) throws BGException {
        return (Boolean)this.tryReturn(() -> new PositionDao(this.getConnection(), this.moduleId, documentType).deletePosition(positionId));
    }

    public void sendDocsForAll(DocumentSendParameters senderTaskParameters) throws BGException {
        senderTaskParameters.setModuleId(this.context.getModuleId());
        senderTaskParameters.setUserId(this.userId);
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new BillDocsSenderForAll(senderTaskParameters));
    }

    public void sendDocs(DocumentSendParameters senderTaskParameters) throws BGException {
        senderTaskParameters.setModuleId(this.context.getModuleId());
        senderTaskParameters.setUserId(this.userId);
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new BillDocsSender(senderTaskParameters));
    }

    public void attributeTypeUpdate(AttributeType attributeType) throws BGException {
        this.tryCall(() -> {
            if (attributeType == null || Utils.isBlankString((String)attributeType.getName()) || Utils.isBlankString((String)attributeType.getTitle())) {
                throw new BGIllegalArgumentException();
            }
            new AttributeTypeDao(this.getConnection(), this.moduleId).update(attributeType);
        });
    }

    public void attributeTypeDelete(int attributeTypeId) throws BGException {
        this.tryCall(() -> new AttributeTypeDao(this.getConnection(), this.moduleId).delete(attributeTypeId));
    }

    public List<AttributeType> attributeTypeList() throws BGException {
        return (List)this.tryReturn(() -> new AttributeTypeDao(this.getConnection(), this.moduleId).getAttributeTypeList());
    }

    public List<Attribute> attributeList(int contractId) throws BGException {
        return (List)this.tryReturn(() -> {
            if (contractId <= 0) {
                throw new BGIllegalArgumentException();
            }
            return new AttributeDao(this.getConnection(), this.moduleId).getAttributeListByCid(contractId);
        });
    }

    public void attributeUpdate(int contractId, Attribute attribute) throws BGException {
        this.tryCall(() -> {
            if (attribute == null || attribute.getContractId() <= 0) {
                throw new BGIllegalArgumentException();
            }
            AttributeDao attributeDao = new AttributeDao(this.getConnection(), this.moduleId);
            if (attribute == null || attribute.getContractId() != contractId) {
                throw new BGMessageException("attribute==null \u0438\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 contractId");
            }
            attributeDao.update(attribute);
        });
    }

    public void attributeDelete(int contractId, int attributeId) throws BGException {
        this.tryCall(() -> {
            if (contractId <= 0 || attributeId < 1) {
                throw new BGIllegalArgumentException();
            }
            AttributeDao attributeDao = new AttributeDao(this.getConnection(), this.moduleId);
            Attribute attribute = (Attribute)attributeDao.get(attributeId);
            if (attribute == null || attribute.getContractId() != contractId) {
                throw new BGMessageException("attribute==null \u0438\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 contractId");
            }
            attributeDao.delete(attributeId);
        });
    }

    public List<String> positionSearch(BillPositionType billPositionType, Page page) throws BGException {
        ArrayList<String> list = new ArrayList<String>();
        this.resetModuleSetup();
        ModuleSetup moduleSetup = this.getModuleSetup();
        switch (billPositionType) {
            case BILL: {
                list.addAll(this.buildPositionList(moduleSetup.sub("bill.pos.")));
                break;
            }
            case INVOICE: {
                list.addAll(this.buildPositionList(moduleSetup.sub("invoice.pos.")));
                break;
            }
        }
        return list;
    }

    public void positionDataUpdate(BillPositionType billPositionType, String positionData) throws BGException {
        this.tryCall(() -> {
            ConfigDAO configDAO = new ConfigDAO(this.getConnection());
            ConfigData configData = configDAO.getActiveConfig(this.moduleId);
            if (configData == null) {
                throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f [moduleId=" + this.moduleId + "]");
            }
            ArrayList<CallSite> config = new ArrayList<CallSite>();
            Stream.of(configData.getConfig().split("\n")).forEach(e -> config.add((CallSite)e));
            JSONObject json = new JSONObject(positionData);
            String prefix = (billPositionType == BillPositionType.BILL ? "bill" : "invoice") + ".pos." + json.optString("key") + ".";
            json.remove("id");
            json.remove("key");
            for (String key : json.keySet()) {
                boolean update = false;
                String value = json.getString(key);
                for (int index = 0; index < config.size(); ++index) {
                    String line = (String)config.get(index);
                    if (!line.startsWith(prefix + key + "=")) continue;
                    if (Utils.isBlankString((String)value)) {
                        config.remove(index);
                    } else {
                        config.set(index, (CallSite)((Object)(prefix + key + "=" + value)));
                    }
                    update = true;
                    break;
                }
                if (update || !Utils.notBlankString((String)value)) continue;
                config.add((CallSite)((Object)(prefix + key + "=" + value)));
            }
            StringBuffer stringBuffer = new StringBuffer();
            config.stream().forEach(l -> stringBuffer.append(stringBuffer.length() > 0 ? "\n" : "").append((String)l));
            configData.setConfig(stringBuffer.toString());
            configDAO.update((Object)configData);
            EventProcessor.getInstance().publish((Event)new ModuleConfigModifiedEvent(this.moduleId, this.userId));
        });
    }

    public void positionDataDelete(BillPositionType billPositionType, String key) throws BGException {
        this.tryCall(() -> {
            ConfigDAO configDAO = new ConfigDAO(this.getConnection());
            ConfigData configData = configDAO.getActiveConfig(this.moduleId);
            if (configData == null) {
                throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f [moduleId=" + this.moduleId + "]");
            }
            ArrayList config = new ArrayList();
            Stream.of(configData.getConfig().split("\n")).forEach(e -> config.add(e));
            String prefix = (billPositionType == BillPositionType.BILL ? "bill" : "invoice") + ".pos." + key + ".";
            for (int index = config.size() - 1; index >= 0; --index) {
                String line = (String)config.get(index);
                if (!line.startsWith(prefix)) continue;
                config.remove(index);
            }
            StringBuffer stringBuffer = new StringBuffer();
            config.stream().forEach(l -> stringBuffer.append(stringBuffer.length() > 0 ? "\n" : "").append((String)l));
            configData.setConfig(stringBuffer.toString());
            configDAO.update((Object)configData);
            EventProcessor.getInstance().publishAfterCommit((Event)new ModuleConfigModifiedEvent(this.moduleId, this.userId));
        });
    }

    private List<String> buildPositionList(ParameterMap subMap) {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, HashMap<String, String>> maps = new HashMap<String, HashMap<String, String>>();
        for (Map.Entry entry : subMap.entrySet()) {
            int pos = ((String)entry.getKey()).indexOf(46);
            if (pos <= 0) continue;
            String key = ((String)entry.getKey()).substring(0, pos);
            HashMap<String, String> map = (HashMap<String, String>)maps.get(key);
            if (map == null) {
                map = new HashMap<String, String>();
                maps.put(key, map);
            }
            map.put(((String)entry.getKey()).substring(pos + 1), (String)entry.getValue());
        }
        int id = 1;
        for (Map.Entry entry : maps.entrySet()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", id++);
            jsonObject.put("key", entry.getKey());
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                jsonObject.put((String)entry1.getKey(), entry1.getValue());
            }
            list.add(jsonObject.toString());
        }
        return list;
    }

    public void numerationPoolDelete(int id) throws BGException {
        this.tryCall(() -> new NumerationPoolManager(this.getConnection(), this.moduleId, this.userId).delete(id));
    }

    public NumerationPool numerationPoolGet(int id) throws BGException {
        return (NumerationPool)this.tryReturn(() -> (NumerationPool)new NumerationPoolManager(this.getConnection(), this.moduleId, this.userId).get(id));
    }

    public List<NumerationPool> numerationPoolList() throws BGException {
        return (List)this.tryReturn(() -> new NumerationPoolManager(this.getConnection(), this.moduleId, this.userId).list());
    }

    public void numerationPoolUpdate(NumerationPool numerationPool) throws BGException {
        this.tryCall(() -> new NumerationPoolManager(this.getConnection(), this.moduleId, this.userId).update((Id)numerationPool));
    }

    public List<LogEntry> logList(String filter, Object ... args) throws BGException {
        NumerationPoolManager numerationPoolManager = new NumerationPoolManager(this.getConnection(), this.moduleId, this.userId);
        if ("oid".equals(filter)) {
            return numerationPoolManager.logListByOid((Integer)args[0]);
        }
        return numerationPoolManager.logListByCid((Integer)args[0]);
    }

    public DocTypes documentTypes(int contractId, DocumentType documentType) throws BGException {
        return (DocTypes)this.tryReturn(() -> {
            Objects.requireNonNull(documentType, "documentType must be not null");
            DocTypes docTypes = new DocTypes();
            DocTypeManager docTypeManager = new DocTypeManager(this.getConnection(), this.moduleId);
            ContractDocTypeManager cdtm = new ContractDocTypeManager(this.getConnection(), this.moduleId);
            List<DocType> avaliable = docTypeManager.getTypeList(documentType);
            List<ContractDocType> selected = cdtm.getContractTypeList(contractId, documentType, null);
            for (DocType dt : avaliable) {
                boolean isIn = false;
                for (ContractDocType contractDocType : selected) {
                    if (contractDocType.getDocTypeId() != dt.getId()) continue;
                    isIn = true;
                }
                (isIn ? docTypes.getSelectList() : docTypes.getAvaliableList()).add(dt.toIdTitle());
            }
            return docTypes;
        });
    }

    public List<IdTitle> docTypeTitles(int contractId, DocumentType documentType) throws BGException {
        return (List)this.tryReturn(() -> this.docTypeListForContract(contractId, documentType).stream().map(IdTitle::toIdTitle).toList());
    }

    public List<IdTitle> contractParameters() throws BGException {
        return (List)this.tryReturn(() -> this.context.getDirectory(ContractParameterGroupAttr.class, 0).list().stream().map(IdTitle::toIdTitle).toList());
    }

    public BigDecimal rateVATGet() throws BGException {
        return Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).getBigDecimal("bill.nds", BigDecimal.ONE);
    }

    public List<KeyValue> exportFormats(String docType) throws BGException {
        return (List)this.tryReturn(() -> {
            ArrayList<KeyValue> formats = new ArrayList<KeyValue>();
            DynamicClassManager classManager = DynamicClassManager.getInstance();
            for (String className : new DynamicCodeDao(this.getConnection()).getActualClassesByInterface("ru.bitel.bgbilling.modules.bill.common.export.BillDocumentExport")) {
                BillDocumentExport billDocumentExport;
                Object obj;
                Class clazz = classManager.loadClass(className);
                if (Modifier.isAbstract(clazz.getModifiers()) || !((obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0])) instanceof BillDocumentExport) || !(billDocumentExport = (BillDocumentExport)obj).getExportDocumentType().equals(docType)) continue;
                formats.add(new KeyValue(clazz.getName(), billDocumentExport.getTitle()));
            }
            return formats;
        });
    }

    public BillExportInfo exportInfo(String exportClass) throws BGException {
        return (BillExportInfo)this.tryReturn(() -> {
            BillExportInfo exportInfo = null;
            Object obj = Class.forName(exportClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof BillDocumentExport) {
                BillDocumentExport billDocumentExport = (BillDocumentExport)obj;
                exportInfo = new BillExportInfo().setExportSaveFile(billDocumentExport.getSaveFile()).setDescription(billDocumentExport.getDescription());
            }
            return exportInfo;
        });
    }

    public BillAccountsReceivableDetail billAccountsReceivableDetail(int contractId, LocalDate onDate) throws BGException {
        return (BillAccountsReceivableDetail)this.tryReturn(() -> new BillAccountsReceivableManager(this.getConnection(), this.moduleId).getBillAccountsReceivableDetail(contractId, onDate));
    }

    public String billExport(String exportClass, BillListFilter billListFilter, boolean saveOnServer) throws BGException {
        return (String)this.tryReturn(() -> {
            Objects.requireNonNull(exportClass, "exportClass must be not null");
            Objects.requireNonNull(billListFilter, "billListFilter must be not null");
            Object obj = Class.forName(exportClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof BillDocumentExport) {
                BillDocumentExport billDocumentExport = (BillDocumentExport)obj;
                return billDocumentExport.doExport(this.getConnection(), this.moduleId, billListFilter, saveOnServer);
            }
            return null;
        });
    }

    public List<BillLink> billLinkList() throws BGException {
        try (BillLinkDao billLinkDao = new BillLinkDao(this.getConnection(), this.moduleId);){
            List<BillLink> list = billLinkDao.list();
            return list;
        }
    }

    public void billLinkUpdate(BillLink billLink) throws BGException {
        this.tryCall(() -> {
            if (billLink != null) {
                billLink.setUserId(this.userId);
                try (BillLinkDao billLinkDao = new BillLinkDao(this.getConnection(), this.moduleId);){
                    billLinkDao.update(billLink);
                }
            }
        });
    }
}

