/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.bean;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.bill.client.bean.BGBillTablePos;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;

public class BillPositionsEditorTab
extends BGPanel {
    private BGUTable posTable = null;
    private int currentPosNumber = 0;
    private List<BGBillTablePos> currentPosList;
    private ActionListener actionListener;
    private Node positions = null;
    private PositionsTableModel positionsTableModel = new PositionsTableModel();

    public BillPositionsEditorTab(ActionListener actionListener) {
        this.actionListener = actionListener;
        this.posTable = new BGUTable((TableModel)((Object)this.positionsTableModel));
        this.tryCall(() -> this.jbInit());
    }

    public void setBorder(Border border) {
        this.add(Box.createVerticalGlue(), new GridBagConstraints(3, 0, 1, 2, 0.0, 1.0, 16, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 16, 1, new Insets(0, 5, 0, 0), 0, 0));
        super.setBorder(border);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.posTable.setEnabled(enabled);
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.posTable), new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.posTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && BillPositionsEditorTab.this.posTable.isEnabled()) {
                    BillPositionsEditorTab.this.posAction("editItem");
                }
            }
        });
    }

    protected void posAction(String command) {
        if (command.equals("editItem")) {
            this.currentPosNumber = this.posTable.getSelectedRow();
            if (this.currentPosNumber >= 0) {
                this.startEdit();
            }
        }
        if (command.equals("newItem")) {
            this.currentPosNumber = -1;
            this.startEdit();
        } else if (command.compareTo("deleteItem") == 0) {
            this.currentPosNumber = this.posTable.getSelectedRow();
            if (this.currentPosNumber >= 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u0437\u0438\u0446\u0438\u044e?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                this.deletePos(this.currentPosNumber);
            }
        } else if (command.compareTo("refresh") == 0 && this.currentPosList != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430?", "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            this.actionListener.actionPerformed(new ActionEvent((Object)this, 0, "refresh"));
        }
    }

    public void setPositionList(Node node) {
        this.positions = node;
    }

    private void startEdit() {
        if (this.currentPosList != null) {
            this.tryCall(() -> {
                BGBillTablePos pos = new BGBillTablePos().setQuantity(BigDecimal.ONE.setScale(0)).setUnit("\u0448\u0442.").setSum(BigDecimal.ZERO);
                if (this.currentPosNumber >= 0) {
                    pos = this.currentPosList.get(this.posTable.convertRowIndexToModel(this.currentPosNumber));
                }
                BigDecimal valueRateVAT = ((BillService)this.getContext().getWebService(BillService.class)).rateVATGet();
                new PositionEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u043e\u0437\u0438\u0446\u0438\u0438", pos, valueRateVAT).open();
            });
        }
    }

    private void deletePos(int posId) {
        if (posId < this.currentPosList.size()) {
            this.currentPosList.remove(posId);
            this.actionListener.actionPerformed(new ActionEvent((Object)this, 0, "deletePos"));
            this.showPositions();
        }
    }

    public void showPositions(List<BGBillTablePos> posList) {
        this.currentPosList = posList;
        this.showPositions();
    }

    private void showPositions() {
        this.positionsTableModel.setData(this.currentPosList != null ? this.currentPosList : new ArrayList());
    }

    public final void serializePositions(Element positions) {
        for (BGBillTablePos pos : this.currentPosList) {
            Element posEl = positions.getOwnerDocument().createElement("pos");
            pos.toElement(posEl);
            positions.appendChild(posEl);
        }
    }

    class PositionsTableModel
    extends BGTableModel<BGBillTablePos> {
        public PositionsTableModel() {
            super(PositionsTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 100, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 150, 150, 150, "sum", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", 100, 100, 100, "quantity", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0415\u0434\u0438\u043d\u0438\u0446\u044b", 100, 100, 100, "unit", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }
    }

    class PositionEditorDialog
    extends BGEditorDialog<BGBillTablePos> {
        private BigDecimal valueRateVAT;
        private BGComboBox<ComboBoxItem> position;
        private BGTextField positionTitle;
        private BGFloatTextField sum;
        private BGFloatTextField rateVAT;
        private BGFloatTextField sumVAT;
        private BGFloatTextField cost;
        private BGFloatTextField quantity;
        private BGTextField unit;

        public PositionEditorDialog(String title, BGBillTablePos data, BigDecimal valueRateVAT) {
            super(title, (Object)data);
            this.position = new BGComboBox();
            this.positionTitle = new BGTextField(50);
            this.sum = new BGFloatTextField(10);
            this.rateVAT = new BGFloatTextField(10);
            this.sumVAT = new BGFloatTextField(10);
            this.cost = new BGFloatTextField(10);
            this.quantity = new BGFloatTextField(10);
            this.unit = new BGTextField(10);
            this.valueRateVAT = valueRateVAT;
        }

        public void doDialogPanel() {
            this.addFieldV("\u041f\u043e\u0437\u0438\u0446\u0438\u044f:", (JComponent)this.position);
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", (JComponent)this.positionTitle);
            this.panel.add((Component)this.getAmountPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getSumPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.tryCall(() -> {
                Element posNode = XMLUtils.selectElement((Node)BillPositionsEditorTab.this.positions, (String)"//positions/positionsCB");
                ClientUtils.buildComboBox(this.position, (Node)posNode, null);
                for (int j = 0; j < this.position.getItemCount(); ++j) {
                    ComboBoxItem item = (ComboBoxItem)this.position.getItemAt(j);
                    if (!item.getObject().equals(String.valueOf(((BGBillTablePos)this.data).getPositionId()))) continue;
                    this.position.setSelectedIndex(j);
                    break;
                }
                this.rateVAT.setText(this.valueRateVAT.toString());
                this.positionTitle.setText(((BGBillTablePos)this.data).getName());
                this.sum.setText(Utils.formatBigDecimalSumm((BigDecimal)((BGBillTablePos)this.data).getSum()));
                this.quantity.setText(Utils.maskNull((BigDecimal)((BGBillTablePos)this.data).getQuantity()).setScale(((BGBillTablePos)this.data).qtynums, RoundingMode.valueOf(((BGBillTablePos)this.data).qtynumsRnd)).toString());
                this.unit.setText(((BGBillTablePos)this.data).getUnit());
                this.position.addItemListener(e -> {
                    ComboBoxItem item;
                    if (e.getStateChange() == 1 && (item = (ComboBoxItem)this.position.getSelectedItem()) != null) {
                        String title = item.toString();
                        this.positionTitle.setText(title);
                        if (Utils.notBlankString((String)title)) {
                            this.tryCall(() -> {
                                Element posit = XMLUtils.selectElement((Node)BillPositionsEditorTab.this.positions, (String)("pos[@id=" + Utils.parseInt((String)((String)item.getObject()), (int)0) + "]"));
                                this.unit.setText(posit.getAttribute("unit").isEmpty() ? "\u0448\u0442." : posit.getAttribute("unit"));
                            });
                        }
                    }
                });
                this.calcCost();
            });
        }

        private JPanel getAmountPanel() {
            this.quantity.setHorizontalAlignment(0);
            this.quantity.addActionListener(e -> this.calcSum());
            this.unit.setHorizontalAlignment(0);
            this.unit.setEnabled(false);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041a\u043e\u043b-\u0432\u043e:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0415\u0434\u0438\u043d\u0438\u0446\u044b:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.quantity, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 10), 0, 0));
            panel.add((Component)this.unit, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getSumPanel() {
            this.rateVAT.setEnabled(false);
            this.sumVAT.setEnabled(false);
            this.sum.setHorizontalAlignment(0);
            this.sum.addActionListener(e -> this.calcCost());
            this.cost.addActionListener(e -> this.calcSum());
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0426\u0435\u043d\u0430 \u0437\u0430 \u0435\u0434.:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0421\u0442\u0430\u0432\u043a\u0430 \u041d\u0414\u0421 (%):"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430 \u041d\u0414\u0421:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430 \u0441 \u041d\u0414\u0421:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.cost, new GridBagConstraints(-1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 10), 0, 0));
            panel.add((Component)this.rateVAT, new GridBagConstraints(-1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 10), 0, 0));
            panel.add((Component)this.sumVAT, new GridBagConstraints(-1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 10), 0, 0));
            panel.add((Component)this.sum, new GridBagConstraints(-1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private void calcSum() {
            BigDecimal c = Utils.parseBigDecimal((String)this.cost.getText(), (BigDecimal)BigDecimal.ZERO);
            BigDecimal a = Utils.parseBigDecimal((String)this.quantity.getText(), (BigDecimal)BigDecimal.ZERO);
            BigDecimal sc = c.multiply(a).setScale(2, RoundingMode.HALF_UP);
            BigDecimal v = sc.multiply(this.valueRateVAT).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
            this.sum.setText(sc.add(v).setScale(2, RoundingMode.HALF_UP).toPlainString());
            this.sumVAT.setText(v.toPlainString());
        }

        private void calcCost() {
            BigDecimal s = Utils.parseBigDecimal((String)this.sum.getText(), (BigDecimal)BigDecimal.ZERO);
            BigDecimal a = Utils.parseBigDecimal((String)this.quantity.getText(), (BigDecimal)BigDecimal.ZERO);
            BigDecimal sc = s.multiply(new BigDecimal(100)).divide(new BigDecimal(100).add(this.valueRateVAT), 2, RoundingMode.HALF_UP);
            BigDecimal v = sc.multiply(this.valueRateVAT).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
            this.cost.setText(a.compareTo(BigDecimal.ZERO) > 0 ? s.subtract(v).divide(a, 2, RoundingMode.HALF_UP).toPlainString() : "");
            this.sumVAT.setText(v.toPlainString());
        }

        public boolean doApply() throws Exception {
            Element posit;
            if (Utils.isBlankString((String)this.quantity.getText()) || Utils.parseBigDecimal((String)this.quantity.getText(), (BigDecimal)BigDecimal.ZERO).compareTo(BigDecimal.ZERO) < 1) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e!");
                return false;
            }
            if (Utils.isBlankString((String)this.sum.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0441\u0443\u043c\u043c\u0443!");
                return false;
            }
            BGBillTablePos pos = BillPositionsEditorTab.this.currentPosNumber < 0 ? new BGBillTablePos() : BillPositionsEditorTab.this.currentPosList.get(BillPositionsEditorTab.this.currentPosNumber);
            Object item = this.position.getSelectedItem();
            if (item instanceof ComboBoxItem) {
                ComboBoxItem _item = (ComboBoxItem)this.position.getSelectedItem();
                pos.setPositionId(Utils.parseInt((String)((String)_item.getObject()), (int)0));
                pos.setName(Utils.isEmptyString((String)this.positionTitle.getText()) ? _item.toString() : this.positionTitle.getText());
            } else {
                pos.setPositionId(0);
                pos.setName(this.positionTitle.getText());
            }
            pos.setSum(Utils.parseBigDecimal((String)this.sum.getText().replace(',', '.'), (BigDecimal)BigDecimal.ZERO));
            pos.sumUnscaled = pos.getSum();
            pos.setQuantity(Utils.parseBigDecimal((String)this.quantity.getText().replace(',', '.'), (BigDecimal)BigDecimal.ZERO));
            pos.qtynums = pos.getQuantity().scale();
            pos.setUnit(this.unit.getText());
            pos.unitCode = !Utils.notBlankString((String)pos.unitCode) ? ((posit = XMLUtils.selectElement((Node)BillPositionsEditorTab.this.positions, (String)("pos[@id=" + pos.getPositionId() + "]"))).getAttribute("unitCode").isEmpty() ? "796" : posit.getAttribute("unitCode")) : pos.unitCode;
            if (BillPositionsEditorTab.this.currentPosNumber < 0) {
                BillPositionsEditorTab.this.currentPosList.add(pos);
            }
            BillPositionsEditorTab.this.showPositions();
            BillPositionsEditorTab.this.actionListener.actionPerformed(new ActionEvent((Object)this, 0, "stopEdit"));
            return true;
        }
    }
}

