/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogGroup;
import ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;

public class BotDialogSelectGroupPanel
extends BGUPanel
implements ActionListener {
    private final BotManagerService botManagerService;
    private BGControlPanelListSelect selectedGroupsList;
    private BGControlPanelListSelect avaliableGroupsList;
    private JButton addSelectedGroups = new JButton("<<");
    private JButton removeSelectedGroups = new JButton(">>");
    private List<BotDialogGroup> allGroups;
    private BotDialog currentDialog = null;

    protected BotDialogSelectGroupPanel(BotManagerService botManagerService) {
        this.botManagerService = botManagerService;
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
        this.init();
    }

    protected void jbInit() throws Exception {
        this.selectedGroupsList = new BGControlPanelListSelect();
        this.avaliableGroupsList = new BGControlPanelListSelect();
        this.addSelectedGroups.addActionListener(this);
        this.removeSelectedGroups.addActionListener(this);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 3, 3);
        JPanel selectedGroupsPanel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)selectedGroupsPanel, (String)"\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0433\u0440\u0443\u043f\u043f\u044b");
        selectedGroupsPanel.add((Component)new JScrollPane((Component)this.selectedGroupsList), constraints);
        JPanel avaliableGroupsPanel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)avaliableGroupsPanel, (String)"\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0433\u0440\u0443\u043f\u043f\u044b");
        avaliableGroupsPanel.add((Component)new JScrollPane((Component)this.avaliableGroupsList), constraints);
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add(Box.createVerticalStrut(50), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        controlPanel.add((Component)this.addSelectedGroups, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        controlPanel.add((Component)this.removeSelectedGroups, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        controlPanel.add(Box.createGlue(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        constraints.gridx = -1;
        this.add(selectedGroupsPanel, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(controlPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(avaliableGroupsPanel, new GridBagConstraints(2, 0, 1, 2, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.allGroups = this.botManagerService.getDialogGroups();
            this.avaliableGroupsList.getListModel().clear();
            ClientUtils.buildList((JList)this.avaliableGroupsList.getList(), this.allGroups);
            this.selectedGroupsList.getListModel().clear();
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.currentDialog == null) {
            ClientUtils.showErrorMessageDialog((String)"\u041f\u0435\u0440\u0435\u0434 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u0433\u0440\u0443\u043f\u043f\u0430\u043c\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u0438\u0430\u043b\u043e\u0433");
            return;
        }
        ArrayList<BotDialogGroup> groupsForUpdate = new ArrayList<BotDialogGroup>();
        if (e.getActionCommand().equals("<<")) {
            List selectedIds = Arrays.stream(this.avaliableGroupsList.getSelectedIds()).boxed().collect(Collectors.toList());
            Set wasSelected = Collections.list(this.selectedGroupsList.getListModel().elements()).stream().mapToInt(item -> Utils.parseInt((String)item.getAttribute("id").toString())).boxed().collect(Collectors.toSet());
            wasSelected.addAll(selectedIds);
            this.currentDialog.setGroups(new HashSet(wasSelected));
            for (BotDialogGroup group : this.allGroups) {
                if (!selectedIds.contains(group.getId())) continue;
                List dialogIds = Utils.toIntegerList((String)group.getDialogIds());
                dialogIds.add(this.currentDialog.getId());
                group.setDialogIds(Utils.toString((Iterable)dialogIds, (String)","));
                groupsForUpdate.add(group);
            }
        } else if (e.getActionCommand().equals(">>")) {
            List selectedForRemove = Arrays.stream(this.selectedGroupsList.getSelectedIds()).boxed().collect(Collectors.toList());
            this.currentDialog.getGroups().removeAll(selectedForRemove);
            for (BotDialogGroup group : this.allGroups) {
                if (!selectedForRemove.contains(group.getId())) continue;
                List dialogsOfGroup = Utils.toIntegerList((String)group.getDialogIds());
                dialogsOfGroup.removeAll(selectedForRemove);
                group.setDialogIds(Utils.toString((Iterable)dialogsOfGroup, (String)","));
                groupsForUpdate.add(group);
            }
        }
        try {
            this.botManagerService.updateDialog(this.currentDialog);
            this.botManagerService.updateDialogGroups(groupsForUpdate);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.avaliableGroupsList.setListItemSelected(false);
        this.selectedGroupsList.setListItemSelected(false);
        this.setCurrentDialog(this.currentDialog);
    }

    protected void setCurrentDialog(BotDialog botDialog) {
        this.currentDialog = botDialog;
        if (this.currentDialog != null) {
            this.loadGroups();
        } else {
            this.selectedGroupsList.getListModel().clear();
        }
    }

    protected Set<Integer> getSelectedGroupsOfCurrentDialog() {
        return Collections.list(this.selectedGroupsList.getListModel().elements()).stream().mapToInt(i -> Utils.parseInt((String)i.getAttribute("id").toString())).boxed().collect(Collectors.toSet());
    }

    protected void loadGroups() {
        Set groupsIds = this.currentDialog.getGroups();
        if (groupsIds != null) {
            this.avaliableGroupsList.getListModel().clear();
            ClientUtils.buildList((JList)this.avaliableGroupsList.getList(), this.allGroups);
            this.selectedGroupsList.getListModel().clear();
            ClientUtils.buildList((JList)this.selectedGroupsList.getList(), this.allGroups.stream().filter(gr -> groupsIds.contains(gr.getId())).collect(Collectors.toList()));
        }
    }
}

