package ru.bitel.bgbilling.modules.botmanager.dyn.auth;

import java.sql.Connection;
import java.time.LocalDate;

import org.json.JSONObject;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessing;

public class ContractDataAfterAuth
    implements DialogProcessing
{
    private final static int FIRST_NAME_PID = 195;
    private final static int LAST_NAME_PID = 194;

    @Override
    public void preDialog( ServerContext serverContext, JSONObject chatData )
        throws BGException
    {
        int contractId = chatData.optInt( CONTRACT_ID, -1 );
        if ( contractId > 0 )
        {
            Connection connection = serverContext.getConnection();
            try ( BalanceUtils balanceUtils = new BalanceUtils( serverContext.getConnection() ) )
            {
                Contract contract = ContractDao.getContract( connection, contractId );
                if ( contract != null )
                {
                    try ( ContractDao contractDao = new ContractDao( connection, User.USER_SERVER ) )
                    {
                        JSONObject macros = new JSONObject()
                            .put( "firstName", contractDao.optContractParameterTextAsString( contractId, FIRST_NAME_PID ).orElse( "" ) )
                            .put( "lastName", contractDao.optContractParameterTextAsString( contractId, LAST_NAME_PID ).orElse( "" ) )
                            .put( "status", contract.getStatus() == 0 ? "Активен" : "Приостановлен" )
                            .put( "balance", balanceUtils.getBalance( LocalDate.now(), contractId ).toString() );

                        chatData.put( MACROS, macros );
                    }
                }
            }
        }
    }

    @Override
    public void processDialog( ServerContext serverContext, JSONObject chatData, String inputMessage )
    {}

    @Override
    public String title()
    {
        return "Отображение данных диалога после авторизации";
    }
}