/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.DealerManager;
import ru.bitel.common.TimeUtils;

public class ActionDealerList
extends ActionBase {
    public void doAction() throws Exception {
        int mid = this.getIntParameter("mid", -1);
        int type = this.getIntParameter("type", 0);
        String title = this.getParameter("title");
        Calendar from = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date1"));
        Calendar until = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date2"));
        if (mid < 0) {
            throw new BGIllegalArgumentException();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        List<Dealer> dealerList = new DealerManager(this.con, mid).getDealerList(title, from, until, type);
        for (Dealer dealer : dealerList) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(dealer.getId()));
            row.setAttribute("title", dealer.getTitle());
            row.setAttribute("period", TimeUtils.formatPeriod((Calendar)dealer.getDate1(), (Calendar)dealer.getDate2()));
            row.setAttribute("comment", dealer.getComment());
            row.setAttribute("payment_type", String.valueOf(dealer.getPt()));
            row.setAttribute("statistics", dealer.getStatRequest() + "/" + dealer.getStatFinded() + "/" + dealer.getStatPayed());
            row.setAttribute("block", dealer.getError() > 5 ? "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d" : "\u0430\u043a\u0442\u0438\u0432\u0435\u043d");
        }
    }
}

