/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.servlet;

import bitel.billing.server.Action;
import bitel.billing.server.ActionResultContentType;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.bean.DealerManager;
import ru.bitel.bgbilling.modules.card.server.idealer.DealerFindException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@WebServlet(name="cardIDealerExecuter", urlPatterns={"/idealer"})
public class IDealerExecuter
extends CommonExecutor {
    public void init() {
        this.setup = Setup.getSetup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkUser(HttpServletRequest request, Element rootNode, Connection __con) {
        String msg = "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0438/\u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b";
        String error = "3";
        int mid = Utils.parseInt((String)request.getParameter("mid"), (int)-1);
        boolean result = false;
        HttpSession session = request.getSession(true);
        Dealer dealer = (Dealer)session.getAttribute("dealer_" + mid);
        if (dealer == null) {
            this.getLoginAndPassword(request);
            String userName = (String)request.getAttribute("userName");
            String userPswd = (String)request.getAttribute("userPswd");
            if (userName != null && userPswd != null && mid > -1) {
                Connection con = this.setup.getDBConnectionFromPool();
                try {
                    Contract contract;
                    DealerManager manager = new DealerManager(con, mid);
                    dealer = manager.getDealer(userName, userPswd);
                    session.setAttribute("dealer_" + mid, (Object)dealer);
                    if (dealer.getContractId() > 0 && (contract = ContractDao.getContract((Connection)con, (int)dealer.getContractId())) != null) {
                        session.setAttribute("dealer_contract_" + mid, (Object)contract);
                    }
                    request.setAttribute("BGAtrr_InitEnter", (Object)true);
                    result = true;
                }
                catch (DealerFindException e) {
                    msg = e.getErrmsg();
                    error = e.getErrcode();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    ServerUtils.closeConnection((Connection)con);
                }
            } else {
                msg = "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0438/\u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b";
                error = "3";
            }
        } else {
            result = true;
        }
        if (!result) {
            this.setErrorStatus(rootNode, msg, error);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doModule(HttpServletRequest request, HttpServletResponse response, Element rootNode) throws Exception {
        String action = request.getParameter("action");
        if (action == null) {
            this.setErrorStatus(rootNode, "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0438/\u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", "3");
            return;
        }
        String className = "ru.bitel.bgbilling.modules.card.server.action.idealer.Action" + action;
        Action actionClass = null;
        try {
            actionClass = (Action)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            actionClass.init(this.setup, rootNode, request, response, this.servletContext);
            actionClass.doAction();
            actionClass.commit();
        }
        catch (Exception ex) {
            this.setErrorStatus(rootNode, "\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 action \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", "7");
            ex.printStackTrace();
        }
        finally {
            if (actionClass != null) {
                actionClass.freeConnection();
            }
        }
    }

    private void setErrorStatus(Element rootNode, String msg, String error_code) throws DOMException {
        rootNode.setAttribute("status", "error");
        rootNode.setAttribute("error_code", error_code);
        rootNode.appendChild(rootNode.getOwnerDocument().createTextNode(msg));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = null;
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootNode = doc.createElement("data");
            rootNode.setAttribute("status", "ok");
            doc.appendChild(rootNode);
            request.setAttribute("rootNode", (Object)rootNode);
            ActionResultContentType.xml.set((ServletRequest)request);
            if (this.checkUser(request, rootNode, null)) {
                this.doModule(request, response, rootNode);
            } else {
                response.setHeader("WWW-Authenticate", "Basic realm=\"BGBilling Idealer\"");
                response.sendError(401, "Authenticate error.");
            }
            Object contentType = request.getAttribute("contentType");
            if (ActionResultContentType.xml.isEquals(contentType)) {
                response.setContentType("text/xml; charset=UTF-8");
                ServerUtils.addNoCache((HttpServletResponse)response);
                out = response.getWriter();
                out.write(XMLUtils.serializeToString((Node)doc.getDocumentElement(), (boolean)false));
            }
        }
        catch (Exception e) {
            if (out == null) {
                e.printStackTrace();
            } else {
                e.printStackTrace(out);
            }
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }
}

