/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.client;

import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.card.client.CardMoveEditor;
import ru.bitel.bgbilling.modules.card.client.ServiceConfigManagerCard;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class CardAddEditor
extends CardMoveEditor {
    private BGTable countTable = new BGTable();

    public CardAddEditor(ServiceConfigManagerCard cardManager) {
        super(cardManager);
        this.countTable.setHeader(((ClientContext)this.getContext()).getResourceBundleName(), ((ClientContext)this.getContext()).getModuleDoc(), "add_count");
    }

    @Override
    protected void jbInit() throws Exception {
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(100, 300));
        this.setPreferredSize(new Dimension(100, 300));
        this.setBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u043a\u0430\u0440\u0442 \u0434\u0438\u043b\u0435\u0440\u0443 "));
        this.add(new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u043a\u0430\u0440\u0442 \u0432 \u0441\u0435\u0440\u0438\u044f\u0445:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.countTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JLabel("\u041b\u0438\u0431\u043e \u0441\u0435\u0440\u0438\u0439\u043d\u044b\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 (" + this.HELP_STRING + "):"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.serialsTf, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)okCancel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 5, 5), 0, 0));
    }

    public void startEdit() {
        Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setModuleId(((ClientContext)this.getContext()).getModuleId()).setAction("NotEmptySeriesTable");
        Document doc = ((ClientContext)this.getContext()).getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.countTable.updateData((Node)XMLUtils.getElement((Document)doc, (String)"table"));
        }
        this.setVisible(true);
    }

    private void stopEdit(boolean add) {
        if (add) {
            StringBuilder seriesCount = new StringBuilder();
            int size = this.countTable.getRowCount();
            for (int i = 0; i < size; ++i) {
                int series = Utils.parseInt((String)this.countTable.getRowId(i, "id"));
                int count = Utils.parseInt((String)this.countTable.getRowId(i, "count"));
                if (series <= 0 || count <= 0) continue;
                if (seriesCount.length() > 0) {
                    seriesCount.append(";");
                }
                seriesCount.append(series);
                seriesCount.append(":");
                seriesCount.append(count);
            }
            String serials = this.getSerials();
            if (seriesCount.length() == 0 && serials.length() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u044b \u043a\u0430\u0440\u0442\u044b \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438!");
                return;
            }
            Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setAction("CardDealerAdd").setModuleId(((ClientContext)this.getContext()).getModuleId()).setAttribute("did", this.dealerId);
            if (seriesCount.length() > 0) {
                request.setAttribute("series_count", (Object)seriesCount);
            } else {
                request.setAttribute("buf", serials);
            }
            Document doc = ((ClientContext)this.getContext()).getDocument(request);
            if (!ClientUtils.checkStatus((Document)doc)) {
                return;
            }
        }
        this.cardManager.stopCardMove();
        this.setVisible(false);
    }
}

