/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ActionDealerPaymentAdd
extends ActionBase {
    public void doAction() throws Exception {
        PreparedStatement ps;
        Object query;
        int mid = this.getIntParameter("mid", -1);
        int cid = this.getIntParameter("cid", -1);
        String title = this.getParameter("title", null);
        BigDecimal summa = this.getBigDecimalParameter("summa", BigDecimal.ZERO);
        String comment = this.getParameter("comment", "");
        if (cid < 1 && title != null) {
            query = "SELECT id FROM contract WHERE UPPER(title)=?";
            ps = this.con.prepareStatement((String)query);
            ps.setString(1, title.toUpperCase());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                cid = rs.getInt(1);
            }
        }
        Element paymentEl = this.createElement(this.rootNode, "payment");
        paymentEl.setAttribute("id", "-1");
        if (mid < 0 || cid < 1 || summa.floatValue() <= 0.0f) {
            throw new BGMessageException("mid < 0 || cid < 1 || summa <= 0f");
        }
        int pt = 0;
        String tableName = "card_dealer_" + mid;
        Integer dealerId = (Integer)this.session.getAttribute("user_id");
        if (ServerUtils.tableExists((Connection)this.con, (String)tableName) && dealerId != null) {
            query = "SELECT pt FROM " + tableName + " WHERE id=?";
            ps = this.con.prepareStatement((String)query);
            ps.setInt(1, dealerId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                pt = rs.getInt(1);
            }
        }
        if (pt < 1) {
            throw new BGMessageException("Not found dealer payment type.");
        }
        Date date = new Date();
        Payment payment = new Payment().setDate(date).setContractId(cid).setTypeId(pt).setSum(summa).setComment(comment);
        new PaymentDao(this.con).update((Object)payment);
        if (payment.getId() > 0) {
            paymentEl.setAttribute("id", String.valueOf(payment.getId()));
            try (BalanceUtils bu = new BalanceUtils(this.con);){
                Contract contract = ContractDao.getContract((Connection)this.con, (int)payment.getContractId());
                this.con.commit();
                bu.updateBalance(payment.getDate(), contract.getId());
                this.context.publishAfterCommit((Event)new PaymentEvent(0, payment));
                this.context.publishAfterCommit((Event)new ContractBalanceChangedEvent(contract.getId(), 3, payment.getSum()));
            }
        }
    }
}

