/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;

public class StatsCounter {
    private int intervar_sec;
    private volatile Map<String, LinkedList<StatItem>> data = new HashMap<String, LinkedList<StatItem>>();

    public StatsCounter(int intervar_sec) {
        this.intervar_sec = intervar_sec;
    }

    public synchronized void addItem(String command, double value) {
        LinkedList statitems = this.data.computeIfAbsent(command, k -> new LinkedList());
        statitems.add(new StatItem(System.currentTimeMillis(), value));
        long threshold_msec = System.currentTimeMillis() - (long)this.intervar_sec * 1000L;
        statitems.removeIf(statitem -> statitem.add_time < threshold_msec);
    }

    public synchronized Stats getStats() {
        Stats stats = new Stats();
        for (Map.Entry<String, LinkedList<StatItem>> entry : this.data.entrySet()) {
            String command = entry.getKey();
            long threshold_msec = System.currentTimeMillis() - (long)this.intervar_sec * 1000L;
            Iterator each = entry.getValue().iterator();
            while (each.hasNext()) {
                StatItem statitem = (StatItem)each.next();
                if (statitem.add_time > threshold_msec) {
                    stats.sumItem(command, statitem.value);
                    continue;
                }
                each.remove();
            }
        }
        return stats;
    }

    private static class StatItem {
        long add_time;
        double value;

        StatItem(long add_time, double value) {
            this.add_time = add_time;
            this.value = value;
        }
    }

    public static class Stats
    extends HashMap<String, CommandStat> {
        void sumItem(String command, double value) {
            CommandStat commandStat = this.computeIfAbsent(command, k -> new CommandStat());
            ++commandStat.count;
            commandStat.sum += value;
            commandStat.avg = commandStat.sum / (double)commandStat.count;
            commandStat.min = Math.min(commandStat.min, value);
            commandStat.max = Math.max(commandStat.max, value);
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "-";
            }
            return this.entrySet().stream().map(entry -> String.format("%s[%s]", entry.getKey(), ((CommandStat)entry.getValue()).toString())).collect(Collectors.joining(", "));
        }
    }

    public static class CommandStat {
        int count = 0;
        double sum = 0.0;
        double avg = 0.0;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;

        public String toString() {
            if (this.count == 0) {
                return "cnt: 0, avg: 0.00, min: -, max: -";
            }
            return String.format("cnt: %d, avg: %.2f, min: %.2f, max: %.2f", this.count, this.avg, this.min, this.max);
        }
    }
}

