/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.fisc.atolonlinev5;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckPrintResult;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.atolonlinev4.AtolOnlineV4Fiscalizator;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class AtolOnlineV5Fiscalizator
extends AtolOnlineV4Fiscalizator {
    protected String company_sno = null;

    public AtolOnlineV5Fiscalizator(Printer printer) throws BGException {
        super(printer);
        ParameterMap config = printer.getConfig();
        this.company_sno = config.get("company.sno", null);
    }

    private static Integer payObject_convert(Integer payObject) {
        if (payObject == null) {
            return null;
        }
        switch (payObject) {
            case 1212001: {
                return 1;
            }
            case 1212003: {
                return 3;
            }
            case 1212004: {
                return 4;
            }
            case 1212010: {
                return 10;
            }
            case 1212011: {
                return 11;
            }
            case 1212013: {
                return 13;
            }
        }
        return payObject;
    }

    private static int measure_convert(Integer measure) {
        if (measure == null) {
            return 0;
        }
        return measure - 2108000;
    }

    @Override
    public CheckPrintResult operation(String operation, final Check check) throws BGException {
        JSONObject data;
        logger.debug("get operation " + operation + "...");
        String token = this.getToken();
        final Date documentDate = check.getDocumentDate() != null ? check.getDocumentDate() : new Date();
        final String external_id = check.getDocumentId();
        if (external_id == null) {
            throw new BGMessageException("\u0412 \u0441\u043a\u0440\u0438\u043f\u0442\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0447\u0435\u043a\u0430 documentId");
        }
        String customerAddr = check.getCustomerEmail();
        if (customerAddr == null) {
            throw new BGMessageException("\u0412 \u0441\u043a\u0440\u0438\u043f\u0442\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d customerEmail");
        }
        final String email = customerAddr.contains("@") ? customerAddr : null;
        final String phone = !customerAddr.contains("@") ? customerAddr.replace(" ", "") : null;
        final String vat_type_total = this.vat_convert(check.getTax());
        final int payments_type = this.payment_type_convert(check.getPaymentType());
        final String payMethodTotal = AtolOnlineV5Fiscalizator.payMethod_convert(check.getPayMethod());
        final Integer payObjectTotal = AtolOnlineV5Fiscalizator.payObject_convert(check.getPayObject());
        String url = this.addr + "/" + this.groupcode + "/" + operation;
        JSONObject reply = this.doJsonRequest("POST", url, data = new JSONObject((Map)new HashMap<String, Object>(){
            {
                this.put("timestamp", TimeUtils.format((Date)documentDate, (String)"dd.MM.yyyy HH:mm:ss"));
                this.put("external_id", external_id);
                this.put("receipt", new HashMap<String, Object>(){
                    {
                        Long attr_timezone;
                        Long attr_internet;
                        this.put("client", new HashMap<String, Object>(){
                            {
                                if (email != null) {
                                    this.put("email", email);
                                }
                                if (phone != null) {
                                    this.put("phone", phone);
                                }
                            }
                        });
                        this.put("company", new HashMap<String, Object>(){
                            {
                                this.put("email", AtolOnlineV5Fiscalizator.this.company_email);
                                this.put("inn", AtolOnlineV5Fiscalizator.this.company_inn);
                                this.put("payment_address", AtolOnlineV5Fiscalizator.this.company_payment_address);
                                this.put("sno", AtolOnlineV5Fiscalizator.this.company_sno);
                            }
                        });
                        this.put("items", new ArrayList<HashMap<String, Object>>(){
                            {
                                for (final Check.CheckLine line : check.getLines()) {
                                    if (line.summa == null) continue;
                                    final String payMethod = line.payMethod != null ? AtolOnlineV5Fiscalizator.payMethod_convert(line.payMethod) : payMethodTotal;
                                    final Integer payObject = line.payObject != null ? AtolOnlineV5Fiscalizator.payObject_convert(line.payObject) : payObjectTotal;
                                    final String vat_type = line.tax != null ? AtolOnlineV5Fiscalizator.this.vat_convert(line.tax) : vat_type_total;
                                    this.add(new HashMap<String, Object>(){
                                        {
                                            this.put("name", line.text);
                                            this.put("price", line.summa);
                                            this.put("quantity", line.getFpQuantity());
                                            this.put("sum", line.getFpItemsum());
                                            this.put("measure", AtolOnlineV5Fiscalizator.measure_convert(line.measure));
                                            if (payMethod != null) {
                                                this.put("payment_method", payMethod);
                                            } else {
                                                this.put("payment_method", "full_prepayment");
                                            }
                                            if (payObject != null) {
                                                this.put("payment_object", payObject);
                                            } else {
                                                this.put("payment_object", AtolOnlineV5Fiscalizator.payObject_convert(1212004));
                                            }
                                            this.put("vat", new HashMap<String, Object>(){
                                                {
                                                    this.put("type", vat_type);
                                                    this.put("sum", AtolOnlineV5Fiscalizator.this.vat_calc(line.summa, vat_type));
                                                }
                                            });
                                        }
                                    });
                                }
                            }
                        });
                        this.put("payments", new ArrayList<HashMap<String, Object>>(){
                            {
                                this.add(new HashMap<String, Object>(){
                                    {
                                        this.put("type", payments_type);
                                        this.put("sum", check.getPaymentsum());
                                    }
                                });
                            }
                        });
                        this.put("total", check.getPaymentsum());
                        if (check.getCashierName() != null) {
                            this.put("cashier", check.getCashierName());
                        }
                        if (check.getCashierINN() != null) {
                            this.put("cashier_inn", check.getCashierINN());
                        }
                        if ((attr_internet = (Long)check.getCustomTags().get(1125)) != null) {
                            this.put("internet", attr_internet == 1L);
                        }
                        if ((attr_timezone = (Long)check.getCustomTags().get(1011)) != null) {
                            this.put("timezone", attr_timezone);
                        }
                    }
                });
            }
        }), token, true);
        if (!reply.has("uuid")) {
            throw new BGException("protocol error: no uuid field in response");
        }
        String uuid = reply.getString("uuid");
        return CheckPrintResult.async(uuid);
    }

    @Override
    public String name(String pass) throws BGException {
        return "\u0410\u0422\u041e\u041b-\u041e\u043d\u043b\u0430\u0439\u043d(v5)";
    }
}

