/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo;

import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo.CommandAddSubscription;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo.CommandRemoveSubscription;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo.CommandSendMessage;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo.CommandSubscriptionsList;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo.CommandUpdateParameters;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo.EnigoCasCommand;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo.EnigoCasException;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class EnigoCasCon
extends BGLogger {
    private String host;
    private String apikey;
    private int osdRepetition;
    private int osdDuration;
    private int osdInterval;
    private boolean emailEnable;
    private boolean osdEnable;
    private int cmd2type;

    public EnigoCasCon(ParameterMap preferences, int serverId) throws BGException {
        this.host = preferences.get("host", null);
        this.apikey = preferences.get("apikey", null);
        if (Utils.isEmptyString((String)this.host) || Utils.isEmptyString((String)this.apikey)) {
            throw new BGException("Host or apikey for server " + serverId + " undefined!");
        }
        this.osdRepetition = preferences.getInt("osdRepetition", 1);
        this.osdDuration = preferences.getInt("osdDuration", 30);
        this.osdInterval = preferences.getInt("osdInterval", 60);
        this.emailEnable = preferences.getBoolean("emailEnable", true);
        this.osdEnable = preferences.getBoolean("osdEnable", true);
        this.cmd2type = preferences.getInt("cmd2type", 0);
    }

    private static String getUrl(String url) throws Exception {
        try (HttpClient httpClient = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
            String string = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
            return string;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendCommand(EnigoCasCommand command) throws EnigoCasException, BGException, Exception {
        StringBuilder query = new StringBuilder(666);
        query.append(this.host).append("?api-key=").append(this.apikey);
        query.append("&command=").append(command.getCommandNumber());
        for (Map.Entry<String, Object> param : command.getParamMap().entrySet()) {
            query.append("&").append(param.getKey()).append("=").append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
        }
        this.$trace("-> %s", query.toString());
        String response = EnigoCasCon.getUrl(query.toString());
        this.$trace("<- %s", response);
        if (response.length() <= 20) {
            int errorcode = Utils.parseInt((String)response, (int)-1);
            if (errorcode == -1) throw new BGException("response is not similar to the error code: " + response);
            command.checkError(errorcode);
            return;
        } else {
            command.setResponse(response);
        }
    }

    public void activeStatusSmartcard(long cardNumber, boolean active, String name, String cn, String address, String info) throws BGException, Exception {
        this.$trace("activeStatusSmartcard: cardNumber=%s, active=%s", cardNumber, active);
        this.sendCommand(new CommandUpdateParameters(cardNumber, active, name, cn, address, info));
    }

    public void sendMessageOsd(long cardNumber, String text) throws BGException, Exception {
        this.$trace("sendMessageOsd: cardNumber=%s (osdEnable=%b)", cardNumber, this.osdEnable);
        if (this.osdEnable) {
            this.sendCommand(new CommandSendMessage(cardNumber, true, text, this.osdRepetition, this.osdDuration, this.osdInterval));
        }
    }

    public void sendMessageMail(long cardNumber, String text) throws BGException, Exception {
        this.$trace("sendMessageMail: cardNumber=%s (emailEnable=%b)", cardNumber, this.emailEnable);
        if (this.emailEnable) {
            this.sendCommand(new CommandSendMessage(cardNumber, false, text));
        }
    }

    public List<CommandSubscriptionsList.SubscriptionInfo> getSubscriptionsList(long cardNumber) throws EnigoCasException, BGException, Exception {
        this.$trace("getSubscriptionsList: cardNumber=%s", cardNumber);
        CommandSubscriptionsList command = new CommandSubscriptionsList(cardNumber);
        try {
            this.sendCommand(command);
        }
        catch (EnigoCasException ex) {
            if (ex.getErrorcode() == 4) {
                this.$trace("masking exception: %s", ex.getMessage());
                return new ArrayList<CommandSubscriptionsList.SubscriptionInfo>();
            }
            throw ex;
        }
        return command.getSubscriptionInfo();
    }

    public void addSubscription(long cardNumber, String packageCode, Date startTime, Date stopTime) throws BGException, Exception {
        this.$trace("addSubscription: cardNumber=%s, packageCode=%s, startTime=%s, stopTime=%s", cardNumber, packageCode, startTime, stopTime);
        this.sendCommand(new CommandAddSubscription(cardNumber, packageCode, startTime, stopTime, this.cmd2type));
    }

    public void removeSubscription(long cardNumber, String packageCode, String subscriptionId) throws BGException, Exception {
        this.$trace("removeSubscription: cardNumber=%s, packageCode=%s, subscriptionId=%s", cardNumber, packageCode, subscriptionId);
        this.sendCommand(new CommandRemoveSubscription(cardNumber, packageCode, subscriptionId));
    }

    public void removeAllSubscription(long cardNumber) throws BGException, Exception {
        this.$trace("removeAllSubscription: cardNumber=%s", cardNumber);
        try {
            this.sendCommand(new CommandRemoveSubscription(cardNumber, null, null));
        }
        catch (EnigoCasException ex) {
            if (ex.getErrorcode() == 7) {
                this.$trace("masking exception: %s", ex.getMessage());
            }
            throw ex;
        }
    }

    private void $trace(String format, Object ... args) {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("EnigoCasCon: " + String.format(format, args));
        }
    }
}

