/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.service;

import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Card;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.CardActionsService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.LogEntry;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.cerbercrypt.common.service.CardActionsService")
public class CardActionsServiceImpl
extends AbstractService
implements CardActionsService {
    public List<LogEntry> logList(String filter, Object ... args) throws BGException {
        return null;
    }

    public void activate(long cardNumber) throws BGException {
        if (cardNumber <= 0L) {
            throw new BGIllegalArgumentException();
        }
        this.tryCall(() -> {
            UserCard userCard = new UserCardManager(this.getConnection(), this.moduleId, this.userId).getUserCard(cardNumber, new java.util.Date());
            List<CardPacket> cardPacketList = null;
            if (userCard != null) {
                CardPacketManager cpm = new CardPacketManager(this.getConnection(), this.moduleId);
                cardPacketList = cpm.getActiveCardPacketList((Calendar)new GregorianCalendar(), userCard.getId());
            }
            DigitalTVServiceActivator sa = DigitalTVServiceActivator.newInstance((ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId, Calendar.getInstance());
            try {
                DigitalTVServiceActivator.ServiceActivationResult result = sa.activate(cardNumber, userCard, cardPacketList);
                throw new BGMessageException(result.getMessage());
            }
            catch (Throwable throwable) {
                if (sa != null) {
                    try {
                        sa.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        });
    }

    public void deactivate(long cardNumber) throws BGException {
        if (cardNumber <= 0L) {
            throw new BGIllegalArgumentException();
        }
        DigitalTVServiceActivator sa = DigitalTVServiceActivator.newInstance((ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId, Calendar.getInstance());
        try {
            DigitalTVServiceActivator.ServiceActivationResult result = sa.deactivate(cardNumber);
            throw new BGMessageException(result.getMessage());
        }
        catch (Throwable throwable) {
            if (sa != null) {
                try {
                    sa.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    public Card getCard(long cardNumber) throws BGException {
        CardManager cardManager = new CardManager(this.getConnection(), this.moduleId, this.userId);
        Card card = cardManager.getCard(cardNumber);
        if (card == null) {
            throw new BGMessageException("\u041a\u0430\u0440\u0442\u044b " + cardNumber + " \u043d\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435");
        }
        return card;
    }

    public void updateCard(Card card) throws BGException {
        new CardManager(this.getConnection(), this.moduleId, this.userId).updateCard(card);
    }

    public List<Long> getAllCardNumbers() throws BGException {
        return new CardManager(this.getConnection(), this.moduleId, this.userId).getAllCardNumbers();
    }

    public List<Long> getFreeCardNumbers() throws BGException {
        return new CardManager(this.getConnection(), this.moduleId, this.userId).getFreeCardNumbers();
    }

    public String getSubscribeInfo(long cardNumber) throws BGException {
        if (cardNumber <= 0L) {
            throw new BGIllegalArgumentException("cardNumber <= 0");
        }
        try (DigitalTVServiceActivator sa = DigitalTVServiceActivator.newInstance((ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId, Calendar.getInstance());){
            DigitalTVServiceActivator.ServiceActivationResult result = sa.getSubscribeInfo(cardNumber);
            if (!result.isResult()) {
                throw new BGMessageException(result.getMessage());
            }
            String string = result.getMessage();
            return string;
        }
    }

    public void dosync(long cardNumber) throws BGException {
        this.tryCall(() -> {
            UserCardManager ucmanager = new UserCardManager(this.getConnection(), this.moduleId, this.userId);
            UserCard uc = ucmanager.getUserCard(cardNumber, new java.util.Date());
            if (uc == null) {
                throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043d\u0438\u043a\u043e\u043c\u0443 \u043d\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442");
            }
            List<UserCard> slavecards = ucmanager.getSlavecards(uc);
            ucmanager.updateSubscribe(new java.util.Date(), uc, slavecards);
        });
    }

    public Result<UserCard> findCard(Page page, Period period, long card, String sort, String mode) throws BGException {
        return (Result)this.tryReturn(() -> {
            ArrayList<UserCard> list = new ArrayList<UserCard>();
            String from = " FROM user_card_" + this.moduleId + " AS card LEFT JOIN contract ON card.cid=contract.id ";
            StringBuffer where = new StringBuffer(100);
            where.append(" WHERE true ");
            if ("start".equals(mode)) {
                where.append(" AND card.number LIKE '").append(card).append("%' ");
            } else if ("end".equals(mode)) {
                where.append(" AND card.number LIKE '%").append(card).append("' ");
            } else if ("include".equals(mode)) {
                where.append(" AND card.number LIKE '%").append(card).append("%' ");
            } else {
                where.append(" AND card.number=").append(card);
            }
            if (period != null && period.getDateFrom() != null) {
                where.append(" AND (card.date2 IS NULL OR card.date2>='");
                where.append(TimeUtils.formatSQLDate((java.util.Date)period.getDateFrom()));
                where.append("')");
            }
            if (period != null && period.getDateTo() != null) {
                where.append(" AND (card.date1 IS NULL OR card.date1<='");
                where.append(TimeUtils.formatSQLDate((java.util.Date)period.getDateTo()));
                where.append("')");
            }
            StringBuffer query = new StringBuffer();
            query.append("SELECT SQL_CALC_FOUND_ROWS contract.id, contract.title, contract.comment, card.id, card.date1, card.date2, card.number, card.comment ");
            query.append(from);
            query.append(where);
            if (!sort.equals("no")) {
                query.append(" ORDER BY ").append(sort);
            }
            query.append(Page.toSqlLimit((Page)page));
            try (PreparedStatement ps = this.getConnection().prepareStatement(query.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    UserCard uc = UserCard.builder().setId(rs.getInt("card.id")).setContractId(rs.getInt("contract.id")).setContractTitleComment(rs.getString("contract.title") + "[ " + rs.getString("contract.comment") + " ]").setNumber(rs.getLong("card.number")).setDate1((java.util.Date)rs.getDate("card.date1")).setDate2((java.util.Date)rs.getDate("card.date2")).setComment(rs.getString("card.comment")).build();
                    list.add(uc);
                }
            }
            Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.getConnection()));
            return new Result(list, page);
        });
    }

    public Result<Card> cardTable(Page page, MapHolder<String, String> mapHolder) throws BGException {
        return (Result)this.tryReturn(() -> {
            ResultSet rs;
            Map request = mapHolder.getMap();
            int number = Utils.parseInt((String)((String)request.get("number")), (int)0);
            int count = Utils.parseInt((String)((String)request.get("count")), (int)0);
            int dealer = Utils.parseInt((String)((String)request.get("dealer")), (int)-1);
            String contractStatus = (String)request.get("contract_status");
            String dealerStatus = (String)request.get("dealer_status");
            if (Utils.isBlankString((String)contractStatus) || Utils.isBlankString((String)dealerStatus)) {
                throw new BGIllegalArgumentException();
            }
            String queryPattern = CardActionsServiceImpl.getCardTableQuery(dealerStatus, dealer, contractStatus, number, count, this.moduleId);
            ArrayList<Card> list = new ArrayList<Card>();
            StringBuffer query = new StringBuffer(500);
            query.append("SELECT COUNT(*) ");
            query.append(queryPattern);
            int rowCount = 0;
            try (PreparedStatement ps = this.getConnection().prepareStatement(query.toString());){
                rs = ps.executeQuery();
                try {
                    if (rs.next()) {
                        rowCount = rs.getInt(1);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            Page.setRecordCount((Page)page, (int)rowCount);
            query.setLength(0);
            query.append("SELECT card.number, card.pass_dt, card.pairing_module, card.contract_dt, contract.id, contract.title, contract.comment, dealer.title, dealer.id ");
            query.append(queryPattern);
            query.append(" ORDER BY card.number" + Page.toSqlLimit((Page)page));
            ps = this.getConnection().prepareStatement(query.toString());
            try {
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        Card card = new Card();
                        list.add(card);
                        card.setNumber(rs.getLong("card.number"));
                        card.setPassDate(TimeUtils.convertSqlDateToCalendar((Date)rs.getDate("card.pass_dt")));
                        String cid = rs.getString("contract.id");
                        if (cid != null) {
                            card.setContractId(rs.getInt("contract.id"));
                            card.setContractTitle(rs.getString("contract.title"));
                            card.setContractComment(rs.getString("contract.comment"));
                            card.setContractDate(TimeUtils.convertSqlDateToCalendar((Date)rs.getDate("card.contract_dt")));
                        }
                        card.setPairingModule(rs.getString("card.pairing_module"));
                        String dealerTitle = rs.getString("dealer.title");
                        if (dealerTitle == null) continue;
                        card.setDealerTitle(dealerTitle);
                        card.setDealerId(rs.getInt("dealer.id"));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            return new Result(list, page);
        });
    }

    public int cardLoad(String cards, int dealerId, boolean allowEmptyPassword) throws BGException {
        if (Utils.isBlankString((String)cards)) {
            throw new BGMessageException("\u041f\u0443\u0441\u0442\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043a\u0430\u0440\u0442\u0430\u0445");
        }
        int success_count = 0;
        int error_count = 0;
        Object errorsInfo = new String();
        CardManager cardManager = new CardManager(this.getConnection(), this.moduleId, this.userId);
        StringTokenizer st = new StringTokenizer(cards, "\n");
        while (st.hasMoreTokens()) {
            String pswd;
            String line = st.nextToken().trim();
            String[] number_pswd = line.split("\t");
            if (!(number_pswd.length == 2 || number_pswd.length == 1 && allowEmptyPassword)) {
                errorsInfo = (String)errorsInfo + "* \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430: " + line + "\n";
                ++error_count;
                continue;
            }
            long number = Utils.parseLong((String)number_pswd[0], (long)0L);
            String string = pswd = number_pswd.length == 2 ? number_pswd[1] : "";
            if (number <= 0L) {
                errorsInfo = (String)errorsInfo + "* \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b: " + number_pswd[0] + "\n";
                ++error_count;
                continue;
            }
            Card card = new Card();
            card.setNumber(number);
            card.setPassword(pswd);
            if (dealerId > 0) {
                card.setDealerId(dealerId);
                card.setPassDate((Calendar)new GregorianCalendar());
            }
            if (!cardManager.addCard(card)) {
                errorsInfo = (String)errorsInfo + "* \u043a\u0430\u0440\u0442\u0430 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c: " + String.valueOf(number) + "\n";
                ++error_count;
                continue;
            }
            ++success_count;
        }
        if (((String)errorsInfo).length() != 0) {
            throw new BGMessageException("\u041f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0445 \u043a\u0430\u0440\u0442 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + success_count + "\n\u041e\u0448\u0438\u0431\u043a\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u0430\u0440\u0442 (" + error_count + "):\n" + (String)errorsInfo);
        }
        return success_count;
    }

    public int cardDealerAdd(String cards, int dealerId) throws BGException {
        GregorianCalendar now = new GregorianCalendar();
        if (Utils.isBlankString((String)cards) || dealerId <= 0) {
            throw new BGIllegalArgumentException("cards is null or dealerId <= 0");
        }
        int count = 0;
        CardManager cardManager = new CardManager(this.getConnection(), this.moduleId, this.userId);
        StringTokenizer st = new StringTokenizer(cards, ",");
        while (st.hasMoreTokens()) {
            long number = Utils.parseLong((String)st.nextToken().trim(), (long)0L);
            Card card = cardManager.getCard(number);
            if (card == null) continue;
            card.setDealerId(dealerId);
            card.setPassDate((Calendar)now);
            cardManager.updateCard(card);
            ++count;
        }
        return count;
    }

    public int cardDealerDelete(String cards) throws BGException {
        if (Utils.isBlankString((String)cards)) {
            throw new BGIllegalArgumentException();
        }
        int count = 0;
        CardManager cardManager = new CardManager(this.getConnection(), this.moduleId, this.userId);
        StringTokenizer st = new StringTokenizer(cards, ",");
        while (st.hasMoreTokens()) {
            long number = Utils.parseLong((String)st.nextToken().trim(), (long)0L);
            Card card = cardManager.getCard(number);
            if (card == null) continue;
            card.setDealerId(0);
            card.setPassDate(null);
            card.setContractId(0);
            card.setContractDate(null);
            cardManager.updateCard(card);
            ++count;
        }
        return count;
    }

    public void pinCode(long cardNumber, String pinCode) throws BGException {
        if (cardNumber <= 0L) {
            throw new BGIllegalArgumentException();
        }
        try (DigitalTVServiceActivator sa = DigitalTVServiceActivator.newInstance((ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId, new GregorianCalendar());){
            DigitalTVServiceActivator.ServiceActivationResult result = sa.parentalPinCode(cardNumber, pinCode);
            if (!result.isResult()) {
                throw new BGMessageException(result.getMessage());
            }
        }
    }

    public void sendMessages(String sendMode, String messageTitle, String messageBody, String receiverMode, MapHolder<String, String> mapHolder) throws BGException {
        this.tryCall(() -> {
            DigitalTVServiceActivator sa = DigitalTVServiceActivator.newInstance((ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId, Calendar.getInstance());
            try {
                Map request = mapHolder.getMap();
                ArrayList<Long> cardNumbers = null;
                if (!"all".equals(receiverMode)) {
                    if ("selected".equals(receiverMode)) {
                        String numbers = (String)request.get("numbers");
                        cardNumbers = Utils.toLongList((String)numbers);
                    } else if ("filtered".equals(receiverMode)) {
                        cardNumbers = new ArrayList<Long>();
                        int number = Utils.parseInt((String)((String)request.get("number")), (int)0);
                        int count = Utils.parseInt((String)((String)request.get("count")), (int)0);
                        int dealer = Utils.parseInt((String)((String)request.get("dealer")), (int)-1);
                        String contractStatus = (String)request.get("contract_status");
                        String dealerStatus = (String)request.get("dealer_status");
                        if (Utils.isBlankString((String)contractStatus) || Utils.isBlankString((String)dealerStatus)) {
                            throw new BGIllegalArgumentException();
                        }
                        String queryPattern = "SELECT card.number".concat(CardActionsServiceImpl.getCardTableQuery(dealerStatus, dealer, contractStatus, number, count, this.moduleId));
                        try (Statement st = this.getConnection().createStatement();
                             ResultSet rs = st.executeQuery(queryPattern);){
                            while (rs.next()) {
                                cardNumbers.add(rs.getLong(1));
                            }
                        }
                    }
                }
                DigitalTVServiceActivator.ServiceActivationResult result = sa.sendMessages(cardNumbers, messageTitle, messageBody, "mail".equals(sendMode));
                throw new BGMessageException(result.getMessage());
            }
            catch (Throwable throwable) {
                if (sa != null) {
                    try {
                        sa.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        });
    }

    public String getPairing(long cardNumber) throws BGException {
        if (cardNumber <= 0L) {
            throw new BGIllegalArgumentException();
        }
        try (DigitalTVServiceActivator sa = DigitalTVServiceActivator.newInstance((ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId, new GregorianCalendar());){
            DigitalTVServiceActivator.ServiceActivationResult result = sa.getPairing(cardNumber);
            if (!result.isResult()) {
                throw new BGMessageException(result.getMessage());
            }
            String string = result.getMessage();
            return string;
        }
    }

    public void setPairing(long cardNumber, String pairingModule) throws BGException {
        if (cardNumber <= 0L) {
            throw new BGIllegalArgumentException("cardNumber <= 0");
        }
        try (DigitalTVServiceActivator sa = DigitalTVServiceActivator.newInstance((ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId, new GregorianCalendar());){
            DigitalTVServiceActivator.ServiceActivationResult result = sa.setPairing(cardNumber, pairingModule);
            if (!result.isResult()) {
                throw new BGMessageException(result.getMessage());
            }
        }
    }

    public void deleteCard(long cardNumber) throws BGException {
        new CardManager(this.getConnection(), this.moduleId, this.userId).deleteCard(cardNumber, true);
    }

    public void customCommand(long cardNumber, String action, String[] params) throws BGException {
        if (cardNumber <= 0L) {
            throw new BGIllegalArgumentException("cardNumber <= 0");
        }
        try (DigitalTVServiceActivator sa = DigitalTVServiceActivator.newInstance((ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId, Calendar.getInstance());){
            DigitalTVServiceActivator.ServiceActivationResult result = sa.customCommand(cardNumber, action, params);
            if (!result.isResult()) {
                throw new BGMessageException(result.getMessage());
            }
        }
    }

    private static String getCardTableQuery(String dealerStatus, int dealer, String contractStatus, int number, int count, int mid) {
        StringBuilder queryPattern = new StringBuilder(300);
        queryPattern.append(" FROM card_").append(mid).append(" AS card ");
        queryPattern.append("LEFT JOIN contract ON card.cid=contract.id ");
        queryPattern.append("LEFT JOIN dealer_").append(mid).append(" AS dealer ON card.dealer_id=dealer.id ");
        queryPattern.append("WHERE 1>0 ");
        if (dealerStatus.equals("yes") && dealer > 0) {
            queryPattern.append("AND card.dealer_id=").append(dealer).append(" ");
        } else if (dealerStatus.equals("no")) {
            queryPattern.append("AND card.dealer_id=0 ");
        }
        if (number > 0) {
            queryPattern.append(" AND card.number>=").append(number);
            queryPattern.append(" AND card.number<=").append(number + count);
        }
        if (contractStatus.equals("yes")) {
            queryPattern.append(" AND card.cid!=0 ");
        } else if (contractStatus.equals("no")) {
            queryPattern.append(" AND card.cid=0 ");
        }
        return queryPattern.toString();
    }
}

