/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.xcrypt;

import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;

public class XcryptException
extends BGException {
    private final Map<Integer, String> ERRORS = new HashMap<Integer, String>(){
        {
            this.put(0, "no error");
            this.put(1, "invalid message");
            this.put(2, "unknown message_type value");
            this.put(3, "message too long");
            this.put(4, "unknown command value");
            this.put(5, "unknown data_channel_id value");
            this.put(6, "too many channels on this SAS");
            this.put(7, "unknown parameter_type");
            this.put(8, "unknown client_id value");
            this.put(9, "data_channel_id value already in use");
            this.put(10, "data_id value already in use");
            this.put(11, "client_id value already in use");
            this.put(28672, "unknown error");
            this.put(28673, "unrecoverable error");
        }
    };
    private int message_type;
    private int command_id;
    private int error_status;
    private long cardNumber;

    public XcryptException(int message_type, int command_id, int error_status, long cardNumber) {
        this.message_type = message_type;
        this.command_id = command_id;
        this.error_status = error_status;
        this.cardNumber = cardNumber;
    }

    public String getMessage() {
        if (this.command_id <= 0) {
            return String.format("CAS message 0x%04X%s error 0x%04X: %s", this.message_type, this.cardNumber > 0L ? " (card " + this.cardNumber + ")" : "", this.error_status, this.ERRORS.containsKey(this.error_status) ? this.ERRORS.get(this.error_status) : "UNKNOWN");
        }
        return String.format("CAS message 0x%04X / command 0x%04X%s error 0x%04X: %s", this.message_type, this.command_id, this.cardNumber > 0L ? " (card " + this.cardNumber + ")" : "", this.error_status, this.ERRORS.containsKey(this.error_status) ? this.ERRORS.get(this.error_status) : "UNKNOWN");
    }

    public int getErrorStatus() {
        return this.error_status;
    }
}

