/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.chronopay.server.action.web;

import java.math.RoundingMode;
import java.sql.Connection;
import java.util.Date;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.modules.chronopay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.chronopay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.chronopay.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.chronopay.server.bean.Constants;
import ru.bitel.bgbilling.modules.chronopay.server.bean.TransactionManager;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Chronopay")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("chronopay");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.setResultParam("gateUrl", this.moduleSetup.get("chronopay.gate.url", "https://payments.chronopay.com/"));
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchParam searchParam = new SearchParam().setPage(this.getPage()).setSort(new String[]{"createDate:1", "transactionDate:1"}).setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
        SearchResult searchResult = new SearchResult(searchParam);
        new TransactionManager(this.con, this.moduleId).searchTransaction((SearchResult<Transaction>)searchResult, searchParam);
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    public void success() throws Exception {
        this.execute();
    }

    public void decline() throws Exception {
        this.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        try {
            Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(this.sum)).setContractId(this.contractId)).setCreateDate(new Date())).build();
            new TransactionManager(this.con, this.moduleId).update(transaction);
            Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
            String description = this.moduleSetup.get("chronopay.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle());
            String productId = this.moduleSetup.get("chronopay.product.id", "1-1-1");
            String productPrice = this.sum.setScale(2, RoundingMode.HALF_UP).toString();
            String phone = ContractUtils.getPaymentPhone((Connection)this.con, (int)this.moduleId, (int)this.contractId);
            this.setResultParam("gateUrl", this.moduleSetup.get("chronopay.gate.url", "https://payments.chronopay.com/"));
            this.setResultParam("formFields", new String[]{"product_id", "product_price", "product_name", "cs1", "order_id", "merchant_no", "merchant_uid", "country", "cb_url", "success_url", "decline_url", "sign", "email", "phone"});
            this.setResultParam("product_id", productId);
            this.setResultParam("product_price", productPrice);
            this.setResultParam("product_name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116" + contract.getTitle());
            this.setResultParam("order_id", String.valueOf(transaction.getId()));
            this.setResultParam("merchant_no", String.valueOf(transaction.getId()));
            this.setResultParam("cs1", String.valueOf(transaction.getId()));
            this.setResultParam("merchant_uid", String.valueOf(contract.getId()));
            this.setResultParam("product_name", description);
            this.setResultParam("country", this.moduleSetup.get("chronopay.country", "RUS"));
            this.setResultParam("cb_url", this.moduleSetup.get("chronopay.callback.url", ""));
            this.setResultParam("success_url", this.moduleSetup.get("chronopay.success.url", ""));
            this.setResultParam("decline_url", this.moduleSetup.get("chronopay.decline.url", ""));
            this.setResultParam("sign", this.doSign(productId + "-" + productPrice));
            if (this.customerAddress != null) {
                this.setResultParam("email", this.customerAddress);
            }
            if (phone != null) {
                this.setResultParam("phone", phone);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private String doSign(String value) {
        return Utils.getDigest((String)(value + "-" + this.moduleSetup.get("chronopay.sharedsec", "")), (String)"UTF-8").toLowerCase();
    }
}

