/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cloudpayments.server.event.worker;

import java.math.BigDecimal;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.CloudPaymentsAutopaymentEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class CloudPaymentsAutopaymentEventWorker
extends EventWorker {
    private AutopaymentManager autopaymentManager;

    public CloudPaymentsAutopaymentEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), CloudPaymentsAutopaymentEvent.class, moduleId, -1, null);
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 60000L;
        this.getLogger().info("Starting CloudPaymentsAutopaymentEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "cloudpayments-autopayment-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.autopaymentManager = new AutopaymentManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        return this.doTasks();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object doTask(Object task) throws BGException {
        CloudPaymentsAutopaymentEvent event = (CloudPaymentsAutopaymentEvent)((Object)task);
        int contractId = event.getContractId();
        try {
            Autopayment autopayment = this.autopaymentManager.getCurrentAutopayment(contractId);
            BigDecimal sum = event.getSum();
            if (sum == null) {
                sum = autopayment.getSum();
            }
            if (autopayment != null && autopayment.getMode().getCode() != event.getMode()) return null;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return null;
    }
}

