/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.action;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCall;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterGroup;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterProblem;
import ru.bitel.bgbilling.plugins.crm.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.crm.server.bean.event.CreateProblemFromCallEvent;
import ru.bitel.bgbilling.plugins.crm.server.bean.event.ProblemOrCallChangedEvent;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterCallManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterGroupManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterProblemManager;

public class ActionUpdateRegisterCall
extends ActionBase {
    public void doAction() throws Exception {
        int id = this.getIntParameter("id", 0);
        if (id < 0) {
            throw new BGIllegalArgumentException();
        }
        int group = this.getIntParameter("group", 0);
        RegisterCall call = null;
        RegisterCallManager cm = new RegisterCallManager(this.con);
        call = id == 0 ? new RegisterCall().setContractId(this.cid).setUserId(this.userId.intValue()).setTime(new Date()) : cm.getCallById(id);
        if (call != null) {
            call.setObjectId(this.getIntParameter("oid", 0)).setTypeId(this.getIntParameter("subject", 0)).setGroupId(group).setComment(this.getParameter("comment", ""));
            cm.updateCall(call);
            int problemId = this.getIntParameter("problem_id", -1);
            String problemComment = this.getParameter("problem_comment");
            boolean needUpdate = false;
            if (problemId >= 0) {
                call.setProblemId(problemId);
                needUpdate = true;
            } else if (problemComment != null && problemComment.length() > 0) {
                RegisterProblem problem = new RegisterProblem().setObjectId(call.getObjectId()).setOpenTime(new Date()).setOpenUserId(this.userId.intValue()).setStatusTime(new Date()).setStatusUserId(this.userId.intValue()).setComment(problemComment).setGroupId(call.getGroupId());
                if (call.getContractId() > 0) {
                    try (ContractObjectDao contractObjectDao = new ContractObjectDao(this.con, this.userId.intValue());){
                        Contract contract = ContractDao.getContract((Connection)this.con, (int)call.getContractId());
                        if (contract != null) {
                            ContractObject object = null;
                            if (call.getObjectId() > 0) {
                                object = (ContractObject)contractObjectDao.get(call.getObjectId());
                            }
                            CreateProblemFromCallEvent event = new CreateProblemFromCallEvent(this.plugin.getPluginUID(), contract, object, call, problem);
                            event = (CreateProblemFromCallEvent)EventProcessor.getInstance().request((QueueEvent)event);
                            call = event.getCall();
                            problem = event.getProblem();
                        }
                    }
                }
                RegisterProblemManager problemManager = new RegisterProblemManager(this.con);
                problemManager.updateProblem(problem, this.userId);
                problemManager.addGroup(problem.getId(), group);
                call.setProblemId(problem.getId());
                needUpdate = true;
                int eventContractId = this.plugin.getSetup().getInt("event.contract.id", 0);
                if (eventContractId > 0) {
                    this.context.publishAfterCommit((Event)new ProblemOrCallChangedEvent(this.plugin.getPluginUID(), eventContractId, true, call, problem));
                }
                this.rootNode.setAttribute("problem_id", String.valueOf(problem.getId()));
            } else {
                int eventContractId = this.plugin.getSetup().getInt("event.contract.id", 0);
                if (eventContractId > 0) {
                    this.context.publishAfterCommit((Event)new ProblemOrCallChangedEvent(this.plugin.getPluginUID(), eventContractId, id == 0, call, null));
                }
            }
            if (needUpdate) {
                cm.updateCall(call);
            }
            if (call != null && this.getParameter("send.mail") != null) {
                this.sendRegisterEmail(call, this.plugin.getSetup().get("register.task.call.subject", this.setup.get("register.task.call.subject", "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0437\u0432\u043e\u043d\u043a\u0443")));
            }
        }
    }

    protected void sendRegisterEmail(RegisterCall call, String subject) throws Exception {
        RegisterProblem problem;
        RegisterGroup group = new RegisterGroupManager(this.con).getGroupById(call.getGroupId());
        if (group == null || group.getEmail() == null || group.getEmail().trim().isEmpty()) {
            throw new BGMessageException("\u0423 \u0433\u0440\u0443\u043f\u043f\u044b \u043d\u0435\u0442 \u043f\u043e\u0447\u0442\u043e\u0432\u043e\u0433\u043e \u0430\u0434\u0440\u0435\u0441\u0430!");
        }
        Element header = this.createElement(this.rootNode, "header");
        header.setAttribute("id", String.valueOf(call.getId()));
        this.addUserData(call.getUserId(), call.getTime(), "dd.MM.yyyy HH:mm", header, "open");
        header.setAttribute("group", group.getTitle());
        header.setAttribute("contract", "-");
        header.setAttribute("object", "-");
        if (call.getContractId() > 0) {
            try (ContractObjectDao contractObjectDao = new ContractObjectDao(this.con, this.userId.intValue());){
                Contract contract = ContractDao.getContract((Connection)this.con, (int)call.getContractId());
                if (contract != null) {
                    header.setAttribute("contract", contract.getTitle());
                    ContractObject object = (ContractObject)contractObjectDao.get(call.getObjectId());
                    if (object != null) {
                        header.setAttribute("object", object.getTitle());
                    }
                }
            }
        }
        ResultSet rs = null;
        String query = "SELECT title FROM register_subject WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, call.getTypeId());
        rs = ps.executeQuery();
        if (rs.next()) {
            header.setAttribute("type", rs.getString(1));
        }
        rs.close();
        ps.close();
        Element comment = this.createElement(this.rootNode, "comment");
        this.stringToLines(comment, call.getComment());
        RegisterProblemManager problemManager = new RegisterProblemManager(this.con);
        if (call.getProblemId() > 0 && (problem = problemManager.getProblemByID(call.getProblemId())) != null) {
            Element problemEl = this.createElement(this.rootNode, "problem");
            comment = this.createElement(problemEl, "comment");
            this.stringToLines(comment, problem.getComment());
        }
        XSLManager.getInstance().transformAndSend("crm_register_call.xsl", (Source)new DOMSource(this.rootNode.getOwnerDocument()), null, "text/html", null, false, group.getEmail(), subject);
    }
}

