/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.LocalDate;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessage;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessageStatistic;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.model.SearchResult;

public class DispatchMessageStatisticPanel
extends BGUPanel {
    private JLabel recordCountLabel = new JLabel();
    private BGControlPanelPeriodNoB periodPanel;
    private BGControlPanelPages page;
    private DispatchMessageStatisticTableModel statisticTableModel;
    private DispatchService dispatchService;
    private int contractId;
    private Dispatch dispatch;
    private DispatchMessage message;
    private Contact contact;

    protected void jbInit() throws Exception {
        this.statisticTableModel = new DispatchMessageStatisticTableModel();
        BGUTable statisticTable = new BGUTable((TableModel)((Object)this.statisticTableModel));
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 3, 5, 3), 0, 0));
        this.add(new JScrollPane((Component)statisticTable), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 3, 3, 3), 0, 0));
    }

    private JPanel getTopPanel() {
        this.page = new BGControlPanelPages();
        this.page.addToHandler(a -> this.performAction("refresh"));
        LocalDate localDate = LocalDate.now().withDayOfMonth(1);
        this.periodPanel = new BGControlPanelPeriodNoB();
        this.periodPanel.setLocalDateFrom(localDate);
        this.periodPanel.setLocalDateTo(localDate.plusMonths(1L).minusDays(1L));
        this.periodPanel.addPropertyChangeListener(evt -> this.performAction("refresh"));
        JButton returnButton = new JButton("<< \u0432\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f");
        returnButton.addActionListener(e -> this.setVisible(false));
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)returnButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.periodPanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 50, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.recordCountLabel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.page, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 0, 0), 0, 0));
        return panel;
    }

    private DispatchService getDispatchService() {
        if (this.dispatchService == null) {
            this.dispatchService = (DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class);
        }
        return this.dispatchService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchResult messageStatisticResult = this.getDispatchService().getMessageStatisticList(this.contractId, this.dispatch != null ? this.dispatch.getId() : -1, this.message != null ? this.message.getId() : -1, this.contact != null ? this.contact.getId() : -1, this.periodPanel.getPeriod(), this.page.getPage());
            this.statisticTableModel.setData(messageStatisticResult.getList());
            this.page.setPage(messageStatisticResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0437\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434: " + messageStatisticResult.getPage().getRecordCount());
        });
    }

    public void setContact(Contact contact) {
        this.clearFilterObject();
        this.contact = contact;
    }

    public void setMessage(DispatchMessage message) {
        this.clearFilterObject();
        this.message = message;
    }

    public void setDispatch(Dispatch dispatch) {
        this.clearFilterObject();
        this.dispatch = dispatch;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    private void clearFilterObject() {
        this.dispatch = null;
        this.contact = null;
        this.message = null;
        this.contractId = -1;
    }

    class DispatchMessageStatisticTableModel
    extends BGTableModel<DispatchMessageStatistic> {
        public DispatchMessageStatisticTableModel() {
            super(DispatchMessageStatisticTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("ID", -1, 100, 120, "id", true);
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", -1, 160, -1, "contractTitle", true);
            this.addColumn("\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438", Column.DateTime.class, -1, 180, 180, "sendDate", true);
            this.addColumn("\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430", -1, 220, -1, "dispatchTitle", true);
            this.addColumn("\u0422\u0435\u043a\u0441\u0442 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f", -1, -1, -1, "messageText");
            this.addColumn("\u041a\u043e\u043d\u0442\u0430\u043a\u0442", -1, 220, -1, "contactValue");
        }
    }
}

