<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:common="http://common.bitel.ru" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<xsl:import href="layout.xsl"/>

<xsl:variable name="URL"><xsl:value-of select="$WEBEXECUTER"/>?action=Dispatch&amp;module=ru.bitel.bgbilling.plugins.dispatch&amp;mid=0&amp;operation=</xsl:variable>

<xsl:template name="head">
	<script language="javascript" type="text/javascript">
			<xsl:text disable-output-escaping="yes">
	<![CDATA[
	window.onload = function()
	{
		filterOptions();
		selChange( document.getElementById("contactType") );
	}
	
	function selChange( opt ) 
	{ 
		desc = opt.options[opt.selectedIndex].id;
		document.getElementById("hintMessage").innerHTML = desc; 
	} 
	
	function showEditor()
	{
		document.getElementById("newButton").style.visibility = 'hidden';
		document.getElementById("hiddenEditor").style.visibility = 'visible';
		selChange( document.getElementById("contactType") );
	}
	
	function hideEditor()
	{
		document.getElementById("newButton").style.visibility = 'visible';
		document.getElementById("hiddenEditor").style.visibility = 'hidden';
	}
	
	function filterOptions()
	{
		var dispatchSelect = document.getElementById("dispatchSelect");
		if ( !dispatchSelect ) return;
	
		var select = document.getElementById("contacts");
		var options = select.getElementsByTagName("option");
	
		for ( var i = 0; i < options.length; ++i )
		{
			options[i].selected = false;
			if ( options[i].id != dispatchSelect.options[dispatchSelect.selectedIndex].id )
				options[i].style.visibility = 'hidden';
			else
				options[i].style.visibility = 'visible';
		}
	}
	
	function sendRequest(url)
	{
		var my_JSON_object = {};
		var http_request = new XMLHttpRequest();
		http_request.open( "GET", url, true );
		http_request.onreadystatechange = function () 
		{
		  if (http_request.readyState == 4 && http_request.status == 200)
		  {
		       response = JSON.parse( http_request.responseText );
		       
		  }
		};
		http_request.send(null);
	}
	]]>
			</xsl:text>
		</script>
</xsl:template>

<xsl:template name="title">
	<xsl:choose>
		<xsl:when test="data/@action = 'Dispatch' and data/@operation = 'subscribe'">Подписка на рассылку</xsl:when>
		<xsl:when test="data/@action = 'Dispatch' and data/common:result/attributes/item[@key='subscriptions']">Мои рассылки</xsl:when>
		<xsl:when test="data/@action = 'Dispatch' and data/@operation = 'editContact'">Редактирование контакта</xsl:when>
		<xsl:otherwise>Мои контакты</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="/data">
	<xsl:call-template name="Сommon"/>
	<xsl:choose>
		<xsl:when test="common:result/attributes/item[@key='subscriptions']"><xsl:call-template name="Subscriptions"/></xsl:when>
		<xsl:when test="@operation = 'subscribe'"><xsl:call-template name="EditSubscribe"/></xsl:when>
		<xsl:when test="@operation = 'editContact'"><xsl:call-template name="EditContact"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="Contacts"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="Сommon"></xsl:template>
<xsl:template name="Contacts"></xsl:template>
<xsl:template name="EditContact"></xsl:template>
<xsl:template name="Subscriptions"></xsl:template>
<xsl:template name="EditSubscribe"></xsl:template>
<xsl:template name="matchCondition"><xsl:param name="class"/><xsl:param name="moduleId"/></xsl:template>
</xsl:stylesheet>