/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ParamNestEditor
extends JPanel {
    private BGConfigEditorPane configEditorPane = new BGConfigEditorPane();
    private DefaultTableModel staticFieldsTableModel;
    private JTable staticFieldsTable;
    private List<String> staticFields = null;

    public ParamNestEditor(String[] _staticFields) {
        this.staticFields = _staticFields != null ? Arrays.asList(_staticFields) : null;
        this.staticFieldsTableModel = new DefaultTableModel(new Object[]{"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
        this.staticFieldsTable = new JTable(this.staticFieldsTableModel);
        this.setLayout(new GridBagLayout());
        if (Utils.notEmptyCollection(this.staticFields)) {
            this.add((Component)this.staticFieldsTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        }
        this.add((Component)this.configEditorPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setConfigText(String config) {
        this._setTableConfigText(config);
        if (Utils.notBlankString((String)config)) {
            if (Utils.notEmptyCollection(this.staticFields)) {
                StringBuilder sb = new StringBuilder(config.length() + 1024);
                for (String line : config.split("\\r?\\n")) {
                    String name;
                    int idx = line.indexOf(61);
                    if (idx != -1 && this.staticFields.contains(name = line.substring(0, idx))) continue;
                    sb.append(line).append('\n');
                }
                this.configEditorPane.setText(sb.toString());
            } else {
                this.configEditorPane.setText(config);
            }
        } else {
            this.configEditorPane.setText("");
        }
        SwingUtilities.invokeLater(this::_ensureTopPositionInScrollPane);
    }

    public String getConfigText() {
        return this._getTableConfigText() + this.configEditorPane.getText();
    }

    private void _setTableConfigText(String config) {
        if (Utils.notEmptyCollection(this.staticFields)) {
            Preferences parameterMap = new Preferences(config, "\n");
            this.staticFieldsTableModel.setRowCount(0);
            for (String key : this.staticFields) {
                String value = parameterMap.get(key, "");
                this.staticFieldsTableModel.addRow(new Object[]{key, value});
            }
        }
    }

    private String _getTableConfigText() {
        if (Utils.notEmptyCollection(this.staticFields)) {
            StringBuilder configText = new StringBuilder();
            for (int i = 0; i < this.staticFieldsTableModel.getRowCount(); ++i) {
                String key = (String)this.staticFieldsTableModel.getValueAt(i, 0);
                String value = (String)this.staticFieldsTableModel.getValueAt(i, 1);
                if (!Utils.notBlankString((String)value)) continue;
                configText.append(key).append("=").append(value).append("\n");
            }
            return configText.toString();
        }
        return "";
    }

    private void _ensureTopPositionInScrollPane() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            JViewport viewport;
            if (!(parent instanceof JViewport) || !((viewport = (JViewport)parent).getParent() instanceof JScrollPane)) continue;
            viewport.setViewPosition(new Point(0, 0));
            return;
        }
    }
}

