/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.plugins.edo.common.bean.ExtDocument;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

public class EdoExtDocumentDao
extends AbstractIdDao<ExtDocument> {
    public EdoExtDocumentDao(Connection con) {
        super(con, "edo_ext_documents");
    }

    protected ExtDocument getFromRS(ResultSet rs) throws SQLException {
        return this._loadFromRS(rs, false);
    }

    private ExtDocument _loadFromRS(ResultSet rs, boolean extended) throws SQLException {
        ExtDocument document = new ExtDocument();
        document.setId(rs.getInt(this.tableName + ".id"));
        document.setDocumentTypeId(rs.getInt(this.tableName + ".doc_type_id"));
        document.setSignatoryId(rs.getInt(this.tableName + ".signatory_id"));
        document.setBillId(rs.getInt(this.tableName + ".bill_id"));
        document.setInvoiceId(rs.getInt(this.tableName + ".invoice_id"));
        document.setExtLink(rs.getString(this.tableName + ".ext_link"));
        document.setDate((Date)rs.getTimestamp(this.tableName + ".date"));
        document.setUserId(rs.getInt(this.tableName + ".user_id"));
        document.setContractId(rs.getInt(this.tableName + ".contract_id"));
        document.setBillModuleId(rs.getInt(this.tableName + ".bill_mid"));
        document.setBillingDocTitle(rs.getString(this.tableName + ".billing_doc_title"));
        if (extended) {
            String contract_title = rs.getString("contract.title");
            String contract_comment = rs.getString("contract.comment");
            document.setContractTitleComment(contract_title + " [" + contract_comment + "]");
            document.setDocumentTypeTitle(rs.getString("edo_document_type.title"));
            document.setSignatoryTitle(rs.getString("edo_signatory.title"));
        }
        return document;
    }

    protected void updateImpl(ExtDocument document) throws SQLException {
        String querySet = "doc_type_id=?, signatory_id=?, bill_id=?, invoice_id=?, ext_link=?, date=?, user_id=?, contract_id=?, bill_mid=?, billing_doc_title=?";
        try (PreparedStatement ps = this.con.prepareStatement(this.sqlQuery((Id)document, querySet), 1);){
            int index = 1;
            ps.setInt(index++, document.getDocumentTypeId());
            ps.setInt(index++, document.getSignatoryId());
            ps.setInt(index++, document.getBillId());
            ps.setInt(index++, document.getInvoiceId());
            ps.setString(index++, document.getExtLink());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)document.getDate()));
            ps.setInt(index++, document.getUserId());
            ps.setInt(index++, document.getContractId());
            ps.setInt(index++, document.getBillModuleId());
            ps.setString(index++, document.getBillingDocTitle());
            this.executeUpdate((Id)document, index, ps);
        }
    }

    public Result<ExtDocument> getList(Period period, Page page, Set<Integer> contracts, Integer documentTypeId, Integer signatoryId) throws BGException {
        ArrayList<ExtDocument> result = new ArrayList<ExtDocument>();
        try {
            Object query = "";
            query = (String)query + "SELECT SQL_CALC_FOUND_ROWS edo_ext_documents.*, contract.title, contract.comment, edo_document_type.title, edo_signatory.title ";
            query = (String)query + "FROM edo_ext_documents ";
            query = (String)query + "LEFT JOIN contract ON edo_ext_documents.contract_id = contract.id ";
            query = (String)query + "LEFT JOIN edo_document_type ON edo_ext_documents.doc_type_id = edo_document_type.id ";
            query = (String)query + "LEFT JOIN edo_signatory ON edo_ext_documents.signatory_id = edo_signatory.id ";
            query = (String)query + "WHERE ( 1 = 1 ) ";
            if (documentTypeId != null) {
                query = (String)query + " AND edo_ext_documents.doc_type_id=" + documentTypeId;
            } else if (signatoryId != null) {
                query = (String)query + " AND edo_ext_documents.signatory_id=" + signatoryId;
            }
            if (period != null && period.getDateFrom() != null) {
                query = (String)query + " AND edo_ext_documents.date>='" + TimeUtils.format((Date)period.getDateFrom(), (String)"yyyy-MM-dd") + "'";
            }
            if (period != null && period.getDateTo() != null) {
                query = (String)query + " AND edo_ext_documents.date<=DATE_ADD('" + TimeUtils.format((Date)period.getDateTo(), (String)"yyyy-MM-dd") + "', INTERVAL 1 DAY )";
            }
            if (Utils.notEmptyCollection(contracts)) {
                String c = Utils.toString(contracts);
                query = (String)query + " AND edo_ext_documents.contract_id IN (" + c + ")";
            }
            query = (String)query + " ORDER BY edo_ext_documents.id DESC";
            query = (String)query + Page.toSqlLimit((Page)page);
            try (Statement st = this.con.createStatement();
                 ResultSet rs = st.executeQuery((String)query);){
                while (rs.next()) {
                    result.add(this._loadFromRS(rs, true));
                }
            }
            Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
        }
        catch (SQLException ex) {
            throw new BGException("error get ext document list", (Throwable)ex);
        }
        return new Result(result, page);
    }
}

