/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.service;

import jakarta.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentInfos;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentSearchInfo;
import ru.bitel.bgbilling.plugins.edo.common.bean.GetEdoIdSettings;
import ru.bitel.bgbilling.plugins.edo.common.service.EdoService;
import ru.bitel.bgbilling.plugins.edo.server.bean.ContractConfigManager;
import ru.bitel.bgbilling.plugins.edo.server.bean.EdoManager;
import ru.bitel.bgbilling.plugins.edo.server.provider.sbis.SbisAPI;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.edo.common.service.EdoService")
public class EdoServiceImpl
extends AbstractService
implements EdoService {
    public ContragentInfos sbisSearchContragent(ContragentSearchInfo searchInfo) throws BGException {
        ContragentInfos contragentInfos = new SbisAPI(this.userId).contragentInfo(searchInfo);
        return contragentInfos;
    }

    public ContragentSearchInfo fillContragentSearchInfo(int contractId) throws BGException {
        EdoManager em = new EdoManager(this.getConnection(), this.userId);
        return em.getContragentSearchInfoForContract(contractId);
    }

    public String getContractEdoConfig(int contractId) throws BGException {
        return new ContractConfigManager(this.getConnection()).getConfig(contractId);
    }

    public void saveContractEdoConfig(int contractId, String config) throws BGException {
        new ContractConfigManager(this.getConnection()).saveConfig(contractId, config);
    }

    public GetEdoIdSettings getContractEdoIdSettings(int contractId) throws BGException {
        return new ContractConfigManager(this.getConnection()).getGetEdoIdSettings(contractId);
    }

    public void saveContractEdoIdSettings(int contractId, GetEdoIdSettings settings) throws BGException {
        new ContractConfigManager(this.getConnection()).saveGetEdoIdSettings(contractId, settings);
    }
}

