/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.service;

import jakarta.jws.WebService;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.edo.common.bean.Signatory;
import ru.bitel.bgbilling.plugins.edo.common.service.SignatoryService;
import ru.bitel.bgbilling.plugins.edo.server.bean.SignatoryDao;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.edo.common.service.SignatoryService")
public class SignatoryServiceImpl
extends AbstractService
implements SignatoryService {
    private SignatoryDao signatoryDao;

    public List<Signatory> getSignatoryList() throws BGException {
        return (List)this.tryReturn(() -> this.getSignatoryDao().getListAll());
    }

    public Signatory getSignatory(int id) throws BGException {
        return (Signatory)this.tryReturn(() -> (Signatory)this.getSignatoryDao().get(id));
    }

    public void deleteSignatory(int id) throws BGException {
        this.tryCall(() -> this.getSignatoryDao().delete(id));
    }

    public void updateSignatory(Signatory signatory) throws BGException {
        this.tryCall(() -> this.getSignatoryDao().update(signatory));
    }

    private SignatoryDao getSignatoryDao() {
        this.signatoryDao = new SignatoryDao(this.getConnection());
        return Optional.ofNullable(this.signatoryDao).orElse(this.signatoryDao);
    }
}

