/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGTabbedPane;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.hd.client.ConfigPanel;
import ru.bitel.bgbilling.modules.hd.client.ServicePropertiesPanel;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGControlPanelTextArea;

public class DnsZoneEditor
extends BGPanel {
    private JCheckBox zoneWhois = new JCheckBox();
    private JCheckBox zoneAvto = new JCheckBox();
    private BGTextField zoneTitle = new BGTextField();
    private ConfigPanel configPanel = new ConfigPanel();
    private BGTabbedPane tabbedPane = new BGTabbedPane();
    private BGComboBox<String> primaryNsServer = new BGComboBox();
    private BGComboBox<String> secondaryNsServer = new BGComboBox();
    private BGTextArea secondaryNsServers = new BGTextArea();
    private BGTextField primaryCustomNsServer = new BGTextField();
    private JPanel whoisPanel = new JPanel(new GridBagLayout());
    private BGControlPanelPeriodNoB zonePeriod = new BGControlPanelPeriodNoB();
    private BGControlPanelTextArea zoneComment = new BGControlPanelTextArea("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
    private Map<String, BGTextField> soaBGTextFieldMap = new HashMap<String, BGTextField>();
    private Map<String, JCheckBox> soaJCheckBoxMap = new HashMap<String, JCheckBox>();
    private Map<String, BGComboBox<ComboBoxItem>> serviceBGComboBoxMap = new HashMap<String, BGComboBox<ComboBoxItem>>();
    private String oldConfigValue = null;
    private String oldSerialValue = null;
    private Map<String, String> defaultSOAValues = new HashMap<String, String>();
    private Component component = null;
    private BGTable whoisTable = new BGTable();
    private BGTextArea recordsTextArea = new BGTextArea();
    private BGTitleBorder whoisBorder = new BGTitleBorder("Whois");

    public DnsZoneEditor() {
        this.jbInit();
    }

    private void jbInit() {
        this.zoneComment.setHeightSize(100);
        this.primaryNsServer.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.primaryCustomNsServer.setEditable(((String)this.primaryNsServer.getSelectedItem()).equals("\u0414\u0440\u0443\u0433\u043e\u0439"));
            }
            if (!((String)this.primaryNsServer.getSelectedItem()).equals("\u0414\u0440\u0443\u0433\u043e\u0439") && this.primaryNsServer.getSelectedIndex() != 0) {
                String key = "primary";
                String changingValue = ((String)this.primaryNsServer.getSelectedItem()).toString();
                this.configPanel.replaceConfigValue(key, changingValue);
            }
        });
        for (Component comp : this.configPanel.getComponents()) {
            if (!(comp instanceof JTextArea)) continue;
            this.component = comp;
        }
        this.zoneTitle.setHorizontalAlignment(0);
        this.zoneWhois.setSelected(false);
        this.zonePeriod.setDateCalendar1((Calendar)new GregorianCalendar());
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)new JLabel("\u0417\u043e\u043d\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.zoneTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)new JLabel("Whois: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
        topPanel.add((Component)this.zoneWhois, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u0410\u0432\u0442\u043e "), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
        topPanel.add((Component)this.zoneAvto, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
        topPanel.add((Component)this.zonePeriod, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel zoneRecordPanel = new JPanel(new GridBagLayout());
        zoneRecordPanel.add((Component)this.recordsTextArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.tabbedPane.add("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u043e\u043d\u044b", (Component)this.getNSPanel());
        this.tabbedPane.add("\u0417\u0430\u043f\u0438\u0441\u0438 \u0437\u043e\u043d\u044b", (Component)zoneRecordPanel);
        this.tabbedPane.add("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f", (Component)((Object)this.configPanel));
        this.tabbedPane.addChangeListener(e -> {
            int index = this.tabbedPane.getSelectedIndex();
            if (index == 0 || index == 1) {
                this.readConfigInfo();
            }
        });
        BGButtonPanelRestoreOkCancelHelp controlPanel = new BGButtonPanelRestoreOkCancelHelp();
        controlPanel.addActionListener(e -> this.controlPanelActionPerformed(e.getActionCommand()));
        this.zoneWhois.addActionListener(e -> this.whoisPanel.setVisible(this.zoneWhois.isSelected()));
        this.setLayout(new GridBagLayout());
        this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)controlPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 5, 10, 5), 0, 0));
    }

    private JPanel getNSPanel() {
        BGTabbedPane nsTabbedPane = new BGTabbedPane();
        JPanel primaryNsPanel = new JPanel(new GridBagLayout());
        this.primaryCustomNsServer.getDocument().putProperty("key", "primary");
        this.secondaryNsServers.getDocument().putProperty("key", "secondary");
        this.primaryCustomNsServer.getDocument().addDocumentListener(new DocumentListenerImpl((Component)this.primaryCustomNsServer, this.component));
        this.secondaryNsServers.getDocument().addDocumentListener(new DocumentListenerImpl((Component)this.secondaryNsServers, this.component));
        primaryNsPanel.add((Component)this.primaryNsServer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        primaryNsPanel.add((Component)this.primaryCustomNsServer, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        primaryNsPanel.add((Component)this.getSoaRecordPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        primaryNsPanel.add(Box.createGlue(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        nsTabbedPane.add("PRIMARY", (Component)primaryNsPanel);
        this.secondaryNsServers.setMargin(new Insets(3, 3, 3, 3));
        BGButton secondaryAddButton = new BGButton("+");
        JPanel secondaryNsPanel = new JPanel(new GridBagLayout());
        secondaryNsPanel.add((Component)this.secondaryNsServers, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        secondaryNsPanel.add((Component)this.secondaryNsServer, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        secondaryNsPanel.add((Component)secondaryAddButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        nsTabbedPane.add("SECONDARY", (Component)secondaryNsPanel);
        secondaryAddButton.addActionListener(e -> this.addSecondary());
        JPanel nsPanel = new JPanel(new GridBagLayout());
        nsPanel.setBorder((Border)new BGTitleBorder("NS \u0441\u0435\u0440\u0432\u0435\u0440\u0430"));
        nsPanel.add((Component)nsTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)nsPanel, new GridBagConstraints(0, 0, 1, 3, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getServicePanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)this.getWhoisPanel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)this.zoneComment, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getSoaRecordPanel() {
        String[] labels = new String[]{"ttl", "person", "serial", "refresh", "retry", "expire", "minimum"};
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("SOA"));
        for (int i = 0; i < labels.length; ++i) {
            BGTextField field = new BGTextField(15);
            field.getDocument().putProperty("key", "soa." + labels[i]);
            field.setHorizontalAlignment(0);
            field.getDocument().addDocumentListener(new DocumentListenerImpl((Component)field, this.component));
            JCheckBox checkBox = new JCheckBox();
            checkBox.setToolTipText("\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
            checkBox.setActionCommand(labels[i]);
            this.soaJCheckBoxMap.put(labels[i], checkBox);
            checkBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JCheckBox checkBox;
                    DnsZoneEditor.this.soaBGTextFieldMap.get(checkBox.getActionCommand()).setEnabled(!(checkBox = (JCheckBox)e.getSource()).isSelected());
                    if (checkBox.isSelected()) {
                        String key = checkBox.getActionCommand();
                        DnsZoneEditor.this.soaBGTextFieldMap.get(key).setText(DnsZoneEditor.this.defaultSOAValues.get(key));
                    }
                    if (checkBox.getActionCommand() == "serial" && checkBox.isSelected()) {
                        DnsZoneEditor.this.soaBGTextFieldMap.get("serial").setText(DnsZoneEditor.this.getNewSerial());
                    }
                    StringBuilder sb = new StringBuilder();
                    for (String key : DnsZoneEditor.this.soaJCheckBoxMap.keySet()) {
                        if (DnsZoneEditor.this.soaJCheckBoxMap.get(key).isSelected()) {
                            sb.append(key + ":1;");
                            continue;
                        }
                        sb.append(key + ":0;");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append("\n");
                    DnsZoneEditor.this.configPanel.replaceConfigValue("checkbox.selected", sb.toString());
                }
            });
            panel.add((Component)new JLabel(labels[i].toUpperCase()), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)field, new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)checkBox, new GridBagConstraints(2, i, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.soaBGTextFieldMap.put(labels[i], field);
        }
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        BGButton button = new BGButton("\u0412\u0441\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        buttonPanel.add((Component)button, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        BGButton clearButton = new BGButton("\u0421\u043d\u044f\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435");
        buttonPanel.add((Component)clearButton, new GridBagConstraints(2, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(0, labels.length, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        button.addActionListener(e -> {
            BGButton button1 = (BGButton)e.getSource();
            JPanel panel1 = (JPanel)button1.getParent().getParent();
            for (Component component : panel1.getComponents()) {
                if (!(component instanceof JCheckBox)) continue;
                ((JCheckBox)component).setSelected(true);
            }
        });
        clearButton.addActionListener(e -> {
            BGButton button1 = (BGButton)e.getSource();
            JPanel panel1 = (JPanel)button1.getParent().getParent();
            for (Component component : panel1.getComponents()) {
                if (!(component instanceof JCheckBox)) continue;
                ((JCheckBox)component).setSelected(false);
            }
        });
        return panel;
    }

    private JPanel getServicePanel() {
        String[] labels = new String[]{"\u0420\u0415\u0413\u0418\u0421\u0422\u0420\u0410\u0426\u0418\u042f", "\u041f\u0420\u041e\u0414\u041b\u0415\u041d\u0418\u0415", "PRIMARY", "SECONDARY"};
        String[] labels1 = new String[]{"registration", "prolongation", "ns_primary", "ns_secondary"};
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("\u0423\u0441\u043b\u0443\u0433\u0438"));
        for (int y = 0; y < labels.length; ++y) {
            BGComboBox comboBox = new BGComboBox();
            panel.add((Component)new JLabel(labels[y]), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)comboBox, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.serviceBGComboBoxMap.put(labels1[y].toLowerCase(), (BGComboBox<ComboBoxItem>)comboBox);
        }
        return panel;
    }

    private JPanel getWhoisPanel() {
        this.whoisPanel.setBorder((Border)this.whoisBorder);
        this.whoisTable.setHeader(this.rb_name, this.moduleDoc, "whois");
        this.whoisPanel.add((Component)new JScrollPane((Component)this.whoisTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return this.whoisPanel;
    }

    public void init(String module, int mid) {
        super.init(module, mid);
        try {
            this.initEditor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initEditor() {
        DefaultComboBoxModel model2;
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("GetZoneService");
        org.w3c.dom.Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((org.w3c.dom.Document)doc)) {
            try {
                model2 = null;
                model2 = ClientUtils.buildComboBox((Node)XMLUtils.selectElement((Node)doc, (String)"//registration"), null);
                this.serviceBGComboBoxMap.get("registration").setModel((ComboBoxModel)model2);
                model2 = ClientUtils.buildComboBox((Node)XMLUtils.selectElement((Node)doc, (String)"//prolongation"), null);
                this.serviceBGComboBoxMap.get("prolongation").setModel((ComboBoxModel)model2);
                model2 = ClientUtils.buildComboBox((Node)XMLUtils.selectElement((Node)doc, (String)"//ns_primary"), null);
                this.serviceBGComboBoxMap.get("ns_primary").setModel((ComboBoxModel)model2);
                model2 = ClientUtils.buildComboBox((Node)XMLUtils.selectElement((Node)doc, (String)"//ns_secondary"), null);
                this.serviceBGComboBoxMap.get("ns_secondary").setModel((ComboBoxModel)model2);
            }
            catch (Exception model2) {
                // empty catch block
            }
        }
        request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("GetNSList");
        doc = this.getDocument(request);
        if (ClientUtils.checkStatus((org.w3c.dom.Document)doc)) {
            try {
                model2 = this.getNSComboBoxModel(XMLUtils.selectElement((Node)doc, (String)"//primary"));
                model2.insertElementAt("", 0);
                model2.addElement("\u0414\u0440\u0443\u0433\u043e\u0439");
                this.primaryNsServer.setModel((ComboBoxModel)model2);
                this.secondaryNsServer.setModel(this.getNSComboBoxModel(XMLUtils.selectElement((Node)doc, (String)"//secondary")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setData() throws Exception {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        request.setAttribute("zone_id", this.id);
        request.setAction("GetContractZoneData");
        this.setDocument(this.getDocument(request));
    }

    public void readConfigInfo() {
        for (String soaKey : this.soaBGTextFieldMap.keySet()) {
            this.soaBGTextFieldMap.get(soaKey).setText(this.configPanel.getConfigValue("soa." + soaKey));
            if (this.id != 0 || !soaKey.equalsIgnoreCase("serial") || !this.soaJCheckBoxMap.get(soaKey).isSelected()) continue;
            this.soaBGTextFieldMap.get(soaKey).setText(this.getNewSerial());
        }
        this.whoisTable.removeRows();
        for (String configLine : this.configPanel.getConfig().split("\n")) {
            String prefix = "whois.";
            if (!configLine.startsWith(prefix)) continue;
            Vector<String> row = new Vector<String>();
            int pos = configLine.indexOf("=");
            if (pos > -1) {
                row.add(configLine.substring(prefix.length(), pos).toUpperCase());
                row.add(configLine.substring(pos + 1));
            }
            this.whoisTable.addRow(row);
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.primaryNsServer.getModel();
        String primary = this.configPanel.getConfigValue("primary");
        if (primary != null) {
            boolean find = false;
            for (int index = 0; index < model.getSize(); ++index) {
                if (!((String)model.getElementAt(index)).equalsIgnoreCase(primary)) continue;
                this.primaryNsServer.setSelectedIndex(index);
                find = true;
                break;
            }
            if (!find) {
                this.primaryNsServer.setSelectedIndex(model.getSize() - 1);
                this.primaryCustomNsServer.setText(primary);
                this.primaryCustomNsServer.setEditable(true);
            }
        } else {
            this.primaryNsServer.setSelectedIndex(0);
        }
        String secondary = this.configPanel.getConfigValue("secondary");
        if (secondary != null) {
            secondary = secondary.replace(';', '\n');
        }
        this.secondaryNsServers.setText(secondary);
        String checkBoxSelection = this.configPanel.getConfigValue("checkbox.selected");
        if (checkBoxSelection != null) {
            String[] selectionValues;
            for (String str : selectionValues = checkBoxSelection.trim().split(";")) {
                int pos = str.indexOf(58);
                if (pos <= -1) continue;
                String name = str.substring(0, pos);
                String value = pos < str.length() - 1 ? str.substring(pos + 1) : "1";
                this.soaJCheckBoxMap.get(name).setSelected("1".equals(value));
            }
        }
    }

    public void setDocument(org.w3c.dom.Document doc) throws Exception {
        if (ClientUtils.checkStatus((org.w3c.dom.Document)doc)) {
            String[] names;
            Element zoneElement = XMLUtils.selectElement((Node)doc, (String)"//zone");
            String str = zoneElement.getAttribute("name");
            StringBuffer zoneBuffer = new StringBuffer(str.toUpperCase());
            if (!str.equals("")) {
                this.zoneTitle.setEditable(false);
                if (!str.equals(zoneElement.getAttribute("punycode"))) {
                    zoneBuffer.append(" (");
                    zoneBuffer.append(zoneElement.getAttribute("punycode"));
                    zoneBuffer.append(")");
                }
            } else {
                this.zoneTitle.setEditable(true);
            }
            this.zoneTitle.setText(zoneBuffer.toString());
            this.zoneComment.setText(zoneElement.getAttribute("comment"));
            Element configElement = XMLUtils.selectElement((Node)doc, (String)"//config");
            if (configElement != null) {
                this.configPanel.setConfig(configElement.getTextContent());
            }
            this.recordsTextArea.setText(zoneElement.getAttribute("records"));
            this.oldConfigValue = this.configPanel.getConfig();
            this.oldSerialValue = this.configPanel.getConfigValue("soa.serial");
            this.readConfigInfo();
            String whoisLastUpdate = zoneElement.getAttribute("whois_last_update");
            StringBuffer buffer = new StringBuffer(" Whois");
            if (!whoisLastUpdate.isEmpty()) {
                buffer.append(" [ ");
                buffer.append(whoisLastUpdate);
                buffer.append(" ]");
            }
            buffer.append(": ");
            this.whoisBorder.setTitle(buffer.toString());
            this.zoneWhois.setSelected("true".equals(zoneElement.getAttribute("whois")));
            this.zoneAvto.setSelected("true".equals(zoneElement.getAttribute("avto")));
            this.whoisPanel.setVisible(this.zoneWhois.isSelected());
            this.zonePeriod.setDateString1(zoneElement.getAttribute("date_from"));
            this.zonePeriod.setDateString2(zoneElement.getAttribute("date_to"));
            Element defaults = XMLUtils.selectElement((Node)doc, (String)"//defaults");
            for (String st : names = new String[]{"ttl", "expire", "retry", "refresh", "person", "minimum"}) {
                this.defaultSOAValues.put(st, defaults.getAttribute(st));
            }
        }
    }

    public void setTabbedPaneIndex(int index) {
        if (index > -1 && index < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(index);
        }
    }

    private DefaultComboBoxModel<String> getNSComboBoxModel(Element listElement) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        if (listElement != null) {
            NodeList nodeList = listElement.getElementsByTagName("item");
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Element itemElement = (Element)nodeList.item(index);
                model.addElement(itemElement.getAttribute("title"));
            }
        }
        return model;
    }

    private void addSecondary() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.secondaryNsServer.getModel();
        if (model.getSize() > 0) {
            boolean needAdd = true;
            String nsName = (String)this.secondaryNsServer.getSelectedItem();
            for (String line : this.secondaryNsServers.getText().split("\n")) {
                if (!line.trim().equalsIgnoreCase(nsName)) continue;
                needAdd = false;
                break;
            }
            if (needAdd) {
                this.secondaryNsServers.setText(this.secondaryNsServers.getText() + "\n" + nsName);
            }
        }
    }

    private void controlPanelActionPerformed(String actionCommand) {
        if ("reset".equals(actionCommand)) {
            this.trySetData();
        } else if ("ok".equals(actionCommand)) {
            Request request = new Request();
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setModule("hd");
            if (this.id == 0) {
                request.setAction("AddZone");
            } else {
                request.setAction("UpdateZone");
                request.setAttribute("zoneId", this.id);
                if (!this.checkChanges()) {
                    return;
                }
            }
            request.setAttribute("zone", this.zoneTitle.getText());
            request.setAttribute("config", this.configPanel.getConfig());
            request.setAttribute("records", this.recordsTextArea.getText());
            request.setAttribute("whois", String.valueOf(this.zoneWhois.isSelected()));
            request.setAttribute("avto", String.valueOf(this.zoneAvto.isSelected()));
            request.setAttribute("comment", this.zoneComment.getText());
            request.setAttribute("dateFrom", TimeUtils.formatDate((Date)this.zonePeriod.getDateFrom()));
            request.setAttribute("dateTo", TimeUtils.formatDate((Date)this.zonePeriod.getDateTo()));
            request.setAttribute("lastUpdate", TimeUtils.format((Calendar)new GregorianCalendar(), (String)"yyyy-MM-dd HH:mm:ss"));
            org.w3c.dom.Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((org.w3c.dom.Document)doc)) {
                this.tryCall(() -> {
                    this.setVisible(false);
                    ServicePropertiesPanel ssspp = (ServicePropertiesPanel)((Object)((Object)this.getParent().getParent().getParent()));
                    ssspp.setData();
                    JPanel parentPanel = (JPanel)this.getParent();
                    ((CardLayout)parentPanel.getLayout()).show(parentPanel, "table");
                });
            }
        } else if ("cancel".equals(actionCommand)) {
            JPanel parentPanel = (JPanel)this.getParent();
            ((CardLayout)parentPanel.getLayout()).show(parentPanel, "table");
        }
    }

    private boolean checkChanges() {
        String[] oldConfigLines;
        boolean result = true;
        StringBuilder newConfigValue = new StringBuilder(this.configPanel.getConfig().trim());
        newConfigValue.append("\n");
        for (String string : oldConfigLines = this.oldConfigValue.split("\n")) {
            String string2 = string + "\n";
            int lineStartIndex = newConfigValue.indexOf(string2);
            if (lineStartIndex < 0) continue;
            int lineEndIndex = newConfigValue.indexOf("\n", lineStartIndex);
            newConfigValue.delete(lineStartIndex, lineEndIndex + 1);
        }
        if (!newConfigValue.toString().isEmpty() && !this.incrementSerial()) {
            result = false;
        }
        return result;
    }

    private boolean incrementSerial() {
        boolean result = false;
        String serial = this.configPanel.getConfigValue("soa.serial");
        if (serial == null) {
            serial = "0000000000";
        }
        if (this.soaJCheckBoxMap.get("serial").isSelected()) {
            Date currentDate;
            String current = TimeUtils.format((Date)new Date(System.currentTimeMillis()), (String)"dd.MM.yyyy");
            String dd_mm_yyyy = serial.substring(6, 8) + "." + serial.substring(4, 6) + "." + serial.substring(0, 4);
            Date oldDate = TimeUtils.convertStringToDate((String)dd_mm_yyyy);
            int compareResultCode = oldDate.compareTo(currentDate = TimeUtils.convertStringToDate((String)current));
            if (compareResultCode == 0) {
                int version = Integer.valueOf(serial.substring(8, 10));
                DecimalFormat df = new DecimalFormat("00");
                String newSerial = serial.substring(0, 8) + df.format(++version);
                this.configPanel.replaceConfigValue("soa.serial", newSerial);
            } else if (compareResultCode < 0) {
                String newSerial = this.getNewSerial();
                this.configPanel.replaceConfigValue("soa.serial", newSerial);
            }
            result = true;
        } else {
            DecimalFormat df = new DecimalFormat();
            try {
                Number oldVal = df.parse(this.oldSerialValue);
                Number newVal = df.parse(serial);
                if (oldVal.intValue() >= newVal.intValue() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0435\u0440\u0438\u0439\u043d\u0438\u043a\u0430 \u043c\u0435\u043d\u044c\u0448\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e. \u0418\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c?", "\u041e\u0448\u0438\u0431\u043a\u0430", 0) == 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0440\u0435\u0436\u0438\u043c \u0438\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f?", "\u041e\u0448\u0438\u0431\u043a\u0430", 0) == 0) {
                    this.soaJCheckBoxMap.get("serial").setSelected(true);
                    this.configPanel.replaceConfigValue("soa.serial", this.getNewSerial());
                    result = true;
                }
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    private String getNewSerial() {
        Object serial = "";
        Date dt = new Date(System.currentTimeMillis());
        String yyyymmdd = TimeUtils.formatDate((Date)dt);
        String[] tmp = yyyymmdd.split("\\D+");
        serial = tmp[2] + tmp[1] + tmp[0] + "01";
        return serial;
    }

    private class DocumentListenerImpl
    implements DocumentListener {
        private JTextArea destComponent;
        private Component sourceComponent;

        public DocumentListenerImpl(Component sourceComponent, Component destComponent) {
            this.destComponent = (JTextArea)destComponent;
            this.sourceComponent = sourceComponent;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateComponentText(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateComponentText(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateComponentText(e);
        }

        private void updateComponentText(DocumentEvent e) {
            final DocumentEvent e1 = e;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Document doc = e1.getDocument();
                    String key = (String)doc.getProperty("key");
                    String destText = null;
                    try {
                        destText = doc.getText(0, doc.getLength());
                        if (DocumentListenerImpl.this.sourceComponent instanceof JTextArea && (key.equals("secondary") || key.equals("record"))) {
                            destText = destText.replace("\n", ";");
                        }
                        if (DocumentListenerImpl.this.destComponent != null && DocumentListenerImpl.this.destComponent.getText().length() != destText.length()) {
                            DnsZoneEditor.this.configPanel.replaceConfigValue(key, destText);
                        }
                    }
                    catch (BadLocationException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            });
        }
    }
}

