/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.task;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.net.whois.WhoisClient;

public class WhoisServers {
    private static Map<String, String> whoisServers = new HashMap<String, String>();
    private static long updateTime = System.currentTimeMillis();

    public static String getWhoisServer(String zone) {
        String[] str;
        String whoisServer = null;
        if (zone == null) {
            return whoisServer;
        }
        if (System.currentTimeMillis() - updateTime > 86400000L) {
            whoisServers = new HashMap<String, String>();
            updateTime = System.currentTimeMillis();
        }
        if ((str = zone.split("\\u002E")).length == 2) {
            String domain = str[str.length - 1].toUpperCase();
            whoisServer = whoisServers.get(domain);
            if (whoisServer == null) {
                whoisServer = WhoisServers.getWhoisFromIanaOrg(domain);
            }
            if (whoisServer == null) {
                whoisServer = WhoisServers.getWhoisDomain(zone, true);
            }
            if (whoisServer == null) {
                whoisServer = WhoisServers.getWhoisDomain(zone, false);
            }
            if (whoisServer != null) {
                whoisServers.put(domain, whoisServer);
            }
        }
        return whoisServer;
    }

    private static String getWhoisFromIanaOrg(String zone) {
        String whoisServer = null;
        try {
            WhoisClient whoisClient = new WhoisClient();
            whoisClient.connect("whois.iana.org", 43);
            if (whoisClient.isConnected()) {
                String result = whoisClient.query(zone);
                for (String line : result.split("\n")) {
                    if (!line.startsWith("whois:")) continue;
                    whoisServer = line.substring(6).trim();
                    break;
                }
                whoisClient.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return whoisServer;
    }

    private static String getWhoisDomain(String zone, boolean nic) {
        String whoisServer = null;
        try {
            String[] str = zone.split("\\u002E");
            WhoisClient whoisClient = new WhoisClient();
            whoisClient.connect("whois." + (nic ? "nic." : "") + str[str.length - 1], 43);
            if (whoisClient.isConnected()) {
                String result = whoisClient.query(zone);
                whoisClient.disconnect();
                if (result != null) {
                    whoisServer = "whois.nic." + str[str.length - 1];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return whoisServer;
    }

    public static void main(String[] args) {
        System.out.println(WhoisServers.getWhoisServer("bitel.ru"));
        System.out.println(WhoisServers.getWhoisServer("ufanet.ru"));
        System.out.println(WhoisServers.getWhoisServer("google.com"));
        System.out.println(WhoisServers.getWhoisServer("ufa.fm"));
    }
}

