/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.task;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.hd.common.bean.Zone;

public class ZoneTaskUtils {
    public static String ZONE_TMP_DIR = System.getProperty("user.home") + "/.bgbilling/tmp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZoneFile(Zone zone, Map<String, String> zoneFields) {
        File tmpFile = new File(ZONE_TMP_DIR);
        tmpFile.mkdirs();
        File file = new File(tmpFile, zone.getZone());
        BufferedWriter bw = null;
        try {
            if (file.createNewFile()) {
                bw = new BufferedWriter(new FileWriter(file));
                StringBuilder zoneContent = new StringBuilder();
                zoneContent.append("; TTL field\n");
                zoneContent.append("$TTL \t");
                zoneContent.append(zoneFields.get("soa.ttl") + "\n");
                zoneContent.append("\n; SOA field\n");
                zoneContent.append("@ \t SOA \t @ \t" + zoneFields.get("soa.person") + "(\n");
                zoneContent.append("\t\t\t" + zoneFields.get("soa.serial") + "\t;serial\n");
                zoneContent.append("\t\t\t" + zoneFields.get("soa.refresh") + "\t;refresh\n");
                zoneContent.append("\t\t\t" + zoneFields.get("soa.retry") + "\t;rerty\n");
                zoneContent.append("\t\t\t" + zoneFields.get("soa.expire") + "\t;expire\n");
                zoneContent.append("\t\t\t" + zoneFields.get("soa.minimum") + "\t;minimum\n");
                zoneContent.append("\t\t\t)\n");
                zoneContent.append("\n; Primary NS field\n");
                zoneContent.append("@ \t NS \t" + zoneFields.get("primary") + "\n");
                zoneContent.append("\n; Secondary NS field\n");
                String secondaryNS = zoneFields.get("secondary");
                int position = secondaryNS.indexOf(";");
                if (position < 0) {
                    zoneContent.append("@ \t NS \t" + secondaryNS + "\n");
                } else {
                    String[] servers;
                    for (String s : servers = secondaryNS.split(";")) {
                        zoneContent.append("@ \t NS \t" + s + "\n");
                    }
                }
                bw.write(zoneContent.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createMasterFile(List<Zone> zoneList) {
        File tmpFile = new File(ZONE_TMP_DIR);
        tmpFile.mkdirs();
        File masterFile = new File(tmpFile, "bg_zones");
        StringBuilder master = new StringBuilder();
        for (Zone zone : zoneList) {
            master.append("zone \"" + zone.getZone() + "\" { type master; file \"" + zone.getZone() + "\"; };\n");
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(masterFile));
            bw.write(master.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteTempFiles() {
        File tmpFile = new File(ZONE_TMP_DIR);
        if (tmpFile.isDirectory()) {
            File[] zoneFiles;
            for (File f : zoneFiles = tmpFile.listFiles()) {
                f.delete();
            }
        }
        tmpFile.delete();
    }

    public static Map<String, String> getZoneContent(String config) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] fields = config.split("\n");
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].startsWith("soa.") && !fields[i].startsWith("secondary") && !fields[i].startsWith("primary")) continue;
            String[] keyVal = fields[i].split("=");
            result.put(keyVal[0], keyVal[1]);
        }
        return result;
    }

    public static void executeScript(String command) {
        Runtime rt = Runtime.getRuntime();
        Process process = null;
        try {
            process = rt.exec(command);
            BufferedReader stdin = new BufferedReader(new InputStreamReader(process.getInputStream()));
            int m = -1;
            while ((m = stdin.read()) >= 0) {
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setExecutable(String scriptFile) {
        File f = new File(scriptFile);
        if (!f.canExecute()) {
            f.setExecutable(true);
        }
    }
}

