/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.hd.server.bean.CPEvent;
import ru.bitel.common.TimeUtils;

public class CPEventManager
extends AbstarctDaoConstant {
    public CPEventManager(Connection con, int moduleId) {
        super(con, "hd_cp_event", moduleId);
    }

    public void deleteEvents(int cpid) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE cpid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cpid);
            ps.executeUpdate();
        }
    }

    public List<CPEvent> getEventList(int cpid) throws SQLException {
        ArrayList<CPEvent> result = new ArrayList<CPEvent>();
        String query = "SELECT * FROM " + this.tableName + " WHERE cpid=? ORDER BY date DESC";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cpid);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getEventFromRs(rs));
                }
            }
        }
        return result;
    }

    public void addEvent(CPEvent event) throws SQLException {
        String query = "INSERT INTO " + this.tableName + " (cid, cpid, type, date, period, sid, summa) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, event.getContractId());
            ps.setInt(2, event.getPackageId());
            ps.setInt(3, event.getType());
            ps.setTimestamp(4, TimeUtils.convertCalendarToTimestamp((Calendar)event.getTime()));
            ps.setInt(5, event.getPeriodId());
            ps.setInt(6, event.getServiceId());
            ps.setFloat(7, event.getSumma());
            ps.executeUpdate();
        }
    }

    public void setContractAccountFromEvent(int contractId, Calendar date) {
        try {
            String sids = ModuleCache.getInstance().getModuleServicesString(this.moduleId);
            Object query = "DELETE FROM contract_account WHERE cid=? AND yy=? AND mm=? AND sid IN (" + sids + ")";
            PreparedStatement ps = this.con.prepareStatement((String)query);
            ps.setInt(1, contractId);
            ps.setInt(2, date.get(1));
            ps.setInt(3, date.get(2) + 1);
            ps.executeUpdate();
            ps.close();
            Calendar startMonth = TimeUtils.getStartMonth((Calendar)date);
            Calendar endMonth = TimeUtils.getEndMonth((Calendar)date);
            endMonth.add(6, 1);
            query = "SELECT sid, SUM(summa) FROM " + this.tableName + " WHERE cid=? AND date>=? AND date<? GROUP BY sid";
            ps = this.con.prepareStatement((String)query);
            ps.setInt(1, contractId);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)startMonth));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)endMonth));
            query = "INSERT INTO contract_account (cid, yy, mm, sid,  summa) VALUES (?, ?, ?, ?, ?)";
            PreparedStatement psInsertAccount = this.con.prepareStatement((String)query);
            psInsertAccount.setInt(1, contractId);
            psInsertAccount.setInt(2, date.get(1));
            psInsertAccount.setInt(3, date.get(2) + 1);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                psInsertAccount.setInt(4, rs.getInt(1));
                psInsertAccount.setFloat(5, rs.getFloat(2));
                psInsertAccount.executeUpdate();
            }
            ps.close();
            psInsertAccount.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CPEvent getEventFromRs(ResultSet rs) throws SQLException {
        CPEvent result = new CPEvent();
        result.setContractId(rs.getInt("cid"));
        result.setPackageId(rs.getInt("cpid"));
        result.setType(rs.getInt("type"));
        result.setPeriodId(rs.getInt("period"));
        result.setTime(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp("date")));
        result.setServiceId(rs.getInt("sid"));
        result.setSumma(rs.getFloat("summa"));
        return result;
    }
}

