/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.hd.server.bean.CPNs;

public class CPNsManager
extends AbstarctDaoConstant {
    public CPNsManager(Connection con, int moduleId) {
        super(con, "hd_cp_ns", moduleId);
    }

    public void deletePackageNs(int cpid) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE cpid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cpid);
            ps.executeUpdate();
        }
    }

    public void updatePackageNs(int cpid, List<CPNs> packageNsList) throws SQLException {
        this.deletePackageNs(cpid);
        String query = "INSERT INTO " + this.tableName + " (cpid, pos, id, name ) VALUES (?, ?, ?, ?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int pos = 0;
            ps.setInt(1, cpid);
            for (CPNs ns : packageNsList) {
                ps.setInt(2, pos++);
                ps.setInt(3, ns.getId());
                ps.setString(4, ns.getName());
                ps.executeUpdate();
            }
        }
    }

    public List<CPNs> getPackageNsList(int contractPackageId) throws SQLException {
        ArrayList<CPNs> result = new ArrayList<CPNs>();
        String query = "SELECT * FROM " + this.tableName + " WHERE cpid=? ORDER BY pos";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractPackageId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getNsFromRs(rs));
                }
            }
        }
        return result;
    }

    private CPNs getNsFromRs(ResultSet rs) throws SQLException {
        CPNs result = new CPNs();
        result.setContractPackageId(rs.getInt("cpid"));
        result.setPos(rs.getInt("pos"));
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        return result;
    }
}

