/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.hd.server.bean.ContractPackage;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class ContractPackageManager
extends AbstarctDaoConstant {
    public ContractPackageManager(Connection con, int moduleId) {
        super(con, "hd_contract_package", moduleId);
    }

    public ContractPackage getContractPackage(int id) throws SQLException {
        ContractPackage result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getContractServiceFromRS(rs, false);
                }
            }
        }
        return result;
    }

    public List<ContractPackage> getContractPackageList(int contractId) throws SQLException {
        ArrayList<ContractPackage> result = new ArrayList<ContractPackage>();
        String query = "SELECT contract_package.*, package.title FROM " + this.tableName + " AS contract_package  LEFT JOIN hd_package_" + this.moduleId + " AS package ON contract_package.pid=package.id ";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getContractServiceFromRS(rs, true));
            }
        }
        return result;
    }

    public List<ContractPackage> getPackageList(int packageId, int daysToExpire) throws SQLException {
        ArrayList<ContractPackage> result = new ArrayList<ContractPackage>();
        GregorianCalendar borderDate = new GregorianCalendar();
        ((Calendar)borderDate).add(6, daysToExpire);
        StringBuilder query = new StringBuilder("SELECT contract_package.*, package.title, contract.title, contract.comment FROM ").append(this.tableName).append(" AS contract_package ").append("LEFT JOIN hd_package_").append(this.moduleId).append(" AS package ON contract_package.pid=package.id ").append("LEFT JOIN contract ON contract_package.cid=contract.id ").append("WHERE contract_package.date2<=? ");
        if (packageId > 0) {
            query.append(" AND pid=").append(packageId);
        }
        query.append(" AND status=? ORDER BY contract_package.date2");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)borderDate));
            ps.setInt(2, 1);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getContractServiceFromRS(rs, true, true));
                }
            }
        }
        return result;
    }

    private ContractPackage getContractServiceFromRS(ResultSet rs, boolean titleLoad) throws SQLException {
        return this.getContractServiceFromRS(rs, titleLoad, false);
    }

    private ContractPackage getContractServiceFromRS(ResultSet rs, boolean titleLoad, boolean contractTitleLoad) throws SQLException {
        ContractPackage result = new ContractPackage();
        result.setId(rs.getInt("id"));
        if (titleLoad) {
            result.setPackageTitle(rs.getString("package.title"));
        }
        if (contractTitleLoad) {
            result.setContractTitle(rs.getString("contract.title"));
            result.setContractComment(rs.getString("contract.comment"));
        }
        result.setContractId(rs.getInt("cid"));
        result.setPackageId(rs.getInt("pid"));
        result.setStatus(rs.getInt("status"));
        result.setNsDomain(rs.getString("ns_domain"));
        result.setDate1(TimeUtils.convertDateToCalendar((Date)rs.getDate("date1")));
        result.setDate2(TimeUtils.convertDateToCalendar((Date)rs.getDate("date2")));
        result.setAdminComment(rs.getString("admin_comment"));
        return result;
    }

    public void updateContractPackage(ContractPackage value) throws SQLException {
        String query = null;
        boolean update = value.getId() > 0;
        query = update ? "UPDATE " + this.tableName + " SET cid=?, pid=?, status=?, ns_domain=?, date1=?, date2=?, admin_comment=? WHERE id=?" : "INSERT INTO " + this.tableName + " (cid, pid, status, ns_domain, date1, date2, admin_comment) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setInt(1, value.getContractId());
            ps.setInt(2, value.getPackageId());
            ps.setInt(3, value.getStatus());
            ps.setString(4, value.getNsDomain());
            ps.setDate(5, TimeUtils.convertCalendarToSqlDate((Calendar)value.getDate1()));
            ps.setDate(6, TimeUtils.convertCalendarToSqlDate((Calendar)value.getDate2()));
            ps.setString(7, value.getAdminComment());
            if (update) {
                ps.setInt(8, value.getId());
            }
            ps.executeUpdate();
            if (!update) {
                value.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public void deleteContractPackage(int id) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }
}

