/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLogAccount;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficAccount;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficAccountDetail;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficAmount;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxDao;
import ru.bitel.bgbilling.modules.inet.server.tariff.range.InetTrafficRangeDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

public class InetSessionLogDao
extends AbstractDao<InetSessionLog> {
    public static final String TABLE_INET_SESSION = "inet_session";
    public static final String TABLE_INET_SESSION_DETAIL = "inet_session_detail";
    public static final String TABLE_INET_SESSION_ACCOUNT = "inet_session_account";
    public static final String TABLE_INET_SESSION_LOG = "inet_session_log";
    public static final String TABLE_INET_SESSION_LOG_DETAIL = "inet_session_log_detail";
    public static final String TABLE_INET_SESSION_LOG_ACCOUNT = "inet_session_log_account";
    public static final String TABLE_INET_SESSION_LOG_ROUTE = "inet_session_log_route";
    public static final String TABLE_INET_SESSION_ROUTE = "inet_session_route";
    public static final String TABLE_INET_CONNECTION = "inet_connection";
    private final Date date;
    private String lastUsername = null;
    private String lastRealm = null;
    private final String detailTableName;
    private final String accountTableName;
    private final String routeTableName;
    private boolean readSessionRoute = true;
    PreparedStatement selectChildrenPS;
    private PreparedStatement insertPS;
    private PreparedStatement routeListPS = null;
    private Calendar utilCalendar = null;

    public InetSessionLogDao(Connection con, int moduleId, Date date) throws BGException {
        super(con, TABLE_INET_SESSION_LOG, moduleId, date);
        if (date == null) {
            throw new IllegalArgumentException();
        }
        this.date = date;
        this.detailTableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_SESSION_LOG_DETAIL, (Date)date, (int)moduleId);
        this.accountTableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_SESSION_LOG_ACCOUNT, (Date)date, (int)moduleId);
        this.routeTableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_SESSION_LOG_ROUTE, (Date)date, (int)moduleId);
    }

    public InetSessionLogDao(Connection con, int moduleId) throws BGException {
        super(con, TABLE_INET_SESSION, moduleId, null);
        this.date = null;
        this.routeTableName = "inet_session_route_" + moduleId;
        this.detailTableName = "inet_session_detail_" + moduleId;
        this.accountTableName = "inet_session_account_" + moduleId;
    }

    protected InetSessionLog getFromRS(ResultSet rs) throws SQLException, BGException {
        String realm;
        InetSessionLog result = new InetSessionLog();
        result.setId(rs.getLong("id"));
        result.setParentId(rs.getLong("parentId"));
        result.setSplittedId(rs.getLong("splittedId"));
        result.setConnectionId(rs.getLong("connectionId"));
        result.setParentConnectionId(rs.getLong("parentConnectionId"));
        result.setDeviceId(rs.getInt("deviceId"));
        result.setDevicePort(rs.getInt("devicePort"));
        result.setAgentDeviceId(rs.getInt("agentDeviceId"));
        result.setAcctSessionId(rs.getString("acctSessionId"));
        result.setServId(rs.getInt("servId"));
        String username = rs.getString("username");
        if (username != null) {
            if (this.lastUsername == null || !this.lastUsername.equals(username)) {
                if (result.getParentConnectionId() > 0L) {
                    username = InetUtils.internServiceName(username);
                }
                this.lastUsername = username;
                result.setUsername(username);
            } else {
                result.setUsername(this.lastUsername);
            }
        }
        if ((realm = rs.getString("realm")) != null && realm.length() > 0 && !"default".equals(realm)) {
            if (this.lastRealm == null || !this.lastRealm.equals(realm)) {
                this.lastRealm = realm = InetUtils.internRealm(realm);
                result.setRealm(realm);
            } else {
                result.setRealm(realm);
            }
        }
        result.setDeviceState(rs.getShort("deviceState"));
        result.setDeviceOptions(Utils.toIntegerSet((String)rs.getString("deviceOptions")));
        result.setType(rs.getInt("type"));
        result.setCalledStationId(rs.getString("calledStationId"));
        result.setCallingStationId(rs.getString("callingStationId"));
        result.setIpResourceId(rs.getInt("ipResourceId"));
        result.setInetAddressBytes(rs.getBytes("ipAddress"));
        result.setPrefixResourceId(rs.getInt("prefixResourceId"));
        result.setPrefix(rs.getBytes("prefix"));
        result.setPrefixLength(rs.getShort("prefixLength"));
        result.setDelegatedPrefixResourceId(rs.getInt("delegatedPrefixResourceId"));
        result.setDelegatedPrefix(rs.getBytes("delegatedPrefix"));
        result.setDelegatedPrefixLength(rs.getShort("delegatedPrefixLength"));
        result.setConnectionStart(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("connectionStart")));
        result.setSessionStart(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("sessionStart")));
        result.setSessionStop(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("sessionStop")));
        result.setLastActive(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("lastActive")));
        result.setSessionCost(rs.getBigDecimal("sessionCost"));
        result.setStatus((int)rs.getShort("status"));
        result.setSessionTime(rs.getLong("sessionTime"));
        if (this.readSessionRoute) {
            if (this.routeListPS == null) {
                this.routeListPS = this.con.prepareStatement("SELECT subnet, mask FROM " + this.routeTableName + " WHERE sessionId=?");
            }
            ArrayList<IpNet> routeList = null;
            this.routeListPS.setLong(1, result.getId());
            ResultSet routeListRS = this.routeListPS.executeQuery();
            while (routeListRS.next()) {
                IpNet route = new IpNet();
                route.setSubnet(routeListRS.getBytes(1));
                route.setMask(routeListRS.getInt(2));
                if (routeList == null) {
                    routeList = new ArrayList<IpNet>(4);
                }
                routeList.add(route);
            }
            routeListRS.close();
            if (routeList != null) {
                result.setRouteList(routeList);
            }
        }
        return result;
    }

    private static void partition(StringBuilder sb, Date date, int days) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        calendar.set(5, 1);
        int last = ((Calendar)calendar).getActualMaximum(5);
        for (int i = calendar.get(5) + days; i < last; i += days) {
            String partitionName = TimeUtils.format((Calendar)calendar, (String)"yyyyMMdd");
            ((Calendar)calendar).add(5, days);
            sb.append("PARTITION p" + partitionName + " VALUES LESS THAN (TO_DAYS( '" + TimeUtils.formatSQLDate((Calendar)calendar) + "' )), \n");
        }
        String partitionName = TimeUtils.format((Calendar)calendar, (String)"yyyyMMdd");
        sb.append("PARTITION p" + partitionName + " VALUES LESS THAN MAXVALUE");
    }

    public static void checkTables(Connection con, int moduleId, Date date) throws SQLException, BGException {
        InetSessionLogDao.createTables(con, moduleId, date, null);
    }

    private static void createTables(Connection con, int moduleId, Date date, String tableName) throws SQLException, BGException {
        String routeTableName;
        String accountTableName;
        String detailTableName;
        Statement stmt = con.createStatement();
        if (tableName != null || !ServerUtils.tableExists((Connection)con, (String)(tableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_SESSION_LOG, (Date)date, (int)moduleId)))) {
            StringBuilder sb = new StringBuilder("CREATE TABLE  `" + tableName + "` ( `id` bigint(20) NOT NULL, `parentId` bigint(20) NOT NULL, `splittedId` bigint(20) NOT NULL, `connectionId` bigint(20) NOT NULL, `parentConnectionId` bigint(20) NOT NULL, `deviceId` int(11) NOT NULL, `devicePort` int(11) NOT NULL, `agentDeviceId` int(11) NOT NULL, `acctSessionId` varchar(80) default NULL, `username` varchar(100) default NULL, `realm` varchar(20) default NULL, `type` int(11) NOT NULL, `accessCode` SMALLINT NOT NULL, `servId` int(11) NOT NULL, `calledStationId` varchar(60) default NULL, `callingStationId` varchar(60) default NULL, `ipResourceId` int(11) NOT NULL, `ipAddress` varbinary(16) default NULL, `prefixResourceId` int(11) NOT NULL default 0, `prefix` varbinary(16) default NULL, `prefixLength` TINYINT NOT NULL default 0, `delegatedPrefixResourceId` int(11) NOT NULL default 0, `delegatedPrefix` varbinary(16) default NULL, `delegatedPrefixLength` TINYINT NOT NULL default 0, `connectionStart` datetime NOT NULL, `sessionStart` datetime NOT NULL, `sessionStop` datetime, `lastActive` datetime NOT NULL, `deviceState` SMALLINT NOT NULL, `deviceOptions` varchar(120) NOT NULL, `sessionTime` int(11) NOT NULL, `sessionCost` decimal(12,5) NOT NULL, `status` SMALLINT NOT NULL, PRIMARY KEY `id`  (`id`, `sessionStart`), KEY `parentId`  (`parentId`), KEY `nas` (`deviceId`,`devicePort`), KEY `agentDeviceId` (`agentDeviceId`), KEY `serv` (`servId`), KEY `connection` (`connectionId`), KEY `sessionStart` (`sessionStart`), KEY `ipAddress` (`ipAddress`) )");
            sb.append(" /*!50106 PARTITION BY RANGE (TO_DAYS(sessionStart)) (");
            InetSessionLogDao.partition(sb, date, 3);
            sb.append(")*/");
            stmt.executeUpdate(sb.toString());
        }
        if (!ServerUtils.tableExists((Connection)con, (String)(detailTableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_SESSION_LOG_DETAIL, (Date)date, (int)moduleId)))) {
            stmt.executeUpdate("CREATE TABLE `" + detailTableName + "` ( `sessionId` bigint(20) NOT NULL, `day` tinyint NOT NULL, `hour` tinyint NOT NULL, `trafficTypeId` int(11) NOT NULL, `deviceId` int(11) NOT NULL, `amount` bigint(20) NOT NULL, PRIMARY KEY  (`sessionId`,`day`,`hour`, `trafficTypeId`, `deviceId`) ) /*!50106 PARTITION BY HASH( sessionId ) PARTITIONS 8*/");
        }
        if (!ServerUtils.tableExists((Connection)con, (String)(accountTableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_SESSION_LOG_ACCOUNT, (Date)date, (int)moduleId)))) {
            stmt.executeUpdate("CREATE TABLE `" + accountTableName + "` ( `contractId` int(11) NOT NULL, `sessionId` bigint(20) NOT NULL, `serviceId` int(11) NOT NULL, `amount` bigint(20) NOT NULL, `account` decimal(12,5) NOT NULL, PRIMARY KEY (`contractId`, `sessionId`, `serviceId`), INDEX `serviceId`(`serviceId`), KEY `sessionId` (`sessionId`) ) /*!50106 PARTITION BY HASH( contractId ) PARTITIONS 8*/");
        }
        if (!ServerUtils.tableExists((Connection)con, (String)(routeTableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_SESSION_LOG_ROUTE, (Date)date, (int)moduleId)))) {
            stmt.executeUpdate("CREATE TABLE `" + routeTableName + "` ( `id` INT  NOT NULL AUTO_INCREMENT, `sessionId` bigint(20) NOT NULL, `subnet` varbinary(24)  NOT NULL, `mask` INT  NOT NULL, PRIMARY KEY (`id`), INDEX `sessionId`(`sessionId`) )");
        }
        try (InetTrafficRangeDao inetTrafficRangeDao = new InetTrafficRangeDao(con, moduleId);){
            inetTrafficRangeDao.checkTables(con, stmt, date, moduleId);
        }
        TrafficMaxDao.checkTables(con, stmt, date, moduleId);
        stmt.close();
    }

    protected void updateImpl(InetSessionLog b) throws BGException, SQLException {
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            InetSessionLogDao.createTables(this.con, this.moduleId, this.date, this.tableName);
        }
        if (this.insertPS == null) {
            this.insertPS = this.con.prepareStatement("INSERT INTO " + this.tableName + " (id, parentId, connectionId, parentConnectionId, deviceId, devicePort, agentDeviceId, acctSessionId, username, type, servId, calledStationId, callingStationId, ipResourceId, ipAddress, prefixResourceId, prefix, prefixLength, delegatedPrefixResourceId, delegatedPrefix, delegatedPrefixLength, connectionStart, sessionStart, sessionStop, lastActive, sessionTime, sessionCost, status,deviceState) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
        }
        this.insertPS.setLong(1, b.getId());
        this.insertPS.setLong(2, b.getParentId());
        this.insertPS.setLong(3, b.getConnectionId());
        this.insertPS.setLong(4, b.getParentConnectionId());
        this.insertPS.setInt(5, b.getDeviceId());
        this.insertPS.setInt(6, b.getDevicePort());
        this.insertPS.setInt(7, b.getAgentDeviceId());
        this.insertPS.setString(8, b.getAcctSessionId());
        this.insertPS.setString(9, b.getUsername());
        this.insertPS.setInt(10, b.getType());
        this.insertPS.setInt(11, b.getServId());
        this.insertPS.setString(12, b.getCalledStationId());
        this.insertPS.setString(13, b.getCallingStationId());
        this.insertPS.setInt(14, b.getIpResourceId());
        this.insertPS.setBytes(15, b.getInetAddressBytes());
        this.insertPS.setInt(16, b.getPrefixResourceId());
        this.insertPS.setBytes(17, b.getPrefix());
        this.insertPS.setShort(18, b.getPrefixLength());
        this.insertPS.setInt(19, b.getDelegatedPrefixResourceId());
        this.insertPS.setBytes(20, b.getDelegatedPrefix());
        this.insertPS.setShort(21, b.getDelegatedPrefixLength());
        this.insertPS.setTimestamp(22, TimeUtils.convertDateToTimestampSeconds((Date)b.getConnectionStart()));
        this.insertPS.setTimestamp(23, TimeUtils.convertDateToTimestampSeconds((Date)b.getSessionStart()));
        this.insertPS.setTimestamp(24, TimeUtils.convertDateToTimestampSeconds((Date)b.getSessionStop()));
        this.insertPS.setTimestamp(25, TimeUtils.convertDateToTimestampSeconds((Date)b.getLastActive()));
        this.insertPS.setLong(26, b.getSessionTime());
        this.insertPS.setBigDecimal(27, b.getSessionCost());
        this.insertPS.setInt(28, b.getStatus());
        this.insertPS.setInt(29, b.getDeviceState());
        this.insertPS.executeUpdate();
        if (b.getId() <= 0L) {
            b.setId(ServerUtils.lastInsertLongId((PreparedStatement)this.insertPS));
            List routeList = b.getRouteList();
            if (routeList != null && routeList.size() > 0) {
                PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.routeTableName + " (sessionId, subnet, mask) VALUES (?,?,?)");
                ps.setLong(1, b.getId());
                int size = routeList.size();
                for (int i = 0; i < size; ++i) {
                    IpNet route = (IpNet)routeList.get(i);
                    ps.setBytes(2, route.getSubnet());
                    ps.setInt(3, route.getMask());
                    ps.executeUpdate();
                }
                ps.close();
            }
        }
    }

    public void killSessionsForServWithTraffic(Set<Integer> servIds, Set<Integer> deviceIds, Date day) throws BGException {
        if (servIds.size() > 0) {
            Date dateFrom = day;
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateFrom);
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)cal);
            dateFrom = cal.getTime();
            cal.add(5, 1);
            Date dateTo = cal.getTime();
            String query = "DELETE FROM " + this.tableName + " WHERE sessionStart >= ? AND sessionStart < ? AND servId IN (" + Utils.toString(servIds) + ") AND deviceId  IN ( " + Utils.toString(deviceIds) + ")";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)dateFrom));
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)dateTo));
                ps.executeUpdate();
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void killSessionsForServWithTraffic(Set<Integer> servIds, Set<Integer> deviceIds, Period period) throws BGException {
        if (servIds.size() > 0) {
            String query = "DELETE FROM " + this.tableName + " WHERE sessionStart >= ? AND sessionStart < ? AND servId IN (" + Utils.toString(servIds) + ") AND deviceId IN ( " + Utils.toString(deviceIds) + ")";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                ps.executeUpdate();
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public List<InetSessionLog> listChildren(long parentId) throws SQLException, BGException {
        return this.listChildren(parentId, null);
    }

    public List<InetSessionLog> listChildren(long parentId, Date date) throws SQLException, BGException {
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return new ArrayList<InetSessionLog>(0);
        }
        PreparedStatement ps = this.selectChildrenPS;
        if (ps == null) {
            ps = this.selectChildrenPS = this.con.prepareStatement("SELECT contract.title as contractTitle, contract.comment as contractComment, contract.id as contractId, serv.title as serviceTitle, session.* FROM " + this.tableName + " AS session  LEFT JOIN inet_serv_" + this.moduleId + " AS serv ON serv.id = session.servId  LEFT JOIN contract ON serv.contractId=contract.id WHERE (? OR (session.sessionStart>=? AND session.sessionStart<?)) AND session.parentId=?");
        }
        ArrayList<InetSessionLog> childrenSessionList = null;
        Date timeFrom = null;
        Date timeTo = null;
        if (date != null) {
            if (this.utilCalendar == null) {
                this.utilCalendar = new GregorianCalendar();
            }
            this.utilCalendar.setTime(date);
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)this.utilCalendar);
            timeFrom = this.utilCalendar.getTime();
            this.utilCalendar.add(5, 1);
            timeTo = this.utilCalendar.getTime();
        }
        ps.setBoolean(1, date == null);
        ps.setTimestamp(2, TimeUtils.convertDateToTimestamp(timeFrom));
        ps.setTimestamp(3, TimeUtils.convertDateToTimestamp(timeTo));
        ps.setLong(4, parentId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            InetSessionLog childSession = this.getFromRS(rs);
            childSession.setContractTitle(rs.getString("contractTitle"));
            childSession.setContractComment(rs.getString("contractComment"));
            childSession.setContractId(rs.getInt("contractId"));
            childSession.setServiceTitle(rs.getString("serviceTitle"));
            if (childrenSessionList == null) {
                childrenSessionList = new ArrayList<InetSessionLog>();
            }
            childrenSessionList.add(childSession);
        }
        rs.close();
        return childrenSessionList;
    }

    public List<InetSessionLog> list(int idDivizor, int idRemainder, Date dateFrom, Date dateTo) throws BGException {
        if (ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return super.list(" sessionStart >= ? AND sessionStart <  ? AND id % ? = ? ", null, new Object[]{TimeUtils.convertDateToSqlDate((Date)dateFrom), TimeUtils.convertDateToSqlDate((Date)dateTo), idDivizor, idRemainder});
        }
        return Collections.emptyList();
    }

    public List<InetSessionLog> listForContracts(Set<Integer> cids, Date timeFrom, Date timeTo) throws BGException {
        try {
            ArrayList<InetSessionLog> result = new ArrayList<InetSessionLog>();
            if (ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
                String query = "SELECT session. * from " + this.tableName + " as session LEFT JOIN inet_serv_" + this.moduleId + " AS serv ON serv.id = session.servId WHERE serv.contractId IN ( " + Utils.toString(cids) + ")";
                if (timeFrom != null) {
                    query = query + " AND sessionStart >= ? ";
                }
                if (timeTo != null) {
                    query = query + " AND sessionStart < ? ";
                }
                PreparedStatement ps = this.con.prepareStatement(query);
                int idx = 1;
                if (timeFrom != null) {
                    ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)timeFrom));
                }
                if (timeTo != null) {
                    ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)timeTo));
                }
                ResultSet rs = ps.executeQuery();
                boolean oldReadSessionRoute = this.readSessionRoute;
                this.setReadSessionRoute(false);
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
                this.setReadSessionRoute(oldReadSessionRoute);
                rs.close();
                ps.close();
                return result;
            }
            return Collections.emptyList();
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new BGException((Throwable)e);
        }
    }

    public List<InetSessionLog> list(Set<Integer> deviceIds, Date timeFrom, Date timeTo) throws BGException {
        try {
            if (ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
                return this.listImpl(new Page(), "deviceId IN ( " + Utils.toString(deviceIds) + ") AND sessionStart >= ? AND  sessionStart < ? ", "sessionStart", new Object[]{TimeUtils.convertDateToTimestampSeconds((Date)timeFrom), TimeUtils.convertDateToTimestampSeconds((Date)timeTo)});
            }
            return Collections.emptyList();
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new BGException((Throwable)e);
        }
    }

    public List<InetSessionLog> list(Set<Integer> deviceIds, Set<Integer> contractIds, String contract, Set<Integer> servIds, String login, String ip, String callingStation, Date timeFrom, Date timeTo, boolean asc, Page page) throws BGException {
        ArrayList<InetSessionLog> result = new ArrayList<InetSessionLog>();
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return result;
        }
        try {
            StringBuilder sb = new StringBuilder(100).append("SELECT SQL_CALC_FOUND_ROWS contract.title as contractTitle, contract.comment as contractComment, contract.id as contractId, serv.title as serviceTitle, session.* FROM " + this.tableName + " AS session");
            sb.append(" LEFT JOIN inet_serv_" + this.moduleId + " AS serv ON serv.id = session.servId");
            sb.append(" LEFT JOIN inet_serv_" + this.moduleId + " as parentServ ON serv.parentId>0 AND serv.parentId=parentServ.id");
            sb.append(" LEFT JOIN contract ON serv.contractId=contract.id");
            sb.append(" WHERE sessionStart>=? AND sessionStart<?");
            if (deviceIds != null && deviceIds.size() > 0) {
                sb.append(" AND (session.deviceId IN (" + Utils.toString(deviceIds) + ")");
                sb.append(" OR session.agentDeviceId IN (" + Utils.toString(deviceIds) + ")");
                sb.append(" OR (serv.parentId<=0 AND serv.deviceId IN (" + Utils.toString(deviceIds) + "))");
                sb.append(" OR (serv.parentId>0 AND parentServ.deviceId IN (" + Utils.toString(deviceIds) + ")))");
            }
            sb.append(" AND session.parentId=0");
            if (contractIds != null && contractIds.size() > 0) {
                sb.append(" AND serv.contractId IN (" + Utils.toString(contractIds) + ")");
            }
            if (servIds.size() > 0) {
                sb.append(" AND session.servId IN (" + Utils.toString(servIds) + ")");
            }
            if (Utils.notBlankString((String)contract)) {
                sb.append(" AND contract.title LIKE ?");
            }
            if (Utils.notBlankString((String)login)) {
                sb.append(" AND serv.login LIKE ?");
            }
            if (Utils.notBlankString((String)callingStation)) {
                sb.append(" AND (session.calledStationId LIKE ? OR session.callingStationId LIKE ?)");
            }
            byte[] ipBytes = null;
            if (Utils.notBlankString((String)ip)) {
                try {
                    ipBytes = InetAddress.getByName(ip).getAddress();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ipBytes != null) {
                sb.append(" AND (session.ipAddress=? OR (serv.addressFrom IS NOT NULL AND ((serv.addressTo IS NOT NULL AND serv.addressFrom<=? AND serv.addressTo>=?) OR (serv.addressTo IS NULL AND serv.addressFrom=?))))");
            }
            sb.append(" ORDER BY session.sessionStart ").append(asc ? " ASC" : "DESC").append(this.sqlLimit(page));
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            int idx = 1;
            ps.setTimestamp(idx++, TimeUtils.convertDateToTimestampSeconds((Date)timeFrom));
            ps.setTimestamp(idx++, TimeUtils.convertDateToTimestampSeconds((Date)timeTo));
            if (Utils.notBlankString((String)contract)) {
                ps.setString(idx++, "%" + contract.trim() + "%");
            }
            if (Utils.notBlankString((String)login)) {
                ps.setString(idx++, "%" + login.trim() + "%");
            }
            if (Utils.notBlankString((String)callingStation)) {
                ps.setString(idx++, "%" + callingStation.trim() + "%");
                ps.setString(idx++, "%" + callingStation.trim() + "%");
            }
            if (ipBytes != null) {
                ps.setBlob(idx++, new ByteArrayInputStream(ipBytes));
                ps.setBlob(idx++, new ByteArrayInputStream(ipBytes));
                ps.setBlob(idx++, new ByteArrayInputStream(ipBytes));
                ps.setBlob(idx++, new ByteArrayInputStream(ipBytes));
            }
            ResultSet rs = ps.executeQuery();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
            while (rs.next()) {
                InetSessionLog session = this.getFromRS(rs);
                session.setContractTitle(rs.getString("contractTitle"));
                session.setContractComment(rs.getString("contractComment"));
                session.setContractId(rs.getInt("contractId"));
                session.setServiceTitle(rs.getString("serviceTitle"));
                List<InetSessionLog> childrenSessionList = this.listChildren(session.getId(), session.getSessionStart());
                session.setChildren(childrenSessionList);
                result.add(session);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    protected PreparedStatement getPs(int contractId, Collection<Integer> servIds, Period period, Page page, String sql) throws SQLException {
        sql = this.addWherePart(servIds, period, (String)sql);
        sql = (String)sql + " ORDER BY session.sessionStart ";
        sql = (String)sql + this.sqlLimit(page);
        PreparedStatement ps = this.con.prepareStatement((String)sql);
        this.setParams(contractId, period, ps);
        return ps;
    }

    protected void setParams(int cid, Period period, PreparedStatement ps) throws SQLException {
        int idx = 1;
        ps.setInt(idx++, cid);
        if (period.getDateFrom() != null) {
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
        }
        if (period.getDateTo() != null) {
            Calendar endDate = (Calendar)period.getDateToCalendar().clone();
            endDate.add(5, 1);
            ps.setDate(idx++, TimeUtils.convertCalendarToSqlDate((Calendar)endDate));
        }
    }

    protected String addWherePart(Collection<Integer> servIds, Period period, String sql) {
        if (servIds.size() > 0) {
            sql = (String)sql + " AND serv.id IN (" + Utils.toString(servIds) + ")";
        }
        if (period.getDateFrom() != null) {
            sql = (String)sql + " AND session.sessionStart >=? ";
        }
        if (period.getDateTo() != null) {
            sql = (String)sql + " AND session.sessionStart < ? ";
        }
        return sql;
    }

    public void getSumReportInfo(int cid, Collection<Integer> servIds, Period period, Result<?> result) throws BGException {
        result.setAttribute("totalCount", (Object)0);
        result.setAttribute("totalCost", (Object)BigDecimal.ZERO);
        result.setAttribute("totalTime", (Object)0);
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT COUNT( session.id ), SUM( session. sessionCost ), SUM( session.sessionTime )");
            sb.append(" FROM ").append(this.tableName).append(" AS session");
            if (this.date == null) {
                sb.append(" LEFT JOIN inet_connection_").append(this.moduleId).append(" AS connection ON connection.id=session.connectionId");
                sb.append(" LEFT JOIN inet_serv_").append(this.moduleId).append(" AS serv ON serv.id=connection.servId");
            } else {
                sb.append(" LEFT JOIN inet_serv_").append(this.moduleId).append(" AS serv ON serv.id=session.servId");
            }
            sb.append(" WHERE serv.contractId=?");
            PreparedStatement ps = this.getPs(cid, servIds, period, null, sb.toString());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                BigDecimal cost = rs.getBigDecimal(2);
                long time = rs.getLong(3);
                result.setAttribute("totalCost", (Object)Utils.maskNull((BigDecimal)cost));
                result.setAttribute("totalTime", (Object)time);
            }
            rs.close();
            ps.close();
            if (this.date == null) {
                sb.append(" AND connection.parentId=0");
            } else {
                sb.append(" AND session.parentConnectionId=0");
            }
            ps = this.getPs(cid, servIds, period, null, sb.toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                int count = rs.getInt(1);
                result.setAttribute("totalCount", (Object)count);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void populateSessionTraffics(List<InetSessionLog> sessions, Collection<Integer> trafficTypeIds) throws BGException {
        HashMap<Long, HashMap<Integer, Long>> result = new HashMap<Long, HashMap<Integer, Long>>();
        ArrayList<Long> sessionIds = new ArrayList<Long>();
        for (InetSessionLog session : sessions) {
            sessionIds.add(session.getId());
        }
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.detailTableName)) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder(100);
            sb.append("SELECT sessionId, trafficTypeId, sum(amount) as amount FROM ").append(this.detailTableName).append(" AS detail WHERE 1=1");
            if (sessionIds.size() > 0) {
                sb.append(" AND detail.sessionId IN ( ").append(Utils.toString(sessionIds)).append(")");
            }
            if (trafficTypeIds.size() > 0) {
                sb.append(" AND detail.trafficTypeId IN ( ").append(Utils.toString(trafficTypeIds)).append(")");
            }
            sb.append(" AND day!=0 GROUP BY sessionId, trafficTypeId ");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                long sessionId = rs.getLong("sessionId");
                int trafficTypeId = rs.getInt("trafficTypeId");
                Long amount = rs.getLong("amount");
                HashMap<Integer, Long> traffics = (HashMap<Integer, Long>)result.get(sessionId);
                if (traffics == null) {
                    traffics = new HashMap<Integer, Long>();
                    result.put(sessionId, traffics);
                }
                traffics.put(trafficTypeId, amount);
            }
            rs.close();
            ps.close();
            for (InetSessionLog session : sessions) {
                Map traffics = (Map)result.get(session.getId());
                if (traffics == null) continue;
                session.setTrafficMap(traffics);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void loadTraffics(List<InetSessionLog> sessions, Collection<Integer> trafficTypeIds) throws BGException {
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.detailTableName)) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder(100).append("SELECT trafficTypeId, sum(amount) as amount FROM ").append(this.detailTableName).append(" AS detail WHERE sessionId=?");
            if (trafficTypeIds != null && trafficTypeIds.size() > 0) {
                sb.append(" AND detail.trafficTypeId IN ( ").append(Utils.toString(trafficTypeIds)).append(")");
            }
            sb.append(" AND day!=0 GROUP BY trafficTypeId");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            for (InetSessionLog sessionLog : sessions) {
                InetSessionLogDao.loadTraffics(ps, sessionLog);
                List children = sessionLog.getChildren();
                if (children == null || children.size() <= 0) continue;
                for (InetSessionLog serviceSessionLog : children) {
                    InetSessionLogDao.loadTraffics(ps, serviceSessionLog);
                }
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private static void loadTraffics(PreparedStatement ps, InetSessionLog sessionLog) throws SQLException {
        ps.setLong(1, sessionLog.getId());
        HashMap<Integer, Long> trafficMap = new HashMap<Integer, Long>(8);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int traffciTypeId = rs.getInt("trafficTypeId");
            Long amount = rs.getLong("amount");
            trafficMap.put(traffciTypeId, amount);
        }
        rs.close();
        sessionLog.setTrafficMap(trafficMap);
    }

    public void loadAccount(List<InetSessionLog> sessions, Collection<Integer> serviceIds) throws BGException {
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.accountTableName)) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder(100).append("SELECT serviceId, sum(amount) as amount, sum(account) as account FROM ").append(this.accountTableName).append(" WHERE sessionId=? AND contractId=?");
            if (serviceIds != null && serviceIds.size() > 0) {
                sb.append(" AND serviceId IN ( ").append(Utils.toString(serviceIds)).append(")");
            }
            sb.append(" GROUP BY serviceId");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            for (InetSessionLog sessionLog : sessions) {
                InetSessionLogDao.loadAccount(ps, sessionLog);
                List children = sessionLog.getChildren();
                if (children == null || children.size() <= 0) continue;
                for (InetSessionLog serviceSessionLog : children) {
                    InetSessionLogDao.loadAccount(ps, serviceSessionLog);
                }
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private static void loadAccount(PreparedStatement ps, InetSessionLog sessionLog) throws SQLException {
        ps.setLong(1, sessionLog.getId());
        ps.setInt(2, sessionLog.getContractId());
        HashMap<Integer, InetSessionLogAccount> accountMap = new HashMap<Integer, InetSessionLogAccount>(8);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int serviceId = rs.getInt("serviceId");
            long amount = rs.getLong("amount");
            BigDecimal account = rs.getBigDecimal("account");
            accountMap.put(serviceId, new InetSessionLogAccount(amount, account));
        }
        rs.close();
        sessionLog.setAccountMap(accountMap);
    }

    public Map<Integer, Long> getSessionTrafficsReport(int cid, Collection<Integer> servIds, Period period, Collection<Integer> trafficTypeIds) throws BGException {
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        try {
            if (!ServerUtils.tableExists((Connection)this.con, (String)this.detailTableName)) {
                return result;
            }
            Object sql = this.date == null ? "SELECT SUM( detail.amount) AS amount , detail.trafficTypeId AS  trafficTypeId FROM " + this.tableName + " AS session  LEFT JOIN inet_connection_" + this.moduleId + " AS connection ON connection.id = session.connectionId  LEFT JOIN inet_serv_" + this.moduleId + " AS serv ON serv.id = connection.servId  LEFT JOIN " + this.detailTableName + " AS detail ON detail.sessionId = session.Id  WHERE serv.contractId=? AND detail.day!=0 " : "SELECT SUM( detail.amount) AS amount , detail.trafficTypeId AS  trafficTypeId FROM " + this.tableName + " AS session  LEFT JOIN inet_serv_" + this.moduleId + " AS serv ON serv.id = session.servId  LEFT JOIN " + this.detailTableName + " AS detail ON detail.sessionId = session.Id  WHERE serv.contractId=? AND detail.day!=0";
            sql = this.addWherePart(servIds, period, (String)sql);
            if (trafficTypeIds != null && trafficTypeIds.size() > 0) {
                sql = (String)sql + " AND detail.trafficTypeId IN ( " + Utils.toString(trafficTypeIds) + ")";
            }
            sql = (String)sql + " GROUP BY detail.trafficTypeId ";
            PreparedStatement ps = this.con.prepareStatement((String)sql);
            this.setParams(cid, period, ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                long amount = rs.getLong("amount");
                int traffciTypeId = rs.getInt("trafficTypeId");
                result.put(traffciTypeId, amount);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public TrafficAccountDetail getSessionAccountSums(int cid, Collection<Integer> servIds, Period period, Collection<Integer> serviceIds) throws BGException {
        TrafficAccountDetail result = new TrafficAccountDetail();
        try {
            if (!ServerUtils.tableExists((Connection)this.con, (String)this.detailTableName)) {
                return result;
            }
            Object sql = this.date == null ? "SELECT SUM( account.amount ) as amount, SUM( account.account ) AS account, account.serviceId AS  serviceId  FROM " + this.tableName + " AS session  LEFT JOIN inet_connection_" + this.moduleId + " AS connection ON connection.id = session.connectionId  LEFT JOIN inet_serv_" + this.moduleId + " AS serv ON serv.id = connection.servId  LEFT JOIN " + this.accountTableName + " AS account ON account.sessionId = session.Id  WHERE serv.contractId=? " : "SELECT SUM( account.amount ) as amount, SUM( account.account ) AS account, account.serviceId AS  serviceId  FROM " + this.tableName + " AS session  LEFT JOIN inet_serv_" + this.moduleId + " AS serv ON serv.id = session.servId  LEFT JOIN " + this.accountTableName + " AS account ON account.sessionId = session.Id  WHERE serv.contractId=?";
            sql = this.addWherePart(servIds, period, (String)sql);
            if (serviceIds != null && serviceIds.size() > 0) {
                sql = (String)sql + " AND account.serviceId IN ( " + Utils.toString(serviceIds) + ")";
            }
            sql = (String)sql + " GROUP BY account.serviceId ";
            PreparedStatement ps = this.con.prepareStatement((String)sql);
            this.setParams(cid, period, ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                long amount = rs.getLong("amount");
                int serviceId = rs.getInt("serviceId");
                BigDecimal account = rs.getBigDecimal("account");
                result.getAccountMap().put(serviceId, new TrafficAccount(amount, account));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<InetSessionLog> list(long connectionId) throws BGException {
        if (ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return this.list("connectionId=?", "id", new Object[]{connectionId});
        }
        return Collections.emptyList();
    }

    public InetSessionLog get(long id) throws BGException {
        InetSessionLog result = (InetSessionLog)super.get("id=?", new Object[]{id});
        if (result != null) {
            try {
                result.setChildren(this.listChildren(result.getId()));
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
        return result;
    }

    private void newTrafficQuery(StringBuilder sb, boolean log, int contractId, Set<Integer> inetServIds, int sessionId, Set<Integer> trafficTypeIds, Period period) {
        if (log) {
            String detailTableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_SESSION_LOG_DETAIL, (Date)this.date, (int)this.moduleId);
            sb.append(" FROM ").append(this.tableName).append(" as log");
            sb.append(" LEFT JOIN ").append(detailTableName);
            sb.append(" as detail ON detail.sessionId=log.id");
            sb.append(" LEFT JOIN inet_serv_").append(this.moduleId).append(" as serv ON log.servId=serv.id");
            sb.append(" WHERE (? OR log.id=?)");
            if (inetServIds != null && inetServIds.size() > 0) {
                sb.append(" AND log.servId IN (").append(Utils.toString(inetServIds)).append(")");
            }
        } else {
            sb.append(" FROM ").append(ServerUtils.getModuleTableName((String)TABLE_INET_SESSION, (int)this.moduleId)).append(" as log");
            sb.append(" LEFT JOIN ").append(ServerUtils.getModuleTableName((String)TABLE_INET_SESSION_DETAIL, (int)this.moduleId));
            sb.append(" as detail ON detail.sessionId=log.id");
            sb.append(" LEFT JOIN inet_connection_").append(this.moduleId).append(" as c ON c.id=log.connectionId");
            sb.append(" LEFT JOIN inet_serv_").append(this.moduleId).append(" as serv ON c.servId=serv.id");
            sb.append(" WHERE (? OR log.id=?)");
            if (inetServIds != null && inetServIds.size() > 0) {
                sb.append(" AND c.servId IN (").append(Utils.toString(inetServIds)).append(")");
            }
        }
        sb.append(" AND detail.trafficTypeId>0");
        if (trafficTypeIds != null && trafficTypeIds.size() > 0) {
            sb.append(" AND detail.trafficTypeId IN (").append(Utils.toString(trafficTypeIds)).append(")");
        }
        sb.append(" AND (? OR serv.contractId=?) AND (? OR detail.day>=?) AND (? OR detail.day<=?) AND detail.day>0 AND detail.trafficTypeId>0");
        if (!log) {
            sb.append(" AND ((? OR DATE(log.sessionStart)>=?) AND (? OR DATE(log.sessionStart)<=?))");
        }
    }

    private void setTrafficPSParams(PreparedStatement ps, int contractId, int sessionId, Period period, int pos, boolean log) throws SQLException {
        ps.setBoolean(pos + 1, sessionId <= 0);
        ps.setInt(pos + 2, sessionId);
        ps.setBoolean(pos + 3, contractId <= 0);
        ps.setInt(pos + 4, contractId);
        GregorianCalendar calendar = new GregorianCalendar();
        if (period.getDateFrom() != null) {
            calendar.setTime(period.getDateFrom());
            ps.setBoolean(pos + 5, false);
            ps.setInt(pos + 6, calendar.get(5));
            if (!log) {
                ps.setBoolean(pos + 9, false);
                ps.setDate(pos + 10, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            }
        } else {
            ps.setBoolean(pos + 5, true);
            ps.setInt(pos + 6, 0);
            if (!log) {
                ps.setBoolean(pos + 9, true);
                ps.setDate(pos + 10, null);
            }
        }
        if (period.getDateTo() != null) {
            calendar.setTime(period.getDateTo());
            ps.setBoolean(pos + 7, false);
            ps.setInt(pos + 8, calendar.get(5));
            if (!log) {
                ps.setBoolean(pos + 11, false);
                ps.setDate(pos + 12, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            }
        } else {
            ps.setBoolean(pos + 7, true);
            ps.setInt(pos + 8, 0);
            if (!log) {
                ps.setBoolean(pos + 11, true);
                ps.setDate(pos + 12, null);
            }
        }
    }

    private PreparedStatement newTrafficPS(boolean includeActive, int contractId, Set<Integer> inetServIds, int sessionId, Set<Integer> trafficTypeIds, Period period, boolean byDay) throws SQLException {
        StringBuilder sb = new StringBuilder(100);
        if (byDay) {
            sb.append("SELECT detail.day, detail.trafficTypeId, SUM(detail.amount)");
        } else {
            sb.append("SELECT detail.day, detail.hour, detail.trafficTypeId, SUM(detail.amount)");
        }
        if (includeActive) {
            sb.append(" FROM (\n");
            sb.append("SELECT detail.day, detail.hour, detail.trafficTypeId, detail.amount");
            this.newTrafficQuery(sb, true, contractId, inetServIds, sessionId, trafficTypeIds, period);
            sb.append("\nUNION ALL\n");
            sb.append("SELECT detail.day, detail.hour, detail.trafficTypeId, detail.amount");
            this.newTrafficQuery(sb, false, contractId, inetServIds, sessionId, trafficTypeIds, period);
            sb.append("\n) as detail");
        } else {
            this.newTrafficQuery(sb, true, contractId, inetServIds, sessionId, trafficTypeIds, period);
        }
        if (byDay) {
            sb.append(" GROUP BY day, trafficTypeId ORDER BY day");
        } else {
            sb.append(" GROUP BY day, hour, trafficTypeId ORDER BY day, hour");
        }
        PreparedStatement ps = this.con.prepareStatement(sb.toString());
        this.setTrafficPSParams(ps, contractId, sessionId, period, 0, true);
        if (includeActive) {
            this.setTrafficPSParams(ps, contractId, sessionId, period, 8, false);
        }
        return ps;
    }

    public List<TrafficAmount> traffic(int contractId, Set<Integer> inetServIds, int sessionId, Set<Integer> trafficTypeIds, Period period, boolean byDay, boolean includeActive, boolean continuous) throws BGException {
        try {
            ArrayList<TrafficAmount> result = new ArrayList<TrafficAmount>();
            if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
                return result;
            }
            if (!ServerUtils.tableExists((Connection)this.con, (String)this.detailTableName)) {
                return result;
            }
            PreparedStatement ps = this.newTrafficPS(includeActive, contractId, inetServIds, sessionId, trafficTypeIds, period, byDay);
            int currentDay = -1;
            int currentHour = -1;
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.date);
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
            calendar.set(5, 1);
            TrafficAmount currentTraffic = null;
            if (byDay) {
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        int day = rs.getInt(1);
                        int trafficTypeId = rs.getInt(2);
                        long amount = rs.getLong(3);
                        if (day != currentDay) {
                            if (continuous && currentDay != -1) {
                                while (currentDay + 1 < day) {
                                    ((Calendar)calendar).add(5, 1);
                                    currentTraffic = new TrafficAmount();
                                    currentTraffic.setPeriod(calendar.getTime());
                                    currentTraffic.setPeriodDay(++currentDay);
                                    currentTraffic.setPeriodHour(0);
                                    currentTraffic.setTrafficMap(new HashMap());
                                    result.add(currentTraffic);
                                }
                            }
                            calendar.set(5, day);
                            currentDay = day;
                            currentTraffic = new TrafficAmount();
                            currentTraffic.setPeriod(calendar.getTime());
                            currentTraffic.setPeriodDay(day);
                            currentTraffic.setPeriodHour(0);
                            currentTraffic.setTrafficMap(new HashMap());
                            result.add(currentTraffic);
                        }
                        currentTraffic.getTrafficMap().put(trafficTypeId, amount);
                    }
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int day = rs.getInt(1);
                    int hour = rs.getInt(2);
                    int trafficTypeId = rs.getInt(3);
                    long amount = rs.getLong(4);
                    if (day != currentDay || hour != currentHour) {
                        if (continuous && currentDay != -1) {
                            while (currentDay < day || currentHour + 1 < hour) {
                                ((Calendar)calendar).add(11, 1);
                                currentDay = calendar.get(5);
                                currentHour = calendar.get(11);
                                currentTraffic = new TrafficAmount();
                                currentTraffic.setPeriod(calendar.getTime());
                                currentTraffic.setPeriodDay(currentDay);
                                currentTraffic.setPeriodHour(currentHour);
                                currentTraffic.setTrafficMap(new HashMap());
                                result.add(currentTraffic);
                            }
                        }
                        calendar.set(11, 0);
                        calendar.set(5, day);
                        calendar.set(11, hour);
                        currentDay = day;
                        currentHour = hour;
                        currentTraffic = new TrafficAmount();
                        currentTraffic.setPeriod(calendar.getTime());
                        currentTraffic.setPeriodDay(day);
                        currentTraffic.setPeriodHour(hour);
                        currentTraffic.setTrafficMap(new HashMap());
                        result.add(currentTraffic);
                    }
                    currentTraffic.getTrafficMap().put(trafficTypeId, amount);
                }
            }
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public boolean isReadSessionRoute() {
        return this.readSessionRoute;
    }

    public void setReadSessionRoute(boolean readSessionRoute) {
        this.readSessionRoute = readSessionRoute;
    }

    public Map<Integer, Long> getSessionAccountReport(int cid, Collection<Integer> servIds, Period period, Collection<Integer> trafficTypeIds) throws BGException {
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        try {
            if (!ServerUtils.tableExists((Connection)this.con, (String)this.detailTableName)) {
                return result;
            }
            Object sql = this.date == null ? "SELECT SUM( detail.amount) AS amount , detail.trafficTypeId AS  trafficTypeId FROM " + this.tableName + " AS session  LEFT JOIN inet_connection_" + this.moduleId + " AS connection ON connection.id = session.connectionId  LEFT JOIN inet_serv_" + this.moduleId + " AS serv ON serv.id = connection.servId  LEFT JOIN " + this.detailTableName + " AS detail ON detail.sessionId = session.Id  WHERE serv.contractId=? AND detail.day!=0 " : "SELECT SUM( detail.amount) AS amount , detail.trafficTypeId AS  trafficTypeId FROM " + this.tableName + " AS session  LEFT JOIN inet_serv_" + this.moduleId + " AS serv ON serv.id = session.servId  LEFT JOIN " + this.detailTableName + " AS detail ON detail.sessionId = session.Id  WHERE serv.contractId=? AND detail.day!=0";
            sql = this.addWherePart(servIds, period, (String)sql);
            if (trafficTypeIds != null && trafficTypeIds.size() > 0) {
                sql = (String)sql + " AND detail.trafficTypeId IN ( " + Utils.toString(trafficTypeIds) + ")";
            }
            sql = (String)sql + " GROUP BY detail.trafficTypeId ";
            PreparedStatement ps = this.con.prepareStatement((String)sql);
            this.setParams(cid, period, ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                long amount = rs.getLong("amount");
                int trafficTypeId = rs.getInt("trafficTypeId");
                result.put(trafficTypeId, amount);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public static void fixSequence(Connection con, int moduleId) throws SQLException {
        Logger logger = LogManager.getLogger();
        String sessionSeqTableName = "inet_session_" + moduleId + "_seq";
        String connectionSeqTableName = "inet_connection_" + moduleId + "_seq";
        logger.debug("fixSequence( moduleId={} ); sessionSeqTableName = {}; connectionSeqTableName = {}", (Object)moduleId, (Object)sessionSeqTableName, (Object)connectionSeqTableName);
        boolean connectionSeqTableExists = ServerUtils.tableExists((Connection)con, (String)connectionSeqTableName);
        boolean sessionSeqTableExists = ServerUtils.tableExists((Connection)con, (String)sessionSeqTableName);
        logger.debug("connectionSeqTableExists = {}; sessionSeqTableExists = {}", (Object)connectionSeqTableExists, (Object)sessionSeqTableExists);
        if (!connectionSeqTableExists || !sessionSeqTableExists) {
            long connectionId = 0L;
            long sessionId = 0L;
            try (Statement stmt = con.createStatement();){
                String queryInsert;
                String queryCreate;
                ResultSet rs;
                String querySelectMaxId;
                String querySelectMaxConnectionId = "SELECT MAX(id) FROM inet_connection_" + moduleId;
                try (ResultSet rs2 = stmt.executeQuery(querySelectMaxConnectionId);){
                    if (rs2.next()) {
                        connectionId = Math.max(connectionId, rs2.getLong(1));
                    }
                }
                logger.debug("{} => {}", (Object)querySelectMaxConnectionId, (Object)connectionId);
                String querySelectMaxSessionId = "SELECT MAX(id) FROM inet_session_" + moduleId;
                try (ResultSet rs3 = stmt.executeQuery(querySelectMaxSessionId);){
                    if (rs3.next()) {
                        sessionId = Math.max(sessionId, rs3.getLong(1));
                    }
                }
                logger.debug("{} => {}", (Object)querySelectMaxSessionId, (Object)sessionId);
                GregorianCalendar calendar = new GregorianCalendar();
                TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
                String tableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_SESSION_LOG, (Date)calendar.getTime(), (int)moduleId);
                boolean tableNameExists = ServerUtils.tableExists((Connection)con, (String)tableName);
                logger.debug("tableName = {} => {}", (Object)tableName, (Object)tableNameExists);
                if (tableNameExists) {
                    querySelectMaxId = "SELECT MAX(id), MAX(connectionId) FROM " + tableName;
                    rs = stmt.executeQuery(querySelectMaxId);
                    try {
                        if (rs.next()) {
                            sessionId = Math.max(sessionId, rs.getLong(1));
                            connectionId = Math.max(connectionId, rs.getLong(2));
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    logger.debug("query = {} => sessionId = {}; connectionId = {}", (Object)querySelectMaxId, (Object)sessionId, (Object)connectionId);
                }
                calendar.set(5, 1);
                ((Calendar)calendar).add(2, -1);
                tableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_SESSION_LOG, (Date)calendar.getTime(), (int)moduleId);
                tableNameExists = ServerUtils.tableExists((Connection)con, (String)tableName);
                logger.debug("tableName = {} => {}", (Object)tableName, (Object)tableNameExists);
                if (tableNameExists) {
                    querySelectMaxId = "SELECT MAX(id), MAX(connectionId) FROM " + tableName;
                    rs = stmt.executeQuery(querySelectMaxId);
                    try {
                        if (rs.next()) {
                            sessionId = Math.max(sessionId, rs.getLong(1));
                            connectionId = Math.max(connectionId, rs.getLong(2));
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    logger.debug("query = {} => sessionId = {}; connectionId = {}", (Object)querySelectMaxId, (Object)sessionId, (Object)connectionId);
                }
                if (sessionId > 0L || connectionId > 0L) {
                    sessionId += 1000L;
                    connectionId += 1000L;
                }
                logger.debug("sessionId = {}; connectionId = {}", (Object)sessionId, (Object)connectionId);
                connectionSeqTableExists = ServerUtils.tableExists((Connection)con, (String)connectionSeqTableName);
                logger.debug("connectionSeqTableExists = {}", (Object)connectionSeqTableExists);
                if (!connectionSeqTableExists) {
                    queryCreate = "CREATE TABLE " + connectionSeqTableName + " ( id bigint(20) NOT NULL AUTO_INCREMENT, PRIMARY KEY(id) )";
                    queryInsert = "INSERT INTO " + connectionSeqTableName + " VALUES (" + connectionId + ")";
                    stmt.executeUpdate(queryCreate);
                    stmt.executeUpdate(queryInsert);
                    logger.debug("queryCreate = {}", (Object)queryCreate);
                    logger.debug("queryInsert = {}", (Object)queryInsert);
                } else {
                    InetSessionLogDao.alterSequenceTable(con, connectionSeqTableName);
                }
                sessionSeqTableExists = ServerUtils.tableExists((Connection)con, (String)sessionSeqTableName);
                logger.debug("sessionSeqTableExists = {}", (Object)sessionSeqTableExists);
                if (!sessionSeqTableExists) {
                    queryCreate = "CREATE TABLE " + sessionSeqTableName + " ( id bigint(20) NOT NULL AUTO_INCREMENT, PRIMARY KEY(id) )";
                    queryInsert = "INSERT INTO " + sessionSeqTableName + " VALUES (" + sessionId + ")";
                    stmt.executeUpdate(queryCreate);
                    stmt.executeUpdate(queryInsert);
                    logger.debug("queryCreate = {}", (Object)queryCreate);
                    logger.debug("queryInsert = {}", (Object)queryInsert);
                }
                InetSessionLogDao.alterSequenceTable(con, sessionSeqTableName);
            }
        } else {
            InetSessionLogDao.alterSequenceTable(con, connectionSeqTableName);
            InetSessionLogDao.alterSequenceTable(con, sessionSeqTableName);
        }
        if (!con.getAutoCommit()) {
            con.commit();
        }
    }

    private static void alterSequenceTable(Connection con, String sequenceTable) throws SQLException {
        String query = "ALTER TABLE " + sequenceTable + " MODIFY id bigint(20) AUTO_INCREMENT";
        LogManager.getLogger().debug("alterSequenceTable => {}", (Object)query);
        try (Statement stmt = con.createStatement();){
            stmt.executeUpdate(query);
        }
    }

    public String getDetailTableName() {
        return this.detailTableName;
    }

    public String getSessionTableName() {
        return this.tableName;
    }
}

