/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.tariff;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.TariffPanelEditor;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class InetOptionAddTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"fugue/tag-label");
    private int inetOptionId;
    private String inetOptionTitle;
    private String inetOptionMode;
    private ButtonGroup inetOptionButtonGroup;
    private JRadioButton constInetOptionMode;
    private JRadioButton varInetOptionMode;
    private BGUComboBox<TariffVar> tariffVars;
    private BGUComboBox<IdTitle> inetOptionCombo;
    private Directory inetOptionDir;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.inetOptionDir = this.getDirManager().getDirectory("inetOption");
        try {
            if (tree.getParent() instanceof TariffPanelEditor) {
                TariffVar tariffVar = new TariffVar();
                tariffVar.setId(0);
                tariffVar.setTitle("---");
                this.vars.add(tariffVar);
                int moduleId = this.getModuleId(parent);
                TariffPanelEditor tariffPanelEditor = (TariffPanelEditor)tree.getParent();
                this.vars.addAll(tariffPanelEditor.getTariffService().tariffVars(TariffVarType.INET_OPTION, Arrays.asList(tariffPanelEditor.getTariffPlanId(), 0)).stream().filter(a -> a.getModuleId() == moduleId || a.getModuleId() == 0).toList());
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    protected JPanel getEditorPanel() throws Exception {
        if (this.inetOptionCombo == null) {
            this.inetOptionCombo = new BGUComboBox();
            ArrayList<IdTitle> optionItems = new ArrayList<IdTitle>(this.inetOptionDir.getItems());
            optionItems.add(0, new IdTitle(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
            this.inetOptionCombo.setData(optionItems);
            this.constInetOptionMode = new JRadioButton("\u043e\u043f\u0446\u0438\u044f \u0438\u0437 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u044b", true);
            this.constInetOptionMode.setActionCommand("const");
            this.varInetOptionMode = new JRadioButton("\u043e\u043f\u0446\u0438\u044f \u0438\u0437 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439");
            this.varInetOptionMode.setActionCommand("var");
            this.inetOptionButtonGroup = new ButtonGroup();
            this.inetOptionButtonGroup.add(this.constInetOptionMode);
            this.inetOptionButtonGroup.add(this.varInetOptionMode);
            this.tariffVars = new BGUComboBox();
            this.tariffVars.setData(this.vars);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getInetOptionConstPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        panel.add((Component)this.getInetOptionVarPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        return panel;
    }

    private JPanel getInetOptionConstPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.constInetOptionMode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.inetOptionCombo, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getInetOptionVarPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.varInetOptionMode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.tariffVars, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    public Component getView() throws Exception {
        this.extractData();
        StringBuffer title = new StringBuffer();
        if ("const".equals(this.inetOptionMode)) {
            title.append("\u041e\u043f\u0446\u0438\u044f: ");
            title.append(this.inetOptionTitle);
        } else if ("var".equals(this.inetOptionMode)) {
            title.append("\u041e\u043f\u0446\u0438\u044f \u0438\u0437 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439: ");
            title.append((String)(this.tariffVar != null ? "< " + this.tariffVar.getTitle() + " (" + this.getTariffVarValue(this.tariffVar).replaceAll("^(\\d+):(.*)", "$2 [#$1]") + ") >" : "???"));
        }
        JLabel view = new JLabel(icon, 2);
        view.setText(title.toString());
        return view;
    }

    private void extractData() throws Exception {
        Map data = this.getDataInHash();
        this.inetOptionMode = data.getOrDefault("inetOptionMode", "const");
        this.inetOptionId = Utils.parseInt((String)((String)data.get("inetOptionId")));
        this.inetOptionTitle = this.inetOptionDir.getValue(this.inetOptionId);
        int tariffVarId = Utils.parseInt((String)data.getOrDefault("tariffVarId", "0"), (int)0);
        this.tariffVar = this.vars.isEmpty() ? null : this.vars.stream().filter(a -> a.getId() == tariffVarId).findFirst().orElse((TariffVar)this.vars.get(0));
    }

    protected void loadData() throws Exception {
        this.extractData();
        this.inetOptionButtonGroup.getElements().asIterator().forEachRemaining(a -> {
            if (a.getActionCommand().equals(this.inetOptionMode)) {
                a.setSelected(true);
            }
        });
        this.setDirectoryItemSelection((JComboBox)this.inetOptionCombo, this.inetOptionId);
        this.tariffVars.setSelectedItem((Object)this.tariffVar);
    }

    protected void editOk() {
        String mode = this.inetOptionButtonGroup.getSelection().getActionCommand();
        if ("var".equals(mode) && ((TariffVar)this.tariffVars.getSelectedItem()).getId() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
            return;
        }
        if ("const".equals(mode) && ((IdTitle)this.inetOptionCombo.getSelectedItem()).getId() == -1) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e");
            return;
        }
        this.inetOptionId = this.getIdFromDirectoryCombo((JComboBox)this.inetOptionCombo);
        super.editOk();
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("inetOptionId", String.valueOf(this.inetOptionId));
        data.put("inetOptionMode", this.inetOptionButtonGroup.getSelection().getActionCommand());
        data.put("tariffVarId", String.valueOf(this.tariffVars.getSelectedItem() != null ? ((TariffVar)this.tariffVars.getSelectedItem()).getId() : 0));
        this.setDataInHash(data);
    }

    public void serializeToXML(Element el) throws Exception {
        this.extractData();
        super.serializeToXML(el);
        el.setAttribute("inetOptionId", String.valueOf(this.inetOptionId));
        el.setAttribute("inetOptionMode", this.inetOptionMode);
        el.setAttribute("tariffVarId", String.valueOf(this.tariffVars.getSelectedItem() != null ? ((TariffVar)this.tariffVars.getSelectedItem()).getId() : 0));
        this.serializeChildsToXML(el);
    }

    public void loadFromXML(Element el) throws Exception {
        this.inetOptionMode = el.getAttribute("inetOptionMode");
        this.inetOptionId = Utils.parseInt((String)el.getAttribute("inetOptionId"));
        this.inetOptionTitle = this.inetOptionDir.getValue(this.inetOptionId);
        int tariffVarId = Utils.parseInt((String)el.getAttribute("tariffVarId"), (int)0);
        this.tariffVar = this.vars.isEmpty() ? null : this.vars.stream().filter(a -> a.getId() == tariffVarId).findFirst().orElse((TariffVar)this.vars.get(0));
        this.serializeData();
        this.saveData();
        this.loadChildsFromXML(el);
    }
}

