/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.util.TimeoutListMapOld;
import ru.bitel.common.util.TimeoutMapOld;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;

public class InetDhcpOfferedAddressMap {
    private final TimeoutMapOld<OfferKey, Offered> map = new TimeoutMapOld(new DelayQueue(), "dhcp-offer-cleaner");
    private final TimeoutListMapOld<Integer, Offered> servMap = new TimeoutListMapOld(new DelayQueue(), "dhcp-offer-cleaner");
    private final boolean useXid;

    public InetDhcpOfferedAddressMap() {
        this(true);
    }

    public InetDhcpOfferedAddressMap(boolean useXid) {
        this.useXid = useXid;
    }

    public IpResourceReserve offer(int deviceId, Integer inetServId, int xid, byte[] mac, InetServ serv, List<InetServRuntime> childrenServRuntimeList, List<InetConnectionRuntime> existConnections, int errorCode) {
        return this.offer(deviceId, inetServId, xid, mac, serv, childrenServRuntimeList, existConnections, errorCode, 25000L);
    }

    public IpResourceReserve offer(int deviceId, Integer inetServId, int xid, byte[] mac, InetServ serv, List<InetServRuntime> childrenServRuntimeList, List<InetConnectionRuntime> existConnections, int errorCode, long timeout) {
        HashSet<IpAddress> usedAddress = new HashSet<IpAddress>();
        for (InetConnectionRuntime connectionRuntime : existConnections) {
            usedAddress.add(new IpAddress(connectionRuntime.connection.getInetAddressBytes()));
        }
        IpResourceReserve result = this.offer(deviceId, inetServId, xid, mac, serv, existConnections, errorCode, usedAddress, timeout);
        if (result != null) {
            return result;
        }
        if (childrenServRuntimeList != null && childrenServRuntimeList.size() > 0) {
            int size = childrenServRuntimeList.size();
            for (int i = 0; i < size; ++i) {
                InetServRuntime childServRuntime = childrenServRuntimeList.get(i);
                result = this.offer(deviceId, inetServId, xid, mac, childServRuntime.getInetServ(), existConnections, errorCode, usedAddress, timeout);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private IpResourceReserve offer(int deviceId, Integer inetServId, int xid, byte[] mac, InetServ serv, List<InetConnectionRuntime> existConnections, int errorCode, Set<IpAddress> usedAddress, long timeout) {
        Object offered;
        byte[] result = null;
        byte[] addressFrom = serv.getAddressFrom();
        byte[] addressTo = serv.getAddressTo();
        if (addressFrom != null) {
            IpAddress address = new IpAddress(addressFrom);
            if (addressTo != null) {
                offered = this.servMap.get((Comparable)Integer.valueOf(serv.getId()));
                if (offered != null) {
                    int size = offered.size();
                    for (int i = 0; i < size; ++i) {
                        Offered reserve = (Offered)offered.get(i);
                        usedAddress.add(new IpAddress(reserve.resource.getAddress()));
                    }
                }
                while (IpAddress.compare((byte[])address.address, (byte[])addressTo) <= 0) {
                    if (!usedAddress.contains(address)) {
                        result = address.address;
                        break;
                    }
                    IpAddress.increment((byte[])address.address);
                }
            } else if (!usedAddress.contains(address)) {
                result = address.address;
            }
        }
        if (result == null) {
            return null;
        }
        if (!this.useXid) {
            xid = 0;
        }
        IpResourceReserve resource = new IpResourceReserve(serv.getIpResourceId(), result, 32, 0L);
        offered = new Offered(resource, errorCode);
        long expire = System.currentTimeMillis() + timeout;
        this.map.put((Object)new OfferKey(deviceId, xid, mac, expire), offered);
        this.servMap.add((Map.Entry)new InetServOfferKey(inetServId, (Offered)offered, expire));
        return resource;
    }

    public void offer(int deviceId, Integer inetServId, int xid, byte[] mac, IpResourceReserve resource, int errorCode) {
        long expire = System.currentTimeMillis() + 25000L;
        if (!this.useXid) {
            xid = 0;
        }
        this.map.put((Object)new OfferKey(deviceId, xid, mac, expire), (Object)new Offered(resource, errorCode));
    }

    public Offered getOffered(int deviceId, Integer inetServId, int xid, byte[] mac) {
        if (!this.useXid) {
            xid = 0;
        }
        Offered result = (Offered)this.map.get((Object)new OfferKey(deviceId, xid, mac, 0L));
        return result;
    }

    static final class Offered {
        public final IpResourceReserve resource;
        public final int errorCode;

        public Offered(IpResourceReserve resource, int errorCode) {
            this.resource = resource;
            this.errorCode = errorCode;
        }
    }

    static final class OfferKey
    implements Delayed {
        private final int deviceId;
        private int xid;
        private final byte[] mac;
        private final long expire;

        public OfferKey(int deviceId, int xid, byte[] mac, long expire) {
            this.deviceId = deviceId;
            this.xid = xid;
            this.mac = mac;
            this.expire = expire;
        }

        public int hashCode() {
            return 31 * (31 * (31 + this.deviceId) + this.xid) + Arrays.hashCode(this.mac);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            OfferKey other = (OfferKey)obj;
            return this.deviceId == other.deviceId && this.xid == other.xid && Arrays.equals(this.mac, other.mac);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expire - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            OfferKey x = (OfferKey)other;
            long diff = this.expire - x.expire;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }

    static final class InetServOfferKey
    implements Map.Entry<Integer, Offered>,
    Delayed {
        private Integer key;
        private Offered value;
        private final long expire;

        @Override
        public Integer getKey() {
            return this.key;
        }

        public void setKey(Integer key) {
            this.key = key;
        }

        @Override
        public Offered getValue() {
            return this.value;
        }

        @Override
        public Offered setValue(Offered value) {
            this.value = value;
            return this.value;
        }

        public InetServOfferKey(Integer key, Offered value, long expire) {
            this.key = key;
            this.value = value;
            this.expire = expire;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expire - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            InetServOfferKey x = (InetServOfferKey)other;
            long diff = this.expire - x.expire;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

