/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Application;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContextThreadFactory;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.server.ContractStatusList;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusModifiedEvent;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.ContractTariffOptionChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAccountingPeriod;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServOption;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.event.InetServRestrictionModifiedEvent;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetServDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetAccountingPeriodDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServOptionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServRestrictionDao;
import ru.bitel.bgbilling.modules.inet.server.event.InetAccountingPeriodModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.modules.inet.server.event.InetServModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetAccountingPeriodList;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServOptionList;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.ip.InetServRuntimeAddressMap;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpRange;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.CopyOnWriteListMap;
import ru.bitel.common.util.CopyOnWriteRangeListMap;
import ru.bitel.common.util.Matcher;
import ru.bitel.common.util.Ranger;
import ru.bitel.common.util.StringCache;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductPeriodDao;

public final class InetServRuntimeMap
implements EventListener<Event>,
CommandListener {
    private static final Logger logger = LogManager.getLogger();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    public static final Ranger<InetServRuntime, Long> PERIOD_RANGER = new Ranger<InetServRuntime, Long>(){

        public Long getMinValue(InetServRuntime r) {
            long result = r.dateFromMillis;
            if (result != 0L) {
                return result;
            }
            return null;
        }

        public Long getMaxValue(InetServRuntime r) {
            long result = r.dateToMillis;
            if (result != 0L) {
                return result;
            }
            return null;
        }
    };
    private final InetApplication application;
    private final ContractRuntimeMap contractRuntimeMap;
    private final Set<Integer> contractIds;
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentMap<Integer, InetServRuntime> inetServMap = new ConcurrentHashMap<Integer, InetServRuntime>(512);
    private final CopyOnWriteListMap<Integer, InetServRuntime> contractMap = new CopyOnWriteListMap(128, 4);
    private final CopyOnWriteListMap<Integer, InetServRuntime> childrenServMap = new CopyOnWriteListMap(128, 4);
    private final CopyOnWriteRangeListMap<DevicePort, InetServRuntime, Long> deviceInterfaceMap = new CopyOnWriteRangeListMap(PERIOD_RANGER, 128, 4);
    private final CopyOnWriteRangeListMap<DeviceVlan, InetServRuntime, Long> deviceVlanMap = new CopyOnWriteRangeListMap(PERIOD_RANGER, 128, 4);
    private final CopyOnWriteRangeListMap<Integer, InetServRuntime, Long> vlanMap = new CopyOnWriteRangeListMap(PERIOD_RANGER, 128, 4);
    private final CopyOnWriteRangeListMap<String, InetServRuntime, Long> usernameMap = new CopyOnWriteRangeListMap(PERIOD_RANGER, 128, 4);
    private final CopyOnWriteRangeListMap<String, InetServRuntime, Long> usernameLowerCaseMap = new CopyOnWriteRangeListMap(PERIOD_RANGER, 128, 4);
    private final CopyOnWriteRangeListMap<IpAddress, InetServRuntime, Long> macMap = new CopyOnWriteRangeListMap(PERIOD_RANGER, 128, 4);
    private final InetServRuntimeAddressMap addressMap = new InetServRuntimeAddressMap();
    private final Date dateFrom;
    private boolean eventListenerSet = false;
    private static final StringCache CHILD_SERV_REALM_CACHE = new StringCache(64, new String[]{"", "default", "local", "inet"});

    public InetServRuntimeMap(InetApplication application, ContractRuntimeMap contractRuntimeMap, Connection con, Date dateFrom, Set<Integer> contractIds) throws BGException {
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing inet serv runtime map");
        }
        this.application = application;
        this.contractRuntimeMap = contractRuntimeMap;
        this.dateFrom = dateFrom;
        this.contractIds = contractIds;
        if (application.realtime) {
            Application.getInstance().getCommandPortListener().addListener((CommandListener)this);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initialization completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws BGException {
        this.lock.lock();
        try {
            long start = System.currentTimeMillis();
            if (!this.eventListenerSet && this.application.realtime) {
                this.eventListenerSet = true;
                EventProcessor ep = EventProcessor.getInstance();
                ep.addListener((EventListener)this, InetServModifiedEvent.class, this.application.moduleId, null);
                ep.addListener((EventListener)this, InetServDeviceStateAndOptionsModifiedEvent.class, this.application.moduleId, null);
                ep.addListener((EventListener)this, ContractStatusModifiedEvent.class);
                ep.addListener((EventListener)this, ContractTariffOptionChangedEvent.class);
                ep.addListener((EventListener)this, ContractTariffChangedEvent.class);
                ep.addListener((EventListener)this, InetAccountingPeriodModifiedEvent.class, this.application.moduleId, null);
                ep.addListener((EventListener)this, InetServRestrictionModifiedEvent.class, this.application.moduleId, null);
                ep.addListener((EventListener)this, InetReloadLocalEvent.class, this.application.moduleId, null);
            }
            int threadCount = 6;
            int batchCount = 3000;
            boolean contractRuntimeMapPrefetch = false;
            ModuleSetup moduleSetup = this.application.setup.getModuleSetup(Integer.valueOf(this.application.moduleId));
            if (moduleSetup != null) {
                threadCount = moduleSetup.getInt("inetServRuntimeMap.load.threadCount", threadCount);
                threadCount = Math.max(threadCount, 1);
                threadCount = Math.min(threadCount, 100);
                batchCount = moduleSetup.getInt("inetServRuntimeMap.load.batchCount", threadCount);
                batchCount = Math.max(batchCount, 1000);
                batchCount = Math.min(batchCount, 10000);
                contractRuntimeMapPrefetch = moduleSetup.getInt("contractRuntimeMap.prefetch", 0) > 0;
            }
            final int _batchCount = batchCount;
            logger.info("Loading inetServs from database (threadCount=" + threadCount + ", batchCount=" + batchCount + ", contract prefetch = " + contractRuntimeMapPrefetch + ")");
            final ExecutorService executorService = Executors.newFixedThreadPool(threadCount, (ThreadFactory)new ServerContextThreadFactory(Setup.getSetup(), this.application.moduleId, "inetServ-load", null));
            ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(executorService);
            if (contractRuntimeMapPrefetch && this.application.realtime) {
                Future<?> task = executorService.submit((Runnable)new WorkerTask<ServerContext>(this){

                    protected void runImpl() throws Exception {
                        ContractRuntimeMap.getInstance().prefetch(((ServerContext)this.context).getConnectionSet(), 0L);
                    }
                });
                try {
                    task.get(30L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (final Integer deviceId : this.application.childrenDeviceIds) {
                completionService.submit((Runnable)new WorkerTask<ServerContext>(){

                    protected void runImpl() throws Exception {
                        try {
                            List<InetServ> inetServList = InetServRuntimeMap.this.loadInetServListFromDB((ServerContext)this.context, deviceId, false);
                            if ((double)inetServList.size() > 1.4 * (double)_batchCount) {
                                int next;
                                for (int i = 0; i < inetServList.size(); i += next) {
                                    next = Math.min(inetServList.size() - i, _batchCount);
                                    InetServRuntimeMap.this.executeLoad(executorService, inetServList.subList(i, i + next));
                                }
                            } else {
                                InetServRuntimeMap.this.load((ServerContext)this.context, inetServList, false, false);
                            }
                        }
                        catch (BGException ex) {
                            logger.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                }, null);
            }
            this.waitLoad(executorService, completionService);
            logger.info("Load inetServs from database complete. Loaded " + this.inetServMap.size() + " inetServs for " + (System.currentTimeMillis() - start) + " ms");
        }
        finally {
            this.lock.unlock();
        }
    }

    private void executeLoad(ExecutorService executorService, final List<InetServ> inetServList) {
        executorService.execute((Runnable)new WorkerTask<ServerContext>(){

            protected void runImpl() throws Exception {
                try {
                    InetServRuntimeMap.this.load((ServerContext)this.context, inetServList, false, false);
                }
                catch (BGException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }

    private void waitLoad(ExecutorService executorService, CompletionService<Void> completionService) {
        try {
            int n = this.application.childrenDeviceIds.size();
            for (int t = 0; t < n; ++t) {
                Future<Void> f = completionService.take();
                f.get();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (ExecutionException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InetServ> loadInetServListFromDB(ServerContext context, int deviceId, boolean slave) throws BGException {
        ConnectionSet connectionSet = context.getConnectionSet();
        Connection con = slave ? connectionSet.getSlaveConnection() : connectionSet.getConnection();
        try (InetServDao inetServDao = new InetServDao(con, this.application.moduleId);){
            List<InetServ> list = inetServDao.listRuntime(deviceId, null, this.contractIds);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(ServerContext context, List<InetServ> inetServList, boolean slave, boolean skipIfExist) throws BGException {
        if (inetServList != null && inetServList.size() > 0) {
            ConnectionSet connectionSet = context.getConnectionSet();
            Connection con = slave ? connectionSet.getSlaveConnection() : connectionSet.getConnection();
            ContractLabelManager labelManager = new ContractLabelManager(con);
            Set suspendStatusSet = StatusCache.getInstance().getModuleSuspendStatusSet(this.application.moduleId);
            ContractTariffOptionDao tariffOptionManager = new ContractTariffOptionDao(con);
            ProductPeriodDao productPeriodDao = new ProductPeriodDao(con, 0);
            InetAccountingPeriodDao accountingPeriodDao = new InetAccountingPeriodDao(con, this.application.moduleId, 0);
            InetServTypeRuntimeMap servTypeRuntimeMap = this.application.servTypeRuntimeMap;
            TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(con);
            InetServOptionDao servOptionDao = new InetServOptionDao(con, this.application.moduleId);
            InetServRestrictionDao servRestrictionDao = new InetServRestrictionDao(con, this.application.moduleId);
            GregorianCalendar utilCalendar = new GregorianCalendar();
            try (ContractDao contractDao = new ContractDao(con, 0);){
                int count = 0;
                ContractStatusDao contractStatusDao = new ContractStatusDao(con);
                for (InetServ inetServ : inetServList) {
                    if (skipIfExist && this.inetServMap.containsKey(inetServ.getId())) continue;
                    InetServRuntime runtime = this.newRuntime(contractDao, labelManager, contractStatusDao, suspendStatusSet, tariffOptionManager, productPeriodDao, accountingPeriodDao, servTypeRuntimeMap, treeSetDao, servOptionDao, servRestrictionDao, inetServ, utilCalendar);
                    if (runtime != null) {
                        this.addRuntime(runtime);
                    }
                    if (++count % 1000 != 0) continue;
                    logger.info("InetServRuntimeMap size: " + this.inetServMap.size());
                }
            }
            finally {
                treeSetDao.close();
                productPeriodDao.close();
                servOptionDao.close();
                servRestrictionDao.close();
            }
        }
        logger.info("InetServRuntimeMap size: " + this.inetServMap.size());
    }

    private InetServRuntime newRuntime(ContractDao contractDao, ContractLabelManager labelManager, ContractStatusDao contractStatusDao, Set<Integer> suspendStatusSet, ContractTariffOptionDao tariffOptionManager, ProductPeriodDao productPeriodDao, InetAccountingPeriodDao accountingPeriodDao, InetServTypeRuntimeMap servTypeRuntimeMap, TariffModuleTreeSetDao treeSetDao, InetServOptionDao servOptionDao, InetServRestrictionDao servRestrictionDao, InetServ inetServ, Calendar utilCalendar) {
        try {
            InetServRuntime parentRuntime;
            AtomicReference servTypeRef = servTypeRuntimeMap.getRef(inetServ.getTypeId());
            if (servTypeRef == null || servTypeRef.get() == null) {
                logger.warn("InetServ:" + inetServ.getId() + " exist but InetServType:" + inetServ.getTypeId() + " not found.");
                return null;
            }
            if (inetServ.getParentId() > 0 && (parentRuntime = (InetServRuntime)this.inetServMap.get(inetServ.getParentId())) != null) {
                InetServ parentInetServ = parentRuntime.getInetServ();
                if (inetServ.getDeviceId() <= 0) {
                    inetServ.setDeviceId(parentInetServ.getDeviceId());
                    if (inetServ.getInterfaceId() < 0) {
                        inetServ.setInterfaceId(parentInetServ.getInterfaceId());
                    }
                } else if (inetServ.getDeviceId() == parentInetServ.getDeviceId() && inetServ.getInterfaceId() < 0) {
                    inetServ.setInterfaceId(parentInetServ.getInterfaceId());
                }
                if (inetServ.getVlan() < 0) {
                    inetServ.setVlan(parentInetServ.getVlan());
                }
                InetServRuntime runtime = new InetServRuntime(inetServ.getId(), servTypeRef, parentRuntime.contractRuntime);
                runtime.setInetServ(inetServ);
                runtime.setTariffTreeSet(parentRuntime.getTariffTreeSet());
                runtime.inetServOptionsList = parentRuntime.inetServOptionsList;
                runtime.setAccountingPeriodList(parentRuntime.getAccountingPeriodList());
                return runtime;
            }
            int contractId = inetServ.getContractId();
            ContractRuntime contractRuntime = this.contractRuntimeMap.getContractRuntime(contractDao, labelManager, contractStatusDao, tariffOptionManager, productPeriodDao, Integer.valueOf(contractId));
            if (contractRuntime == null) {
                logger.error("Contract not found with id=" + contractId + " but inetServ exist");
                return null;
            }
            InetServRuntime runtime = new InetServRuntime(inetServ.getId(), servTypeRef, contractRuntime);
            runtime.setInetServ(inetServ);
            runtime.setTariffTreeSet(treeSetDao.getRealtimeTariffTreeSet(inetServ.getContractId(), this.dateFrom, "inet", this.application.moduleId, this.application.moduleId, inetServ.getId()));
            List suspendPeriodList = contractStatusDao.getStatusList(contractId, suspendStatusSet, this.application.initialMonth, null);
            runtime.contractSuspendPeriods = new ContractStatusList(suspendPeriodList, utilCalendar);
            runtime.inetServOptionsList = InetServOptionList.newInstance(servOptionDao.getInetServRealtimeOptionList(inetServ.getId(), this.dateFrom), utilCalendar);
            if (((InetServTypeRuntime)servTypeRef.get()).inetServType.isNeedRestriction()) {
                runtime.setRestrictionList(servRestrictionDao.list(inetServ.getId()));
            }
            runtime.setAccountingPeriodList(InetAccountingPeriodList.newInstance(accountingPeriodDao.list(contractId, this.dateFrom), utilCalendar));
            return runtime;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private void addRuntime(InetServRuntime runtime) {
        String login;
        if (logger.isDebugEnabled()) {
            logger.debug("Adding InetServRuntime. servId = " + runtime.inetServId);
            logger.debug((Object)runtime);
        }
        InetServ inetServ = runtime.getInetServ();
        this.inetServMap.put(inetServ.getId(), runtime);
        this.contractMap.add((Object)inetServ.getContractId(), (Object)runtime);
        if (inetServ.getParentId() > 0) {
            inetServ.setLogin(CHILD_SERV_REALM_CACHE.intern(inetServ.getLogin()));
            this.childrenServMap.add((Object)inetServ.getParentId(), (Object)runtime);
        }
        InetServTypeRuntime typeRuntime = runtime.inetServTypeRef.get();
        if (inetServ.getParentId() <= 0) {
            List macAddressList;
            String login2;
            if (inetServ.getInterfaceId() >= 0) {
                this.deviceInterfaceMap.add((Object)new DevicePort(inetServ), (Object)runtime);
            }
            if (inetServ.getVlan() > 0) {
                this.deviceVlanMap.add((Object)new DeviceVlan(inetServ), (Object)runtime);
                this.vlanMap.add((Object)inetServ.getVlan(), (Object)runtime);
            }
            if (Utils.notEmptyString((String)(login2 = inetServ.getLogin()))) {
                this.usernameMap.add((Object)login2, (Object)runtime);
                String loginLowerCase = login2.toLowerCase();
                if (!login2.equals(loginLowerCase)) {
                    this.usernameLowerCaseMap.add((Object)loginLowerCase, (Object)runtime);
                }
            }
            if (typeRuntime.searchByMac && (macAddressList = inetServ.getMacAddressList()) != null) {
                int size = macAddressList.size();
                for (int i = 0; i < size; ++i) {
                    byte[] mac = (byte[])macAddressList.get(i);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Add MAC " + IpAddress.toString((byte[])mac) + " to runtime");
                    }
                    this.macMap.add((Object)new IpAddress(mac), (Object)runtime);
                }
            }
        } else if (typeRuntime.searchByLogin && Utils.notEmptyString((String)(login = inetServ.getLogin()))) {
            this.usernameMap.add((Object)login, (Object)runtime);
            String loginLowerCase = login.toLowerCase();
            if (!login.equals(loginLowerCase)) {
                this.usernameLowerCaseMap.add((Object)loginLowerCase, (Object)runtime);
            }
        }
        if (typeRuntime.searchByAddress) {
            this.addressMap.add(runtime);
        }
    }

    public void removeRuntime(int inetServId) {
        logger.info("Removing inet serv " + inetServId + " from runtime");
        InetServRuntime oldInetServInstance = (InetServRuntime)this.inetServMap.remove(inetServId);
        if (oldInetServInstance != null) {
            InetServ oldInetServ = oldInetServInstance.getInetServ();
            this.contractMap.remove((Object)oldInetServ.getContractId(), (Object)oldInetServInstance);
            if (oldInetServ.getParentId() > 0) {
                this.childrenServMap.remove((Object)oldInetServ.getParentId(), (Object)oldInetServInstance);
            }
            this.deleteRuntime(oldInetServInstance);
        }
    }

    private void deleteRuntime(InetServRuntime oldInetServInstance) {
        List macAddressList;
        String login;
        InetServ oldInetServ = oldInetServInstance.getInetServ();
        InetServTypeRuntime typeRuntime = oldInetServInstance.inetServTypeRef.get();
        if (typeRuntime.searchByAddress) {
            this.addressMap.remove(oldInetServInstance);
        }
        if (oldInetServ.getParentId() > 0) {
            String login2;
            if (typeRuntime.searchByLogin && Utils.notEmptyString((String)(login2 = oldInetServ.getLogin()))) {
                this.usernameMap.remove((Object)login2, (Object)oldInetServInstance);
                String loginLowerCase = login2.toLowerCase();
                if (!login2.equals(loginLowerCase)) {
                    this.usernameLowerCaseMap.remove((Object)loginLowerCase, (Object)oldInetServInstance);
                }
            }
            return;
        }
        if (oldInetServ.getInterfaceId() >= 0) {
            this.deviceInterfaceMap.remove((Object)new DevicePort(oldInetServ), (Object)oldInetServInstance);
        }
        if (oldInetServ.getVlan() > 0) {
            this.deviceVlanMap.remove((Object)new DeviceVlan(oldInetServ), (Object)oldInetServInstance);
            this.vlanMap.remove((Object)oldInetServ.getVlan(), (Object)oldInetServInstance);
        }
        if (Utils.notEmptyString((String)(login = oldInetServ.getLogin()))) {
            this.usernameMap.remove((Object)login, (Object)oldInetServInstance);
            String loginLowerCase = login.toLowerCase();
            if (!login.equals(loginLowerCase)) {
                this.usernameLowerCaseMap.remove((Object)loginLowerCase, (Object)oldInetServInstance);
            }
        }
        if (typeRuntime.searchByMac && (macAddressList = oldInetServ.getMacAddressList()) != null) {
            int size = macAddressList.size();
            for (int i = 0; i < size; ++i) {
                byte[] mac = (byte[])macAddressList.get(i);
                this.macMap.remove((Object)new IpAddress(mac), (Object)oldInetServInstance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Event e, EventListenerContext ctx) throws BGException {
        this.lock.lock();
        try {
            logger.info("Processing event: " + String.valueOf(e));
            if (e instanceof InetServModifiedEvent) {
                InetServModifiedEvent ev = (InetServModifiedEvent)e;
                if (ev.getNewInetServ() != null) {
                    this.onInetServModified(ctx.getConnectionSet(), (InetServModifiedEvent)e);
                } else {
                    int inetServId = ev.getOldInetServ().getId();
                    InetServRuntime oldInetServInstance = (InetServRuntime)this.inetServMap.get(inetServId);
                    this.removeRuntimeWithTimout(oldInetServInstance);
                }
            } else if (e instanceof InetServDeviceStateAndOptionsModifiedEvent) {
                this.onInetServDeviceStateModified(ctx.getConnectionSet(), (InetServDeviceStateAndOptionsModifiedEvent)e);
            } else if (e instanceof ContractStatusModifiedEvent) {
                this.onContractStatusModifiedEvent((ContractStatusModifiedEvent)e);
            } else if (e instanceof ContractTariffOptionChangedEvent) {
                this.onTariffOptionModified(e.getContractId());
            } else if (e instanceof ContractTariffChangedEvent) {
                this.onTariffListChanged((ServerContext)ctx, (ContractTariffChangedEvent)e);
            } else if (e instanceof InetAccountingPeriodModifiedEvent) {
                this.onAccoutingPeriodModified((InetAccountingPeriodModifiedEvent)e, ctx);
            } else if (e instanceof InetServRestrictionModifiedEvent) {
                this.onInetServRestrictionModified((InetServRestrictionModifiedEvent)e, ctx);
            } else if (e instanceof InetReloadLocalEvent) {
                this.loadInetServsForNewDevice((InetReloadLocalEvent)e, ctx);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void loadInetServsForNewDevice(InetReloadLocalEvent e, EventListenerContext ctx) {
        Set<Integer> oldChildrenDeviceIds = e.getOldChildrenDeviceIds();
        for (InetDeviceRuntime deviceRuntime : this.application.deviceMap.values()) {
            if (oldChildrenDeviceIds.contains(deviceRuntime.inetDeviceId)) continue;
            try {
                logger.info("Loading inetServs for new device: " + deviceRuntime.inetDeviceId);
                List<InetServ> inetServList = this.loadInetServListFromDB((ServerContext)ctx, deviceRuntime.inetDeviceId, false);
                logger.info("Device inetServ count: " + inetServList.size());
                this.load((ServerContext)ctx, inetServList, false, true);
            }
            catch (BGException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void removeRuntimeWithTimout(InetServRuntime oldInetServInstance) {
        if (oldInetServInstance == null) {
            return;
        }
        final WeakReference<InetServRuntime> ref = new WeakReference<InetServRuntime>(oldInetServInstance);
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                InetServRuntime oldInetServInstance = (InetServRuntime)ref.get();
                if (oldInetServInstance == null) {
                    return;
                }
                if (oldInetServInstance.getInetServ().getDeviceState() != InetServState.STATE_DELETED.getCode()) {
                    return;
                }
                InetServRuntimeMap.this.deleteRuntime(oldInetServInstance);
            }
        }, 10L, TimeUnit.MINUTES);
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                InetServRuntime oldInetServInstance = (InetServRuntime)ref.get();
                if (oldInetServInstance == null) {
                    return;
                }
                if (oldInetServInstance.getInetServ().getDeviceState() != InetServState.STATE_DELETED.getCode()) {
                    return;
                }
                int inetServId = oldInetServInstance.inetServId;
                if (!InetServRuntimeMap.this.inetServMap.remove(inetServId, oldInetServInstance)) {
                    return;
                }
                logger.info("Removing InetServRuntime: " + inetServId);
                InetServ oldInetServ = oldInetServInstance.getInetServ();
                InetServRuntimeMap.this.contractMap.remove((Object)oldInetServ.getContractId(), (Object)oldInetServInstance);
                if (oldInetServ.getParentId() > 0) {
                    InetServRuntimeMap.this.childrenServMap.remove((Object)oldInetServ.getParentId(), (Object)oldInetServInstance);
                }
                InetServRuntimeMap.this.deleteRuntime(oldInetServInstance);
            }
        }, 3L, TimeUnit.DAYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onContractStatusModifiedEvent(ContractStatusModifiedEvent e) {
        List inetServList = this.contractMap.get((Object)e.getContractId());
        if (inetServList == null) {
            return;
        }
        ContractStatus oldContractStatus = e.getOldContractStatus();
        ContractStatus newContractStatus = e.getNewContractStatus();
        Set suspendedStatuses = StatusCache.getInstance().getModuleSuspendStatusSet(this.application.moduleId);
        if (oldContractStatus != null && !suspendedStatuses.contains(oldContractStatus.getStatus())) {
            oldContractStatus = null;
        }
        if (newContractStatus != null && !suspendedStatuses.contains(newContractStatus.getStatus())) {
            newContractStatus = null;
        }
        if (oldContractStatus == null && newContractStatus == null) {
            return;
        }
        ContractStatusList newContractSuspendPeriods = null;
        int size = inetServList.size();
        for (int i = 0; i < size; ++i) {
            InetServRuntime runtime = (InetServRuntime)inetServList.get(i);
            runtime.lock();
            try {
                ContractStatusList contractSuspendPeriods = runtime.contractSuspendPeriods;
                if (contractSuspendPeriods == null) continue;
                if (newContractSuspendPeriods == null) {
                    long millisTo;
                    long millisFrom;
                    newContractSuspendPeriods = contractSuspendPeriods;
                    GregorianCalendar utilCalendar = new GregorianCalendar();
                    if (oldContractStatus != null) {
                        millisFrom = TimeUtils.convertDateToMillisFrom((Calendar)utilCalendar, (Date)oldContractStatus.getDateFrom());
                        millisTo = TimeUtils.convertDateToMillisTo((Calendar)utilCalendar, (Date)oldContractStatus.getDateTo());
                        newContractSuspendPeriods = newContractSuspendPeriods.remove(oldContractStatus.getId(), millisFrom, millisTo);
                    }
                    if (newContractStatus != null) {
                        millisFrom = TimeUtils.convertDateToMillisFrom((Calendar)utilCalendar, (Date)newContractStatus.getDateFrom());
                        millisTo = TimeUtils.convertDateToMillisTo((Calendar)utilCalendar, (Date)newContractStatus.getDateTo());
                        newContractSuspendPeriods = newContractSuspendPeriods.update(newContractStatus.getId(), millisFrom, millisTo);
                    }
                    logger.debug("New contract suspended status list:\n" + String.valueOf(newContractSuspendPeriods));
                }
                runtime.contractSuspendPeriods = newContractSuspendPeriods;
                continue;
            }
            finally {
                runtime.unlock();
            }
        }
    }

    private void onTariffListChanged(ServerContext context, ContractTariffChangedEvent e) {
        List inetServList = this.contractMap.get((Object)e.getContractId());
        if (inetServList != null) {
            Date now = new Date();
            try (TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(context.getConnection());){
                for (InetServRuntime serv : inetServList) {
                    serv.setTariffTreeSet(treeSetDao.getRealtimeTariffTreeSet(serv.getInetServ().getContractId(), now, "inet", this.application.moduleId, this.application.moduleId, serv.getInetServ().getId()));
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTariffOptionModified(int contractId) throws BGException {
        List inetServList = this.contractMap.get((Object)contractId);
        if (inetServList != null) {
            int size = inetServList.size();
            for (int i = 0; i < size; ++i) {
                InetServRuntime runtime = (InetServRuntime)inetServList.get(i);
                runtime.lock();
                try {
                    for (InetConnectionRuntime session : runtime.getConnectionList()) {
                        session.nextTariffOptionTime = InetUtils.roundToSeconds(runtime.contractRuntime.getTariffOptions(this.application.initialDate).nextActivateTime(session.sessionStartTime));
                    }
                    continue;
                }
                finally {
                    runtime.unlock();
                }
            }
        }
    }

    public List<InetServRuntime> list(int contractId) {
        return this.contractMap.get((Object)contractId);
    }

    private void onInetServRestrictionModified(InetServRestrictionModifiedEvent e, EventListenerContext ctx) throws BGException {
        InetServRuntime servRuntime = (InetServRuntime)this.inetServMap.get(e.getInetServId());
        if (servRuntime == null) {
            return;
        }
        if (!servRuntime.inetServTypeRef.get().inetServType.isNeedRestriction()) {
            servRuntime.setRestrictionList(Collections.emptyList());
            return;
        }
        try (InetServRestrictionDao servRestrictionDao = new InetServRestrictionDao(ctx.getConnection(), this.application.moduleId);){
            servRuntime.setRestrictionList(servRestrictionDao.list(servRuntime.inetServId));
        }
    }

    private void onAccoutingPeriodModified(InetAccountingPeriodModifiedEvent e, EventListenerContext ctx) throws BGException {
        List runtimeList = this.contractMap.get((Object)e.getContractId());
        if (runtimeList == null) {
            return;
        }
        for (InetServRuntime runtime : runtimeList) {
            InetAccountingPeriod oldAccountingPeriod = e.getOldItem();
            InetAccountingPeriod newAccountingPeriod = e.getNewItem();
            logger.debug("oldAccountingPeriod:" + String.valueOf(oldAccountingPeriod) + "\nnewAccountingPeriod:" + String.valueOf(newAccountingPeriod));
            runtime.lock();
            try {
                InetAccountingPeriodList accountingPeriodList = runtime.getAccountingPeriodList();
                if (accountingPeriodList == null) {
                    if (newAccountingPeriod != null) {
                        runtime.setAccountingPeriodList(InetAccountingPeriodList.newInstance(Collections.singletonList(newAccountingPeriod), new GregorianCalendar()));
                    }
                } else if (newAccountingPeriod != null) {
                    runtime.setAccountingPeriodList(accountingPeriodList.update(newAccountingPeriod, new GregorianCalendar()));
                } else {
                    runtime.setAccountingPeriodList(accountingPeriodList.remove(oldAccountingPeriod, new GregorianCalendar()));
                }
                runtime.accountingPeriodCheck(this.application, ctx.getConnectionSet(), System.currentTimeMillis(), false, false);
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
            finally {
                runtime.unlock();
            }
        }
    }

    private void onInetServDeviceStateModified(ConnectionSet connectionSet, InetServDeviceStateAndOptionsModifiedEvent e) throws BGException {
        assert (this.lock.isHeldByCurrentThread());
        InetServRuntime runtime = (InetServRuntime)this.inetServMap.get(e.getServId());
        if (runtime != null) {
            runtime.setDeviceStateAndOptions(e.getDeviceState(), e.getDeviceOptions());
        } else if (this.application.childrenDeviceIds.contains(e.getDeviceId()) || this.application.rootDeviceId == e.getDeviceId()) {
            InetServ newInetServ = new InetServ();
            newInetServ.setId(e.getServId());
            logger.info("Adding new InetServRuntime: " + newInetServ.getId());
            try {
                runtime = this.newRuntime(connectionSet, newInetServ, true);
                if (runtime != null) {
                    this.addRuntime(runtime);
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void onInetServModified(ConnectionSet connectionSet, InetServModifiedEvent e) {
        this.onInetServModified(connectionSet, e.getNewInetServ(), e.getNewInetServOptionList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetServRuntime addRuntime(ConnectionSet connectionSet, InetServ newInetServ, List<InetServOption> newInetServOptionList) {
        this.lock.lock();
        try {
            InetServRuntime inetServRuntime = this.onInetServModified(connectionSet, newInetServ, newInetServOptionList);
            return inetServRuntime;
        }
        finally {
            this.lock.unlock();
        }
    }

    private InetServRuntime onInetServModified(ConnectionSet connectionSet, InetServ newInetServ, List<InetServOption> newInetServOptionList) {
        if (!this.application.childrenDeviceIds.contains(newInetServ.getDeviceId())) {
            this.removeRuntime(newInetServ.getId());
            return null;
        }
        InetServRuntime runtime = (InetServRuntime)this.inetServMap.get(newInetServ.getId());
        if (runtime == null) {
            logger.info("Adding new InetServRuntime: " + newInetServ.getId());
            try {
                runtime = this.newRuntime(connectionSet, newInetServ, true);
                if (runtime != null) {
                    this.addRuntime(runtime);
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        } else {
            logger.info("Reload InetServRuntime: " + newInetServ.getId());
            this.removeRuntime(runtime.inetServId);
            runtime.setInetServ(newInetServ);
            if (newInetServOptionList != null) {
                runtime.inetServOptionsList = InetServOptionList.newInstance(newInetServOptionList, new GregorianCalendar());
            }
            this.addRuntime(runtime);
        }
        return runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetServRuntime newRuntime(ConnectionSet connectionSet, InetServ newInetServ, boolean reloadServ) throws BGException {
        Connection con = connectionSet.getConnection();
        ContractLabelManager labelManager = new ContractLabelManager(con);
        ContractStatusDao contractStatusDao = new ContractStatusDao(con);
        Set suspendStatusSet = StatusCache.getInstance().getModuleSuspendStatusSet(this.application.moduleId);
        ContractTariffOptionDao tariffOptionManager = new ContractTariffOptionDao(con);
        ProductPeriodDao productPeriodDao = new ProductPeriodDao(con, 0);
        InetAccountingPeriodDao accountingPeriodDao = new InetAccountingPeriodDao(con, this.application.moduleId, 0);
        InetServTypeRuntimeMap servTypeRuntimeMap = this.application.servTypeRuntimeMap;
        TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(con);
        InetServOptionDao servOptionDao = new InetServOptionDao(con, this.application.moduleId);
        InetServRestrictionDao servRestrictionDao = new InetServRestrictionDao(con, this.application.moduleId);
        GregorianCalendar utilCalendar = new GregorianCalendar();
        logger.info("Loading inetServ from database.");
        if (reloadServ) {
            try (InetServDao inetServDao = new InetServDao(con, this.application.moduleId);){
                InetServ inetServ = (InetServ)inetServDao.get(newInetServ.getId());
                if (inetServ != null) {
                    newInetServ = inetServ;
                }
            }
        }
        InetServRuntime result = null;
        try (ContractDao contractDao = new ContractDao(con, 0);){
            result = this.newRuntime(contractDao, labelManager, contractStatusDao, suspendStatusSet, tariffOptionManager, productPeriodDao, accountingPeriodDao, servTypeRuntimeMap, treeSetDao, servOptionDao, servRestrictionDao, newInetServ, utilCalendar);
        }
        finally {
            treeSetDao.close();
            productPeriodDao.close();
            servOptionDao.close();
            servRestrictionDao.close();
        }
        return result;
    }

    public InetServ getInetServ(Integer id) {
        InetServRuntime instance = (InetServRuntime)this.inetServMap.get(id);
        if (instance != null) {
            return instance.getInetServ();
        }
        return null;
    }

    public InetServRuntime get(Integer id) {
        return (InetServRuntime)this.inetServMap.get(id);
    }

    public List<InetServRuntime> listChildren(Integer id) {
        return this.childrenServMap.get((Object)id);
    }

    public List<InetServRuntime> listChildren(Integer id, long millis) {
        List children = this.childrenServMap.get((Object)id);
        if (children == null || children.size() == 0) {
            return children;
        }
        ArrayList<InetServRuntime> result = new ArrayList<InetServRuntime>(children.size());
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            InetServRuntime child = (InetServRuntime)children.get(i);
            if (child.dateFromMillis != 0L && child.dateFromMillis > millis || child.dateToMillis != 0L && child.dateToMillis < millis) continue;
            result.add(child);
        }
        return result;
    }

    public InetServRuntime getByDevicePort(int deviceId, int interfaceId, Date date) throws BGException {
        return this.getByDevicePort(deviceId, interfaceId, date, null);
    }

    public InetServRuntime getByDevicePort(int deviceId, int interfaceId, Date date, Matcher<InetServRuntime> matcher) throws BGException {
        DevicePort key = new DevicePort(deviceId, interfaceId);
        List list = this.deviceInterfaceMap.get((Object)key);
        if (list != null && !list.isEmpty()) {
            long millis = date.getTime();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                InetServRuntime servRuntime = (InetServRuntime)list.get(i);
                if (servRuntime.dateFromMillis != 0L && servRuntime.dateFromMillis > millis || servRuntime.dateToMillis != 0L && servRuntime.dateToMillis < millis || matcher != null && !matcher.matched((Object)servRuntime)) continue;
                return servRuntime;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getByDevicePort: deviceId={}; interfaceId={}; date={}, matcher={}null; list.size={}", (Object)deviceId, (Object)interfaceId, (Object)date, (Object)(matcher != null ? "not " : ""), (Object)list.size());
                logger.debug("inetServ[" + deviceId + ":" + interfaceId + "] exist, but with time period not or not matcher.");
            }
        }
        return null;
    }

    public List<InetServRuntime> listByDevicePort(int deviceId, int interfaceId, Date date) throws BGException {
        ArrayList<InetServRuntime> result = new ArrayList<InetServRuntime>(8);
        DevicePort key = new DevicePort(deviceId, interfaceId);
        List list = this.deviceInterfaceMap.get((Object)key);
        if (list != null) {
            long millis = date.getTime();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                InetServRuntime servRuntime = (InetServRuntime)list.get(i);
                if (servRuntime.dateFromMillis != 0L && servRuntime.dateFromMillis > millis || servRuntime.dateToMillis != 0L && servRuntime.dateToMillis < millis) continue;
                result.add(servRuntime);
            }
            if (logger.isDebugEnabled() && result.size() == 0) {
                logger.debug("inetServ[" + deviceId + ":" + interfaceId + "] exist but with time period not.");
            }
        }
        return result;
    }

    public InetServRuntime getByChildDevicePort(int deviceId, String childDeviceTitle, int interfaceId, Date date) throws BGException {
        if (childDeviceTitle == null) {
            return null;
        }
        InetDeviceRuntime device = this.application.deviceMap.get(deviceId);
        Set<Integer> descendantIds = device.descendantIds;
        for (Integer subDeviceId : descendantIds) {
            InetDeviceRuntime childDevice = this.application.deviceMap.get(subDeviceId);
            if (!childDevice.inetDevice.getTitle().equals(childDeviceTitle)) continue;
            return this.getByDevicePort(childDevice.inetDevice.getId(), interfaceId, date, null);
        }
        return null;
    }

    public InetServRuntime getByDeviceVlan(final int deviceId, Integer vlan, Date date, boolean deep) throws BGException {
        if (deep) {
            InetDeviceRuntime device = this.application.deviceMap.get(deviceId);
            final Set<Integer> descendantIds = device.descendantIds;
            return (InetServRuntime)this.vlanMap.get((Object)vlan, (Comparable)Long.valueOf(date.getTime()), (Matcher)new Matcher<InetServRuntime>(){

                public boolean matched(InetServRuntime x) {
                    int servDeviceId = x.getInetServ().getDeviceId();
                    return servDeviceId == deviceId || descendantIds.contains(servDeviceId);
                }
            });
        }
        return (InetServRuntime)this.deviceVlanMap.get((Object)new DeviceVlan(deviceId, vlan), (Comparable)Long.valueOf(date.getTime()));
    }

    public InetServRuntime getByUsername(String username, Date date, boolean ignoreCase) throws BGException {
        if (ignoreCase) {
            long millis = date.getTime();
            InetServRuntime result = (InetServRuntime)this.usernameMap.get((Object)username, (Comparable)Long.valueOf(millis));
            if (result != null) {
                return result;
            }
            String usernameLowerCase = username.toLowerCase();
            if (!username.equals(usernameLowerCase) && (result = (InetServRuntime)this.usernameMap.get((Object)usernameLowerCase, (Comparable)Long.valueOf(millis))) != null) {
                return result;
            }
            return (InetServRuntime)this.usernameLowerCaseMap.get((Object)usernameLowerCase, (Comparable)Long.valueOf(millis));
        }
        return (InetServRuntime)this.usernameMap.get((Object)username, (Comparable)Long.valueOf(date.getTime()));
    }

    public InetServRuntime getByMacAddress(byte[] mac, Date date, int deviceId, Set<Integer> deviceIds) throws BGException {
        return (InetServRuntime)this.macMap.get((Object)new IpAddress(mac), (Comparable)Long.valueOf(date.getTime()), x -> {
            int servDeviceId = x.getParentInetServ(this.application).getDeviceId();
            return servDeviceId == deviceId || deviceIds.contains(servDeviceId);
        });
    }

    public InetServRuntime getByMacAddressAndInterface(byte[] mac, Date date, final int deviceId, final int interfaceId) throws BGException {
        return (InetServRuntime)this.macMap.get((Object)new IpAddress(mac), (Comparable)Long.valueOf(date.getTime()), (Matcher)new Matcher<InetServRuntime>(){

            public boolean matched(InetServRuntime x) {
                InetServ serv = x.getParentInetServ(InetServRuntimeMap.this.application);
                return serv.getDeviceId() == deviceId && serv.getInterfaceId() == interfaceId;
            }
        });
    }

    public InetServRuntime getByMacAddressAndVlan(byte[] mac, Date date, final int deviceId, final Set<Integer> deviceIds, final Set<Integer> deviceIds2, final int vlan) throws BGException {
        return (InetServRuntime)this.macMap.get((Object)new IpAddress(mac), (Comparable)Long.valueOf(date.getTime()), (Matcher)new Matcher<InetServRuntime>(){

            public boolean matched(InetServRuntime x) {
                InetServ parentInetServ = x.getParentInetServ(InetServRuntimeMap.this.application);
                if (parentInetServ.getVlan() != vlan) {
                    return false;
                }
                int servDeviceId = parentInetServ.getDeviceId();
                return servDeviceId == deviceId || deviceIds.contains(servDeviceId) || deviceIds2.contains(servDeviceId);
            }
        });
    }

    public InetServRuntime getByMacAddress(InetServRuntime parentServRuntime, byte[] macAddress, long millis) {
        List<InetServRuntime> children = this.listChildren(parentServRuntime.inetServId, millis);
        if (children != null) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                InetServRuntime child = children.get(i);
                if (!Boolean.TRUE.equals(InetUtils.checkMacAddress(child.getInetServ(), macAddress))) continue;
                return child;
            }
        }
        return null;
    }

    @Deprecated
    public InetServRuntime getByAddress(InetServRuntime parentServRuntime, byte[] address, long millis) {
        return this.getByAddress(parentServRuntime, address, millis, false);
    }

    public InetServRuntime getByAddress(InetServRuntime parentServRuntime, byte[] address, long millis, boolean withRoot) {
        byte[] addressTo;
        InetServ serv;
        byte[] addressFrom;
        List<InetServRuntime> children = this.listChildren(parentServRuntime.inetServId, millis);
        if (withRoot && (addressFrom = (serv = parentServRuntime.getInetServ()).getAddressFrom()) != null && ((addressTo = serv.getAddressTo()) == null ? IpAddress.equals((byte[])addressFrom, (byte[])address) : IpRange.inRange((byte[])address, (byte[])address, (byte[])addressFrom, (byte[])addressTo))) {
            return parentServRuntime;
        }
        if (children != null) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                byte[] addressTo2;
                InetServRuntime child = children.get(i);
                InetServ serv2 = child.getInetServ();
                byte[] addressFrom2 = serv2.getAddressFrom();
                if (addressFrom2 == null || !((addressTo2 = serv2.getAddressTo()) == null ? IpAddress.equals((byte[])addressFrom2, (byte[])address) : IpRange.inRange((byte[])address, (byte[])address, (byte[])addressFrom2, (byte[])addressTo2))) continue;
                return child;
            }
        }
        return null;
    }

    public InetServRuntime getByAddress(byte[] address, Date time) {
        return this.addressMap.get(address, time.getTime());
    }

    public InetServRuntime getByAddress(byte[] address, Date time, final int deviceId, final Set<Integer> deviceIds) {
        return this.addressMap.get(address, time.getTime(), new Matcher<InetServRuntime>(){

            public boolean matched(InetServRuntime x) {
                int servDeviceId = x.getInetServ().getDeviceId();
                if (servDeviceId <= 0) {
                    servDeviceId = x.getParentInetServ(InetServRuntimeMap.this.application).getDeviceId();
                }
                return servDeviceId == deviceId || deviceIds.contains(servDeviceId);
            }
        });
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this);
    }

    public String executeCommand(String cmd, String param) {
        String result;
        block10: {
            result = null;
            try {
                if (!"servmap".equals(cmd)) break block10;
                StringBuilder sb = new StringBuilder(1000);
                try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)Setup.getSetup(), (boolean)true);){
                    for (Map.Entry m : this.contractMap.entrySet()) {
                        List inetServList = (List)m.getValue();
                        for (InetServRuntime serv : inetServList) {
                            sb.append(serv);
                            ConvergenceBalance balance = this.application.convergenceBalanceManager.getBalance(connectionSet, Integer.valueOf(serv.getInetServ().getContractId()), System.currentTimeMillis());
                            sb.append("\n\tBalance: ").append(balance).append("\n");
                        }
                    }
                }
                result = sb.toString();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                result = e.getMessage();
            }
        }
        return result;
    }

    public String getCommandsHelp() {
        return "servmap - show service cache\n";
    }

    public Iterable<InetServRuntime> values() {
        return this.inetServMap.values();
    }

    @MBeanAttribute
    public int getCount() {
        return this.inetServMap.size();
    }

    @MBeanAttribute
    public int getContractCount() {
        return this.contractMap.size();
    }

    @MBeanAttribute
    public int getParentCount() {
        return this.childrenServMap.size();
    }

    public List<InetServRuntime> getForContractId(int contractId) {
        return this.contractMap.get((Object)contractId);
    }

    static final class DevicePort {
        final int deviceId;
        final int interfaceId;

        public DevicePort(int deviceId, int interfaceId) {
            this.deviceId = deviceId;
            this.interfaceId = interfaceId;
        }

        public DevicePort(InetServ inetServ) {
            this(inetServ.getDeviceId(), inetServ.getInterfaceId());
        }

        public int hashCode() {
            return 31 * (31 + this.deviceId) + this.interfaceId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            DevicePort other = (DevicePort)obj;
            return this.deviceId == other.deviceId && this.interfaceId == other.interfaceId;
        }
    }

    static final class DeviceVlan {
        final int deviceId;
        final int vlan;

        public DeviceVlan(int deviceId, int vlan) {
            this.deviceId = deviceId;
            this.vlan = vlan;
        }

        public DeviceVlan(InetServ inetServ) {
            this(inetServ.getDeviceId(), inetServ.getVlan());
        }

        public int hashCode() {
            return 31 * (31 + this.deviceId) + this.vlan;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            DeviceVlan other = (DeviceVlan)obj;
            return this.deviceId == other.deviceId && this.vlan == other.vlan;
        }
    }
}

