/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class TrafficTypeTariffTreeNode
extends TariffTreeNode<InetTariffRequest, TariffContext, TreeContext, InetTariffWorkerContext> {
    protected final Integer[] trafficTypeIds;

    public TrafficTypeTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        Set<Integer> trafficTypeIds = Collections.newSetFromMap(new LinkedHashMap());
        trafficTypeIds.addAll(Utils.toIntegerList((String)parameterMap.get("trafficTypeId", null)));
        if (trafficTypeIds.size() == 0) {
            trafficTypeIds.add(0);
        }
        this.trafficTypeIds = new Integer[trafficTypeIds.size()];
        int i = 0;
        for (Integer trafficTypeId : trafficTypeIds) {
            this.trafficTypeIds[i++] = -trafficTypeId.intValue() - 1;
        }
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest req, TariffContext context, TreeContext treeContext, InetTariffWorkerContext workerContext) {
        throw new UnsupportedOperationException();
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest req, TariffTreeNodeHolder holder, TariffContext context, TreeContext treeContext, InetTariffWorkerContext workerContext) {
        int result = 0;
        Map pushed = req.acceptedSetPush();
        for (Integer trafficTypeId : this.trafficTypeIds) {
            List serviceCostList = (List)req.getServiceCost().get(trafficTypeId);
            if (serviceCostList == null || serviceCostList.size() == 0) continue;
            ArrayList newServiceCostList = new ArrayList(serviceCostList);
            result = 1;
            int jsize = newServiceCostList.size();
            for (int j = 0; j < jsize; ++j) {
                req.serviceCost = (ServiceCost)newServiceCostList.get(j);
                req.acceptedSetClear();
                this.executeChildren(parentTreeNodeId, req, holder, context, treeContext, (ThreadContext)workerContext);
            }
            req.serviceCost = null;
        }
        req.acceptedSetPop(pushed);
        return this.postExecute(treeNodeId, parentTreeNodeId, req, holder, context, treeContext, (ThreadContext)workerContext, result);
    }
}

