/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSession;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionLogDao;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.TrafficTypeLinkRuntime;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class InetSessionDao {
    private static final Logger logger = LogManager.getLogger();
    private final Connection con;
    private int moduleId;
    private final String tableName;
    private InetSessionLogDao sessionLogDao = null;
    private static final ExecutorService SERVICE = Executors.newFixedThreadPool(1);

    public InetSessionDao(Connection con, int moduleId) throws BGException {
        this.con = con;
        this.moduleId = moduleId;
        this.tableName = "inet_session_" + moduleId;
        this.sessionLogDao = new InetSessionLogDao(con, moduleId, new java.util.Date());
    }

    public void insert(InetSession b) throws BGException {
        try {
            final long id = this.getNextSessionId();
            if (id % 1000L == 0L) {
                SERVICE.execute(new Runnable(){

                    @Override
                    public void run() {
                        Connection con = Setup.getSetup().getDBConnectionFromPool();
                        try {
                            con.setAutoCommit(false);
                            logger.info("Clean old id from inet_session_" + InetSessionDao.this.moduleId + "_seq");
                            PreparedStatement ps = con.prepareStatement("DELETE FROM inet_session_" + InetSessionDao.this.moduleId + "_seq WHERE id<?");
                            ps.setLong(1, id - 1000L);
                            ps.executeUpdate();
                            ps.close();
                            logger.info("End clean old id from inet_session_" + InetSessionDao.this.moduleId + "_seq");
                            con.commit();
                        }
                        catch (SQLException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        finally {
                            ServerUtils.closeConnection((Connection)con);
                        }
                    }
                });
            }
            PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (id, parentId, splittedId, connectionId, sessionStart, sessionStop, lastActive, sessionTime, sessionCost, deviceState, status) VALUES (?,?,?,?,?,?,?,?,?,?,?)", 1);
            ps.setLong(1, id);
            ps.setLong(2, b.getParentId());
            ps.setLong(3, b.getSplittedId());
            ps.setLong(4, b.getConnectionId());
            ps.setTimestamp(5, TimeUtils.convertDateToTimestampSeconds((java.util.Date)b.getSessionStart()));
            ps.setTimestamp(6, TimeUtils.convertDateToTimestampSeconds((java.util.Date)b.getSessionStop()));
            ps.setTimestamp(7, TimeUtils.convertDateToTimestampSeconds((java.util.Date)b.getLastActive()));
            ps.setLong(8, b.getSessionTime());
            ps.setBigDecimal(9, b.getSessionCost());
            ps.setShort(10, b.getDeviceState());
            ps.setInt(11, b.getStatus());
            ps.executeUpdate();
            b.setId(id);
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public long getNextSessionId() throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO inet_session_" + this.moduleId + "_seq (id) VALUES (NULL)", 1);){
            ps.executeUpdate();
            long l = ServerUtils.lastInsertLongId((PreparedStatement)ps);
            return l;
        }
    }

    public boolean closeSession(long connectionId, long id, java.util.Date sessionStop) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET status=?, sessionStop=? WHERE connectionId=? AND id=? AND status!=?");
            ps.setInt(1, 3);
            ps.setTimestamp(2, TimeUtils.convertDateToTimestampSeconds((java.util.Date)sessionStop));
            ps.setLong(3, connectionId);
            ps.setLong(4, id);
            ps.setInt(5, 3);
            int result = ps.executeUpdate();
            ps.close();
            return result == 1;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private InetSession getFromRS(ResultSet rs) throws SQLException {
        InetSession result = new InetSession();
        result.setId(rs.getLong("id"));
        result.setParentId(rs.getLong("parentId"));
        result.setSplittedId(rs.getLong("splittedId"));
        result.setConnectionId(rs.getLong("connectionId"));
        result.setSessionStart(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("sessionStart")));
        result.setSessionStop(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("sessionStop")));
        result.setSessionTime(rs.getLong("sessionTime"));
        result.setSessionCost(rs.getBigDecimal("sessionCost"));
        result.setDeviceState(rs.getShort("deviceState"));
        result.setStatus((int)rs.getShort("status"));
        result.setLastActive(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("lastActive")));
        return result;
    }

    public static InetSession getSessionFromRS(ResultSet rs) throws SQLException {
        InetSession result = new InetSession();
        result.setId(rs.getLong("session.id"));
        result.setParentId(rs.getLong("session.parentId"));
        result.setSplittedId(rs.getLong("session.splittedId"));
        result.setConnectionId(rs.getLong("session.connectionId"));
        result.setSessionStart(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("session.sessionStart")));
        result.setSessionStop(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("session.sessionStop")));
        result.setSessionTime(rs.getLong("session.sessionTime"));
        result.setSessionCost(rs.getBigDecimal("session.sessionCost"));
        result.setDeviceState(rs.getShort("session.deviceState"));
        result.setStatus((int)rs.getShort("session.status"));
        result.setLastActive(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("session.lastActive")));
        return result;
    }

    public List<InetSession> list(long connectionId, int status) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE connectionId=? AND status=?");
            ps.setLong(1, connectionId);
            ps.setInt(2, status);
            ArrayList<InetSession> result = new ArrayList<InetSession>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<Object> listAuto(int deviceId, Set<Integer> servTypeIds, java.util.Date date) throws BGException {
        ArrayList<Object> result = new ArrayList<Object>(50);
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT serv.id as serv_id, connection.*, session.*, serv.contractId FROM inet_serv_" + this.moduleId + " as serv LEFT JOIN inet_serv_type_" + this.moduleId + " as serv_type ON serv_type.id=serv.typeId LEFT JOIN contract ON serv.contractId=contract.id LEFT JOIN inet_connection_" + this.moduleId + " as connection ON connection.servId=serv.id LEFT JOIN " + this.tableName + " as session ON session.connectionId=connection.id AND session.status<4 WHERE serv.deviceId=? AND serv.typeId IN (" + Utils.toString(servTypeIds) + ") AND (? IS NULL OR serv.dateTo IS NULL OR serv.dateTo>=?) ORDER BY session.sessionStart");
            Date sqlDate = TimeUtils.convertDateToSqlDate((java.util.Date)date);
            ps.setInt(1, deviceId);
            ps.setDate(2, sqlDate);
            ps.setDate(3, sqlDate);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                rs.getInt("session.id");
                if (rs.wasNull()) {
                    result.add(rs.getInt("serv_id"));
                    continue;
                }
                InetSession session = InetSessionDao.getSessionFromRS(rs);
                InetConnection connection = InetConnectionDao.getConnectionFromRS(rs);
                result.add(new Object[]{connection, session});
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<Object[]> listCall(int deviceId, Set<Integer> servTypeIds) throws BGException {
        ArrayList<Object[]> result = new ArrayList<Object[]>(50);
        try {
            if (ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
                PreparedStatement ps = this.con.prepareStatement("SELECT connection.*, session.*, serv.contractId FROM inet_connection_" + this.moduleId + " as connection  LEFT JOIN " + this.tableName + " as session ON session.connectionId=connection.id AND session.status<4 AND connection.status>0 LEFT JOIN inet_serv_" + this.moduleId + " as serv ON serv.id=connection.servId WHERE connection.deviceId=? AND serv.typeId IN (" + Utils.toString(servTypeIds) + ") AND connection.status>0 ORDER BY connection.parentId, session.sessionStart");
                ps.setInt(1, deviceId);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    InetSession session = InetSessionDao.getSessionFromRS(rs);
                    InetConnection connection = InetConnectionDao.getConnectionFromRS(rs);
                    result.add(new Object[]{connection, session});
                }
                ps.close();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public static Object[] getCall(Connection con, int moduleId, InetConnection connection, java.util.Date connectionStart, long parentConnectionId, boolean start, boolean acctSessIdAlwaysPresent, boolean ipAlwaysPresent, boolean nasPortCorrect) throws BGException {
        try {
            return InetSessionDao.getCall0(con, moduleId, connection, connectionStart, parentConnectionId, start, acctSessIdAlwaysPresent, ipAlwaysPresent, nasPortCorrect);
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private static Object[] getCall0(Connection con, int moduleId, InetConnection connection, java.util.Date connectionStart, long parentConnectionId, boolean start, boolean acctSessIdAlwaysPresent, boolean ipAlwaysPresent, boolean nasPortCorrect) throws SQLException {
        Object[] result = null;
        StringBuilder sb = new StringBuilder(300).append("SELECT connection.*, session.*, serv.contractId").append(" FROM inet_connection_").append(moduleId).append(" as connection ").append(" LEFT JOIN ").append("inet_session_").append(moduleId).append(" as session ON session.connectionId=connection.id AND session.status<").append(3).append(" LEFT JOIN inet_serv_").append(moduleId).append(" as serv ON serv.id=connection.servId").append(" WHERE connection.deviceId=?").append(" AND (? OR connection.servId=?)").append(" AND (? OR connection.connectionStart>=?)");
        if (ipAlwaysPresent) {
            sb.append(" AND (? OR connection.ipAddress=?)");
        } else {
            sb.append(" AND (? OR connection.ipAddress=? OR connection.ipAddress IS NULL)");
        }
        sb.append(" AND (? OR connection.devicePort=? OR (? AND connection.acctSessionId=?))").append(" AND (? OR connection.acctSessionId=? OR (connection.status=0 AND connection.acctSessionId IS NULL))").append(" AND connection.parentId=?");
        if (!acctSessIdAlwaysPresent) {
            sb.append(" ORDER BY connection.status ASC, connection.connectionStart DESC, session.sessionStart DESC");
        }
        sb.append(" LIMIT 1");
        PreparedStatement ps = con.prepareStatement(sb.toString());
        int inetServId = connection.getServId();
        String acctSessionId = connection.getAcctSessionId();
        int devicePort = connection.getDevicePort();
        byte[] ipAddress = connection.getInetAddressBytes();
        ps.setInt(1, connection.getDeviceId());
        ps.setBoolean(2, inetServId <= 0);
        ps.setInt(3, inetServId);
        if (connectionStart != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(connectionStart);
            if (start) {
                ((Calendar)calendar).add(12, -4);
            } else {
                ((Calendar)calendar).add(12, -34);
            }
            ps.setBoolean(4, false);
            ps.setTimestamp(5, TimeUtils.convertCalendarToTimestamp((Calendar)calendar));
        } else {
            ps.setBoolean(4, true);
            ps.setTimestamp(5, null);
        }
        ps.setBoolean(6, ipAddress == null || !ipAlwaysPresent && nasPortCorrect && devicePort != 0);
        ps.setBytes(7, ipAddress);
        ps.setBoolean(8, devicePort == 0);
        ps.setInt(9, devicePort);
        ps.setBoolean(10, !nasPortCorrect);
        ps.setString(11, acctSessionId);
        ps.setBoolean(12, Utils.isEmptyString((String)acctSessionId));
        ps.setString(13, acctSessionId);
        ps.setLong(14, parentConnectionId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            InetConnection connectionFromDb = InetConnectionDao.getConnectionFromRS(rs);
            InetSession sessionFromDb = rs.getInt("session.id") > 0 ? InetSessionDao.getSessionFromRS(rs) : null;
            result = new Object[]{connectionFromDb, sessionFromDb};
        }
        ps.close();
        return result;
    }

    public List<InetSessionLog> listAsLog(List<InetServType> servTypeDirectory, Set<Integer> deviceIds, Set<Integer> servTypeIds, Set<Integer> contractIds, Set<Integer> servIds, java.util.Date timeFrom, java.util.Date timeTo, Page page, int idDivizor, int idRemainder, boolean onlyTopSessions) throws BGException {
        return this.listAsLog(servTypeDirectory, deviceIds, servTypeIds, contractIds, null, servIds, null, null, null, timeFrom, timeTo, page, idDivizor, idRemainder, onlyTopSessions);
    }

    public List<InetSessionLog> listAsLog(List<InetServType> servTypeDirectory, Set<Integer> deviceIds, Set<Integer> servTypeIds, Set<Integer> contractIds, String contract, Set<Integer> servIds, String login, String ip, String callingStation, java.util.Date timeFrom, java.util.Date timeTo, Page page, int idDivizor, int idRemainder, boolean onlyTopSessions) throws BGException {
        return this.listAsLog(servTypeDirectory, deviceIds, servTypeIds, contractIds, contract, servIds, login, 0L, ip, callingStation, timeFrom, timeTo, page, idDivizor, idRemainder, onlyTopSessions);
    }

    public InetSessionLog getAsLog(List<InetServType> servTypeDirectory, long sessionId) throws BGException {
        List<InetSessionLog> result = this.listAsLog(servTypeDirectory, null, null, null, null, null, null, sessionId, null, null, null, null, null, 0, 0, true);
        if (result != null && result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    protected List<InetSessionLog> listAsLog(List<InetServType> servTypeDirectory, Set<Integer> deviceIds, Set<Integer> servTypeIds, Set<Integer> cids, String contract, Set<Integer> servIds, String login, long sessionId, String ip, String callingStation, java.util.Date timeFrom, java.util.Date timeTo, Page page, int idDivizor, int idRemainder, boolean onlyTopSessions) throws BGException {
        ArrayList<InetSessionLog> result = new ArrayList<InetSessionLog>(50);
        HashSet<Integer> autoServTypeIds = new HashSet<Integer>();
        for (InetServType servType : servTypeDirectory) {
            if (servType.getSessionInitiationType() != 1) continue;
            autoServTypeIds.add(servType.getId());
        }
        try {
            StringBuilder sb = new StringBuilder(100).append("SELECT SQL_CALC_FOUND_ROWS connection.*, session.*, serv.contractId, contract.title as contractTitle, contract.comment as contractComment, contract.id as contractId, serv.title as serviceTitle, serv.typeId as servTypeId, serv.deviceState as servDeviceState, parentServ.deviceState as parentServDeviceState");
            if (!onlyTopSessions) {
                sb.append(", parentConnection.username as parentUsername");
            }
            sb.append(" FROM " + this.tableName + " as session  LEFT JOIN inet_connection_" + this.moduleId + " as connection ON connection.id=session.connectionId");
            if (!onlyTopSessions) {
                sb.append(" LEFT JOIN inet_connection_" + this.moduleId + " as parentConnection ON connection.parentId>0 AND parentConnection.id=connection.parentId");
            }
            sb.append(" LEFT JOIN inet_serv_" + this.moduleId + " as serv ON serv.id=connection.servId");
            sb.append(" LEFT JOIN inet_serv_" + this.moduleId + " as parentServ ON serv.parentId>0 AND serv.parentId=parentServ.id");
            sb.append(" LEFT JOIN contract ON serv.contractId=contract.id WHERE 1=1");
            if (sessionId > 0L) {
                sb.append(" AND session.id=?");
            }
            if (cids != null && cids.size() > 0) {
                sb.append(" AND contract.id IN ( " + Utils.toString(cids) + ")");
            }
            if (servIds != null && servIds.size() > 0) {
                sb.append(" AND connection.servId IN (" + Utils.toString(servIds) + ")");
            }
            if (deviceIds != null && deviceIds.size() > 0) {
                sb.append(" AND (connection.deviceId IN (" + Utils.toString(deviceIds) + ")");
                sb.append(" OR connection.agentDeviceId IN (" + Utils.toString(deviceIds) + ")");
                sb.append(" OR (serv.parentId<=0 AND serv.deviceId IN (" + Utils.toString(deviceIds) + "))");
                sb.append(" OR (serv.parentId>0 AND parentServ.deviceId IN (" + Utils.toString(deviceIds) + ")))");
            }
            if (servTypeIds != null && servTypeIds.size() > 0) {
                sb.append(" AND serv.typeId IN (" + Utils.toString(servTypeIds) + ")");
            }
            if (timeFrom != null) {
                sb.append(" AND session.sessionStart>=?");
            }
            if (timeTo != null) {
                sb.append(" AND session.sessionStart<?");
            }
            if (onlyTopSessions) {
                sb.append(" AND connection.parentId=0");
            }
            if (Utils.notBlankString((String)login)) {
                sb.append(" AND serv.login LIKE ?");
            }
            if (Utils.notBlankString((String)callingStation)) {
                sb.append(" AND (connection.calledStationId LIKE ? OR connection.callingStationId LIKE ?)");
            }
            if (Utils.notBlankString((String)contract)) {
                sb.append(" AND contract.title LIKE ?");
            }
            if (idDivizor > 0) {
                sb.append(" AND contract.id % " + idDivizor + " =  " + idRemainder);
            }
            byte[] ipBytes = null;
            if (Utils.notBlankString((String)ip)) {
                try {
                    ipBytes = InetAddress.getByName(ip).getAddress();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ipBytes != null) {
                sb.append(" AND (connection.ipAddress=? OR (serv.addressFrom IS NOT NULL AND ((serv.addressTo IS NOT NULL AND serv.addressFrom<=? AND serv.addressTo>=?) OR (serv.addressTo IS NULL AND serv.addressFrom=?))))");
            }
            sb.append(Page.toSqlLimit((Page)page));
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            int idx = 0;
            if (sessionId > 0L) {
                ps.setLong(++idx, sessionId);
            }
            if (timeFrom != null) {
                ps.setTimestamp(++idx, TimeUtils.convertDateToTimestampSeconds((java.util.Date)timeFrom));
            }
            if (timeTo != null) {
                ps.setTimestamp(++idx, TimeUtils.convertDateToTimestampSeconds((java.util.Date)timeTo));
            }
            if (Utils.notBlankString((String)login)) {
                ps.setString(++idx, "%" + login + "%");
            }
            if (Utils.notBlankString((String)callingStation)) {
                ps.setString(++idx, "%" + callingStation + "%");
                ps.setString(++idx, "%" + callingStation + "%");
            }
            if (Utils.notBlankString((String)contract)) {
                ps.setString(++idx, "%" + contract + "%");
            }
            if (ipBytes != null) {
                ps.setBlob(++idx, new ByteArrayInputStream(ipBytes));
                ps.setBlob(++idx, new ByteArrayInputStream(ipBytes));
                ps.setBlob(++idx, new ByteArrayInputStream(ipBytes));
                ps.setBlob(++idx, new ByteArrayInputStream(ipBytes));
            }
            PreparedStatement childrenPS = this.con.prepareStatement("SELECT connection.*, session.*, serv.contractId, contract.title as contractTitle,  contract.comment as contractComment, contract.id as contractId, serv.title as serviceTitle FROM inet_connection_" + this.moduleId + " as connection LEFT JOIN " + this.tableName + " as session ON connection.id=session.connectionId  LEFT JOIN inet_serv_" + this.moduleId + " as serv ON serv.id=connection.servId LEFT JOIN contract ON serv.contractId=contract.id WHERE connection.deviceId=? AND connection.parentId=? AND session.parentId=?");
            ResultSet rs = ps.executeQuery();
            Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
            while (rs.next()) {
                InetSession session = InetSessionDao.getSessionFromRS(rs);
                InetConnection connection = InetConnectionDao.getConnectionFromRS(rs);
                InetSessionLog sessionLog = new InetSessionLog(connection, session);
                sessionLog.setContractTitle(rs.getString("contractTitle"));
                sessionLog.setContractComment(rs.getString("contractComment"));
                sessionLog.setContractId(rs.getInt("contractId"));
                sessionLog.setServiceTitle(rs.getString("serviceTitle"));
                int servTypeId = rs.getInt("servTypeId");
                if (autoServTypeIds.contains(servTypeId)) {
                    short deviceState = rs.getShort("parentServDeviceState");
                    if (rs.wasNull()) {
                        deviceState = rs.getShort("servDeviceState");
                    }
                    sessionLog.setDeviceState(deviceState);
                }
                if (onlyTopSessions) {
                    sessionLog.setRealm(InetUtils.getRealm(connection.getUsername()));
                    List<InetSessionLog> children = this.sessionLogDao.listChildren(session.getId(), session.getSessionStart());
                    childrenPS.setInt(1, connection.getDeviceId());
                    childrenPS.setLong(2, connection.getId());
                    childrenPS.setLong(3, session.getId());
                    ResultSet childrentRS = childrenPS.executeQuery();
                    while (childrentRS.next()) {
                        InetSession childSession = InetSessionDao.getSessionFromRS(childrentRS);
                        InetConnection childConnection = InetConnectionDao.getConnectionFromRS(childrentRS);
                        InetSessionLog childSessionLog = new InetSessionLog(childConnection, childSession);
                        childSessionLog.setContractTitle(childrentRS.getString("contractTitle"));
                        childSessionLog.setContractComment(childrentRS.getString("contractComment"));
                        childSessionLog.setContractId(childrentRS.getInt("contractId"));
                        childSessionLog.setServiceTitle(childrentRS.getString("serviceTitle"));
                        childSessionLog.setRealm(sessionLog.getRealm());
                        if (children == null) {
                            children = new ArrayList<InetSessionLog>();
                        }
                        children.add(childSessionLog);
                    }
                    childrentRS.close();
                    sessionLog.setChildren(children);
                } else {
                    sessionLog.setRealm(InetUtils.getRealm(rs.getString("parentUsername")));
                }
                result.add(sessionLog);
            }
            ps.close();
            childrenPS.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public static Map<Integer, AccountingTrafficAmount> getCountersFromDB(Connection con, int moduleId, InetServTypeRuntime servType, long sessionId) throws BGException {
        try {
            HashMap<Integer, AccountingTrafficAmount> counterMap = new HashMap<Integer, AccountingTrafficAmount>();
            TrafficTypeLinkRuntime trafficTypeLink = servType.trafficTypeLinkRuntimeRef.get();
            StringBuilder sb = new StringBuilder(180);
            sb.append("SELECT trafficTypeId, SUM(amount) FROM inet_session_detail_").append(moduleId).append(" as detail").append(" WHERE sessionId=? AND trafficTypeId IN (");
            if (trafficTypeLink.counterTrafficTypes.size() == 0) {
                sb.append(TrafficType.TIME_ID);
            } else {
                sb.append(Utils.toString(trafficTypeLink.counterTrafficTypes));
                if (!trafficTypeLink.counterTrafficTypes.contains(TrafficType.TIME_ID)) {
                    sb.append(',').append(TrafficType.TIME_ID);
                }
            }
            sb.append(") GROUP BY trafficTypeId");
            PreparedStatement monthCounterDetailPS = con.prepareStatement(sb.toString());
            monthCounterDetailPS.setLong(1, sessionId);
            ResultSet rs = monthCounterDetailPS.executeQuery();
            while (rs.next()) {
                int trafficTypeId = rs.getInt(1);
                long amount = rs.getLong(2);
                counterMap.put(trafficTypeId, new AccountingTrafficAmount(amount));
            }
            rs.close();
            monthCounterDetailPS.close();
            return counterMap;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public boolean delete(long sessionId) throws BGException {
        boolean bl;
        block8: {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=?");
            try {
                ps.setLong(1, sessionId);
                boolean bl2 = bl = ps.executeUpdate() > 0;
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new BGException((Throwable)ex);
                }
            }
            ps.close();
        }
        return bl;
    }
}

