/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate.day;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.TrafficRangeTarrificationManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRange;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffWorkerContext;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class TrafficRangeTarrificationDayManager
extends TrafficRangeTarrificationManager {
    protected final int day;
    protected String detailTableName;

    public TrafficRangeTarrificationDayManager(int moduleId, Date month, int day) throws BGException {
        super(moduleId, month);
        this.day = day;
        this.detailTableName = ServerUtils.getModuleMonthTableName((String)"inet_tariff_traffic_range_detail", (Date)this.month, (int)moduleId);
    }

    @Override
    public TrafficRange getRangedTraffic(TariffWorkerContext workerContext, int contractId, long treeNodeId, long key) throws BGException {
        TrafficRange range = super.getRangedTraffic(workerContext, contractId, treeNodeId, key);
        try {
            String query = "SELECT SUM(amount)  FROM " + this.detailTableName + " WHERE contractId=? AND treeNodeId=? AND rangeKey=?  AND  day < ?";
            ResultSet rs = workerContext.getPSCache().execute(query, new Object[]{contractId, treeNodeId, key, this.day});
            if (rs.next()) {
                range.amount += rs.getLong(1);
            }
            return range;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

