/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.action.web;

import jakarta.annotation.Resource;
import java.awt.BasicStroke;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLink;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLinkRule;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.common.service.InetSessionService;
import ru.bitel.bgbilling.modules.inet.server.action.web.AbstractChartReport;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.reports.Charts;

public class ActionTrafficReport
extends AbstractChartReport {
    @Resource
    ModuleService moduleService;
    @Resource
    InetSessionService sessionService;
    @Resource
    InetServService servService;

    public void execute() throws Exception {
        int servId = this.req.getInt("inetServId", -1);
        int unit = this.req.getInt("unit", 0x100000);
        Period period = this.getPeriodByYearMonthDay();
        Set trafficTypeIds = Collections.emptySet();
        String[] trafficTypeIdsString = this.context.getRequest().getParameterValues("trafficTypeIds");
        if (trafficTypeIdsString != null) {
            trafficTypeIds = Utils.toIntegerSet((String)Utils.toString(Arrays.asList(trafficTypeIdsString)));
            trafficTypeIds.remove(0);
        }
        List inetServList = this.servService.inetServList(this.contractId, "dateTo, dateFrom");
        inetServList.stream().forEach(serv -> serv.setTitle(serv.getTitle() + " (" + TimeUtils.formatPeriod((Date)serv.getDateFrom(), (Date)serv.getDateTo()) + ")"));
        this.setResultParam("servs", inetServList);
        this.setResultParam("inetServId", servId);
        this.setResultParam("unit", unit);
        if (servId <= 0) {
            if (inetServList.size() > 0) {
                List<TrafficType> list = this.addTrafficTypes(((InetServ)inetServList.get(0)).getId(), trafficTypeIds);
            }
            return;
        }
        List<TrafficType> trafficTypes = this.addTrafficTypes(servId, trafficTypeIds);
        boolean byDay = !TimeUtils.dateEqual((Date)period.getDateFrom(), (Date)period.getDateTo());
        List result = this.sessionService.inetSessionTraffic(this.contractId, Collections.singleton(servId), 0, trafficTypeIds, period, (long)unit, byDay, true);
        this.chartTraffic(trafficTypes, result, unit, byDay ? TimeUnit.DAYS : TimeUnit.HOURS);
        this.chartTrafficPie(TrafficType.newMap(trafficTypes), result, unit, byDay ? TimeUnit.DAYS : TimeUnit.HOURS);
        if (byDay) {
            Calendar calendar = period.getDateFromCalendar();
            int last = calendar.getActualMaximum(5);
            ArrayList<Integer> days = new ArrayList<Integer>();
            for (int i = 1; i <= last; ++i) {
                days.add(i);
            }
            this.setResultParam("days", days);
        }
        this.setResult(result);
    }

    private List<TrafficType> addTrafficTypes(int servId, Set<Integer> trafficTypeIds) throws Exception {
        InetServ inetServ = this.servService.inetServGet(servId);
        InetServType servType = this.servService.inetServTypeGet(inetServ.getTypeId());
        TrafficTypeLink trafficTypeLink = this.servService.trafficTypeLinkGet(servType.getTrafficTypeLinkId());
        HashSet<Integer> servTypeTrafficTypeIds = new HashSet<Integer>();
        if (trafficTypeLink != null) {
            for (TrafficTypeLinkRule rule : trafficTypeLink.getTrafficTypeLinkRuleList()) {
                servTypeTrafficTypeIds.add(rule.trafficTypeId);
            }
        }
        List trafficTypes = this.servService.trafficTypeList();
        Iterator iter = trafficTypes.iterator();
        while (iter.hasNext()) {
            TrafficType trafficType = (TrafficType)iter.next();
            int trafficTypeId = trafficType.getId();
            if (trafficTypeId != 0 && servTypeTrafficTypeIds.contains(trafficTypeId) && trafficType.getUnit() != 20000) continue;
            iter.remove();
        }
        this.setResultParam("trafficTypes", trafficTypes);
        this.setResultParam("trafficTypeIds", new ArrayList<Integer>(trafficTypeIds));
        return trafficTypes;
    }

    private String chartTraffic(List<TrafficType> trafficTypes, List<TrafficAmount> trafficList, long unit, TimeUnit timeUnit) throws BGException {
        String result = null;
        String unitTitle = this.getUnitTitle(unit);
        Object suffix = "";
        if (Utils.notBlankString((String)unitTitle)) {
            switch (timeUnit) {
                case DAYS: {
                    suffix = " (" + unitTitle + "/\u0434\u0435\u043d\u044c)";
                    break;
                }
                default: {
                    suffix = " (" + unitTitle + "/\u0447\u0430\u0441)";
                }
            }
        }
        HashSet<Integer> timeTrafficTypeIds = new HashSet<Integer>();
        for (TrafficType trafficType : trafficTypes) {
            if (trafficType.getUnit() != 20000) continue;
            timeTrafficTypeIds.add(trafficType.getId());
        }
        Map trafficTypeMap = TrafficType.newMap(trafficTypes);
        HashMap timeSeriesMap = new HashMap();
        switch (timeUnit) {
            case DAYS: {
                TrafficType trafficType;
                TimeSeries timeSeries;
                Long amount;
                Object trafficTypeId;
                RegularTimePeriod prev;
                RegularTimePeriod next;
                Day timePeriod;
                Map periodValue;
                long millis;
                Day currentTimePeriod = null;
                for (TrafficAmount traffic : trafficList) {
                    millis = traffic.getPeriod().getTime();
                    periodValue = traffic.getTrafficMap();
                    timePeriod = new Day(new Date(millis));
                    if (currentTimePeriod != null && !currentTimePeriod.next().equals(timePeriod)) {
                        next = currentTimePeriod.next();
                        if (next.equals(prev = timePeriod.previous())) {
                            for (TimeSeries timeSeries2 : timeSeriesMap.values()) {
                                timeSeries2.add(next, 0.0);
                            }
                        } else {
                            for (TimeSeries timeSeries2 : timeSeriesMap.values()) {
                                timeSeries2.add(next, 0.0);
                                timeSeries2.add(prev, 0.0);
                            }
                        }
                    }
                    currentTimePeriod = timePeriod;
                    for (Map.Entry e : periodValue.entrySet()) {
                        trafficTypeId = (Integer)e.getKey();
                        if (timeTrafficTypeIds.contains(trafficTypeId)) continue;
                        amount = (Long)e.getValue();
                        timeSeries = (TimeSeries)timeSeriesMap.get(trafficTypeId);
                        if (timeSeries == null) {
                            trafficType = (TrafficType)trafficTypeMap.get(trafficTypeId);
                            timeSeries = new TimeSeries((Comparable)((Object)(trafficType.getTitle() + (String)suffix)));
                            timeSeriesMap.put(trafficTypeId, timeSeries);
                        }
                        timeSeries.add((RegularTimePeriod)timePeriod, (double)amount.longValue() / (double)unit);
                    }
                }
                for (TimeSeries timeSeries3 : timeSeriesMap.values()) {
                    timeSeries3.add(currentTimePeriod.next(), 0.0);
                }
                break;
            }
            default: {
                TrafficType trafficType;
                TimeSeries timeSeries;
                Long amount;
                Object trafficTypeId;
                RegularTimePeriod prev;
                RegularTimePeriod next;
                Day timePeriod;
                Map periodValue;
                long millis;
                Day currentTimePeriod = null;
                for (TrafficAmount traffic : trafficList) {
                    millis = traffic.getPeriod().getTime();
                    periodValue = traffic.getTrafficMap();
                    timePeriod = new Hour(new Date(millis));
                    if (currentTimePeriod != null && !currentTimePeriod.next().equals(timePeriod)) {
                        next = currentTimePeriod.next();
                        if (next.equals(prev = timePeriod.previous())) {
                            for (TimeSeries timeSeries2 : timeSeriesMap.values()) {
                                timeSeries2.add(next, 0.0);
                            }
                        } else {
                            for (TimeSeries timeSeries2 : timeSeriesMap.values()) {
                                timeSeries2.add(next, 0.0);
                                timeSeries2.add(prev, 0.0);
                            }
                        }
                    }
                    currentTimePeriod = timePeriod;
                    for (Map.Entry e : periodValue.entrySet()) {
                        trafficTypeId = (Integer)e.getKey();
                        amount = (Long)e.getValue();
                        timeSeries = (TimeSeries)timeSeriesMap.get(trafficTypeId);
                        if (timeSeries == null) {
                            trafficType = (TrafficType)trafficTypeMap.get(trafficTypeId);
                            timeSeries = new TimeSeries((Comparable)((Object)(trafficType.getTitle() + (String)suffix)));
                            timeSeriesMap.put(trafficTypeId, timeSeries);
                        }
                        timeSeries.add((RegularTimePeriod)timePeriod, (double)amount.longValue() / (double)unit);
                    }
                }
                for (TimeSeries timeSeries3 : timeSeriesMap.values()) {
                    timeSeries3.add(currentTimePeriod.next(), 0.0);
                }
            }
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        for (TimeSeries timeSeries3 : timeSeriesMap.values()) {
            dataset.addSeries(timeSeries3);
        }
        try {
            XYStepRenderer r = new XYStepRenderer();
            ArrayList<BasicStroke> strokeListTemp = new ArrayList<BasicStroke>();
            strokeListTemp.add(new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{5.0f, 5.0f}, 0.0f));
            strokeListTemp.add(new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{1.0f, 2.0f}, 0.0f));
            ArrayList<BasicStroke> strokeList = new ArrayList<BasicStroke>();
            for (int i = 0; i < 10; ++i) {
                strokeList.addAll(strokeListTemp);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            ChartUtils.writeChartAsPNG((OutputStream)baos, (JFreeChart)Charts.createTimeSeriesChart((XYItemRenderer)r, (XYDataset)dataset, (DrawingSupplier)Charts.getDrawingSupplier(null, null)), (int)800, (int)300, (ChartRenderingInfo)new ChartRenderingInfo(), (boolean)true, (int)0);
            result = this.addChart(baos);
            baos = null;
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
        for (TimeSeries timeSeries3 : timeSeriesMap.values()) {
            timeSeries3.clear();
        }
        timeSeriesMap.clear();
        if (result != null) {
            this.setResultParam("chart", result);
        }
        return result;
    }

    private String chartTrafficPie(Map<Integer, TrafficType> trafficTypeMap, List<TrafficAmount> trafficList, long unit, TimeUnit timeUnit) throws BGException {
        String result = null;
        HashMap<Integer, AccountingTrafficAmount> map = new HashMap<Integer, AccountingTrafficAmount>();
        for (TrafficAmount trafficAmount : trafficList) {
            for (Map.Entry e : trafficAmount.getTrafficMap().entrySet()) {
                AccountingTrafficAmount amount = (AccountingTrafficAmount)map.get(e.getKey());
                if (amount == null) {
                    amount = new AccountingTrafficAmount(((Long)e.getValue()).longValue());
                    map.put((Integer)e.getKey(), amount);
                    continue;
                }
                amount.amount += ((Long)e.getValue()).longValue();
            }
        }
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (Map.Entry entry : map.entrySet()) {
            TrafficType trafficType = trafficTypeMap.get(entry.getKey());
            if (trafficType == null) continue;
            dataset.setValue((Comparable)((Object)trafficType.getTitle()), (Number)((AccountingTrafficAmount)entry.getValue()).amount);
        }
        if (dataset.getItemCount() == 0) {
            return null;
        }
        try {
            JFreeChart jFreeChart = Charts.createPieChart((DefaultPieDataset)dataset, null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            ChartUtils.writeChartAsPNG((OutputStream)byteArrayOutputStream, (JFreeChart)jFreeChart, (int)800, (int)250, (ChartRenderingInfo)new ChartRenderingInfo(), (boolean)true, (int)0);
            result = this.addChart(byteArrayOutputStream);
            Object var10_16 = null;
        }
        catch (IOException iOException) {
            throw new BGException((Throwable)iOException);
        }
        if (result != null) {
            this.setResultParam("chartPie", result);
        }
        return result;
    }
}

