/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServOption;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.util.AbstractPeriodItemSet;
import ru.bitel.common.util.PeriodItemSet;

public final class InetServOptionList
extends PeriodItemSet {
    private static final Logger logger = LogManager.getLogger();

    InetServOptionList(List<AbstractPeriodItemSet.PeriodItem> entryList) {
        super(entryList);
        if (logger.isDebugEnabled()) {
            for (AbstractPeriodItemSet.PeriodItem item : this.entries) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("InetServOption: " + TimeUtils.format((Date)new Date(item.timeFrom), (String)"dd.MM.yyyy HH:mm:ss.S") + " - " + TimeUtils.format((Date)new Date(item.timeTo), (String)"dd.MM.yyyy HH:mm:ss.S"));
            }
        }
    }

    InetServOptionList(AbstractPeriodItemSet.PeriodItem[] entries) {
        super(entries);
        if (logger.isDebugEnabled()) {
            for (AbstractPeriodItemSet.PeriodItem item : entries) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("InetServOption: " + TimeUtils.format((Date)new Date(item.timeFrom), (String)"dd.MM.yyyy HH:mm:ss.S") + " - " + TimeUtils.format((Date)new Date(item.timeTo), (String)"dd.MM.yyyy HH:mm:ss.S"));
            }
        }
    }

    public AbstractPeriodItemSet.PeriodItem[] items() {
        return this.entries;
    }

    protected boolean isCoincide(AbstractPeriodItemSet.PeriodItem item, AbstractPeriodItemSet.PeriodItem other) {
        return other.id == item.id;
    }

    public InetServOptionList add(InetServOption accountingPeriod, Calendar utilCalendar) {
        long timeFrom = InetUtils.dateFrom(accountingPeriod.getDateFrom(), utilCalendar);
        long timeTo = InetUtils.dateTo(accountingPeriod.getDateTo(), utilCalendar);
        return new InetServOptionList(super.add(new AbstractPeriodItemSet.PeriodItem(accountingPeriod.getOptionId(), timeFrom, timeTo)));
    }

    public InetServOptionList update(InetServOption accountingPeriod, Calendar utilCalendar) {
        long timeFrom = InetUtils.dateFrom(accountingPeriod.getDateFrom(), utilCalendar);
        long timeTo = InetUtils.dateTo(accountingPeriod.getDateTo(), utilCalendar);
        return new InetServOptionList(super.update(new AbstractPeriodItemSet.PeriodItem(accountingPeriod.getOptionId(), timeFrom, timeTo)));
    }

    public InetServOptionList remove(InetServOption accountingPeriod, Calendar utilCalendar) {
        long timeFrom = InetUtils.dateFrom(accountingPeriod.getDateFrom(), utilCalendar);
        long timeTo = InetUtils.dateTo(accountingPeriod.getDateTo(), utilCalendar);
        return new InetServOptionList(super.remove(new AbstractPeriodItemSet.PeriodItem(accountingPeriod.getOptionId(), timeFrom, timeTo)));
    }

    public static InetServOptionList newInstance(List<InetServOption> servOptionList, Calendar utilCalendar) {
        ArrayList<AbstractPeriodItemSet.PeriodItem> result = new ArrayList<AbstractPeriodItemSet.PeriodItem>();
        for (InetServOption accountingPeriod : servOptionList) {
            long timeFrom = InetUtils.dateFrom(accountingPeriod.getDateFrom(), utilCalendar);
            long timeTo = InetUtils.dateTo(accountingPeriod.getDateTo(), utilCalendar);
            result.add(new AbstractPeriodItemSet.PeriodItem(accountingPeriod.getOptionId(), timeFrom, timeTo));
        }
        return new InetServOptionList(result);
    }

    public List<InetServOption> toList(int inetServId) {
        ArrayList<InetServOption> result = new ArrayList<InetServOption>();
        for (AbstractPeriodItemSet.PeriodItem item : this.items()) {
            InetServOption option = new InetServOption();
            option.setServiceId(inetServId);
            option.setOptionId(item.id);
            if (item.timeFrom != 0L) {
                option.setDateFrom(new Date(item.timeFrom));
            }
            if (item.timeTo != 0L) {
                option.setDateTo(new Date(item.timeTo));
            }
            result.add(option);
        }
        return result;
    }
}

