/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMax;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxManager;
import ru.bitel.common.TimeUtils;

public class TrafficMaxTarifficationManager
extends TrafficMaxManager {
    protected Date month;

    public TrafficMaxTarifficationManager(int moduleId, Date month) throws BGException {
        super(moduleId, false);
        this.month = month;
    }

    @Override
    protected TrafficMax getMaxTraffic(InetTariffWorkerContext workerContext, int contractId, long accountingPeriodFrom, long treeNodeId, long key, Calendar time) throws BGException {
        return this.getPrevMonthTraffic(workerContext, contractId, treeNodeId, key);
    }

    public TrafficMax getPrevMonthTraffic(InetTariffWorkerContext workerContext, int contractId, long treeNodeId, long key) throws BGException {
        String tableName = "inet_tariff_traffic_max_" + this.moduleId;
        try {
            int yy = TimeUtils.convertDateToCalendar((Date)this.month).get(1);
            int mm = TimeUtils.convertDateToCalendar((Date)this.month).get(2) + 1;
            String query = "SELECT counter, amountMax, amount1, amount2  FROM " + tableName + " WHERE contractId=? AND treeNodeId=? AND maxKey=?  AND  ( (yy < ? ) or ( yy = ? AND mm < ? ) )  ORDER BY yy DESC, mm DESC LIMIT 1";
            ResultSet rs = workerContext.getPSCache().execute(query, new Object[]{contractId, treeNodeId, key, yy, yy, mm});
            TrafficMax maxTraffic = new TrafficMax(0, 0L, 0L, 0L);
            if (rs.next()) {
                maxTraffic = new TrafficMax(rs.getInt(1), rs.getLong(2), rs.getLong(3), rs.getLong(4));
            }
            return maxTraffic;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

