/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.xml.XmlAdapters;

public class ContractPattern
extends Id {
    private int fc;
    private int mode;
    private int status;
    private int daysToLive;
    private int patternId;
    private int domainId;
    private int paramsGroupId;
    private int namePatternId;
    private boolean hidden = false;
    private long groups;
    private BigDecimal closesumma;
    private String title;
    private String limitMode;
    private String objectString;
    private String patternMode;
    private String masterHandlerClass;
    private String masterTariffMode;
    private Set<Integer> contractLabels = null;
    private List<String> moduleList = null;
    private List<String> serviceList = null;
    private List<Integer> scriptList = new ArrayList<Integer>();
    private List<String> tariffPlanList = new ArrayList<String>();
    private List<Integer> tariffGroupList = new ArrayList<Integer>();
    private Set<Integer> masterRequiredParameterIds = new HashSet<Integer>();
    private Set<Integer> masterOptionalParameterIds = new HashSet<Integer>();
    private Document data;

    public int getNamePatternId() {
        return this.namePatternId;
    }

    public ContractPattern setNamePatternId(int namePatternId) {
        this.namePatternId = namePatternId;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public ContractPattern setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public List<String> getModuleList() {
        if (this.moduleList == null) {
            HashSet<String> moduleSet = new HashSet<String>();
            this.moduleList = new ArrayList<String>();
            if (this.data != null) {
                try {
                    for (Element moduleElement : XMLUtils.selectElements(this.data, "/data/modules/*")) {
                        moduleSet.add(moduleElement.getAttribute("mid"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (String val : moduleSet) {
                    this.moduleList.add(val);
                }
            }
        }
        return this.moduleList;
    }

    @XmlAttribute
    public int getPatternId() {
        return this.patternId;
    }

    public ContractPattern setPatternId(int patternId) {
        this.patternId = patternId;
        return this;
    }

    public ContractPattern setTitle(String title) {
        this.title = title;
        return this;
    }

    public ContractPattern setClosesumma(BigDecimal closesumma) {
        this.closesumma = closesumma;
        return this;
    }

    public ContractPattern setLimitMode(String limitMode) {
        this.limitMode = limitMode;
        return this;
    }

    public ContractPattern setTariffPlanList(List<String> value) {
        this.tariffPlanList = value;
        return this;
    }

    public ContractPattern setGroups(long groups) {
        this.groups = groups;
        return this;
    }

    public ContractPattern setMode(int mode) {
        this.mode = mode;
        return this;
    }

    public ContractPattern setParamsGroupId(int paramsGroupId) {
        this.paramsGroupId = paramsGroupId;
        return this;
    }

    public ContractPattern setFc(int fc) {
        this.fc = fc;
        return this;
    }

    public ContractPattern setDaysToLive(int daysToLive) {
        this.daysToLive = daysToLive;
        return this;
    }

    public ContractPattern setTariffGroupList(List<Integer> value) {
        this.tariffGroupList = value;
        return this;
    }

    @XmlAttribute
    public String getTitle() {
        return this.title;
    }

    @XmlAttribute
    public BigDecimal getClosesumma() {
        return this.closesumma;
    }

    @XmlAttribute
    public String getLimitMode() {
        return this.limitMode;
    }

    public List<String> getTariffPlanList() {
        return this.tariffPlanList;
    }

    @XmlAttribute
    public long getGroups() {
        return this.groups;
    }

    @XmlAttribute
    public int getMode() {
        return this.mode;
    }

    @XmlAttribute
    public int getParamsGroupId() {
        return this.paramsGroupId;
    }

    @XmlAttribute
    public int getFc() {
        return this.fc;
    }

    @XmlAttribute
    public int getDaysToLive() {
        return this.daysToLive;
    }

    public List<Integer> getTariffGroupList() {
        return this.tariffGroupList;
    }

    public List<String> getServiceList() {
        if (this.serviceList == null) {
            this.serviceList = new ArrayList<String>();
            if (this.data != null) {
                try {
                    for (Element moduleElement : XMLUtils.selectElements(this.data, "//addServices/item")) {
                        this.serviceList.add(moduleElement.getAttribute("sid"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.serviceList;
    }

    @XmlJavaTypeAdapter(type=Document.class, value=XmlAdapters.DocumentAdapter.class)
    public Document getData() {
        return this.data;
    }

    public ContractPattern setData(Document data) {
        this.data = data;
        this.moduleList = null;
        this.serviceList = null;
        return this;
    }

    public List<Integer> getScriptList() {
        return this.scriptList;
    }

    public ContractPattern setScriptList(List<Integer> scriptId) {
        this.scriptList = scriptId;
        return this;
    }

    @XmlAttribute
    public int getStatus() {
        return this.status;
    }

    public ContractPattern setStatus(int status) {
        this.status = status;
        return this;
    }

    public ContractPattern setObjectString(String objectString) {
        this.objectString = objectString;
        return this;
    }

    @XmlAttribute
    public String getObjectString() {
        return this.objectString;
    }

    public String getPatternMode() {
        return this.patternMode;
    }

    public ContractPattern setPatternMode(String patternMode) {
        this.patternMode = patternMode;
        return this;
    }

    public String getMasterHandlerClass() {
        return this.masterHandlerClass;
    }

    public ContractPattern setMasterHandlerClass(String masterHandlerClass) {
        this.masterHandlerClass = masterHandlerClass;
        return this;
    }

    public String getMasterTariffMode() {
        return this.masterTariffMode;
    }

    public ContractPattern setMasterTariffMode(String masterTariffMode) {
        this.masterTariffMode = masterTariffMode;
        return this;
    }

    @XmlAttribute
    public int getWebMenuId() {
        int webMenuId = -1;
        if (this.data != null) {
            try {
                webMenuId = Utils.parseInt(this.data.getDocumentElement().getAttribute("webMenuId"), -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return webMenuId;
    }

    @XmlAttribute
    public int getDomainId() {
        return this.domainId;
    }

    public ContractPattern setDomainId(int domainId) {
        this.domainId = domainId;
        return this;
    }

    public Set<Integer> getContractLabels() throws Exception {
        if (this.contractLabels == null) {
            this.contractLabels = new HashSet<Integer>();
            if (this.getData() != null) {
                for (Element item : XMLUtils.selectElements(this.getData(), "//data/contractLabels/item")) {
                    int contractLabelId = Utils.parseInt(item.getAttribute("id"));
                    this.contractLabels.add(contractLabelId);
                }
            }
        }
        return this.contractLabels;
    }

    public Set<Integer> getMasterRequiredParameterIds() {
        return this.masterRequiredParameterIds;
    }

    public ContractPattern setMasterRequiredParameterIds(Set<Integer> masterRequiredParameterIds) {
        this.masterRequiredParameterIds = masterRequiredParameterIds;
        return this;
    }

    public Set<Integer> getMasterOptionalParameterIds() {
        return this.masterOptionalParameterIds;
    }

    public ContractPattern setMasterOptionalParameterIds(Set<Integer> masterOptionalParameterIds) {
        this.masterOptionalParameterIds = masterOptionalParameterIds;
        return this;
    }

    public ContractPattern copy() {
        return ContractPattern.builder().setId(this.id).setFc(this.fc).setMode(this.mode).setStatus(this.status).setDaysToLive(this.daysToLive).setPatternId(this.patternId).setDomainId(this.domainId).setParamsGroupId(this.paramsGroupId).setGroups(this.groups).setClosesumma(this.closesumma).setTitle(this.title).setLimitMode(this.limitMode).setNamePatternId(this.namePatternId).setHidden(this.hidden).setObjectString(this.objectString).setPatternMode(this.patternMode).setMasterHandlerClass(this.masterHandlerClass).setMasterTariffMode(this.masterTariffMode).setData(this.data).setTariffGroupList(this.tariffGroupList).setTariffPlanList(this.tariffPlanList).setMasterRequiredParameterIds(this.masterRequiredParameterIds).setMasterOptionalParameterIds(this.masterOptionalParameterIds).setScriptList(this.scriptList).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ContractPattern contractPattern = new ContractPattern();

        private Builder() {
        }

        public Builder setId(int id) {
            this.contractPattern.id = id;
            return this;
        }

        public Builder setClosesumma(BigDecimal closesumma) {
            this.contractPattern.closesumma = closesumma;
            return this;
        }

        public Builder setLimitMode(String limitMode) {
            this.contractPattern.limitMode = limitMode;
            return this;
        }

        public Builder setMode(int mode) {
            this.contractPattern.mode = mode;
            return this;
        }

        public Builder setFc(int fc) {
            this.contractPattern.fc = fc;
            return this;
        }

        public Builder setTitle(String title) {
            this.contractPattern.title = title;
            return this;
        }

        public Builder setTariffPlanList(List<String> value) {
            this.contractPattern.tariffPlanList = value;
            return this;
        }

        public Builder setParamsGroupId(int paramsGroupId) {
            this.contractPattern.paramsGroupId = paramsGroupId;
            return this;
        }

        public Builder setDaysToLive(int daysToLive) {
            this.contractPattern.daysToLive = daysToLive;
            return this;
        }

        public Builder setTariffGroupList(List<Integer> value) {
            this.contractPattern.tariffGroupList = value;
            return this;
        }

        public Builder setNamePatternId(int namePatternId) {
            this.contractPattern.namePatternId = namePatternId;
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.contractPattern.hidden = hidden;
            return this;
        }

        public Builder setData(Document data) {
            this.contractPattern.setData(data);
            return this;
        }

        public Builder setPatternId(int patternId) {
            this.contractPattern.patternId = patternId;
            return this;
        }

        public Builder setStatus(int status) {
            this.contractPattern.status = status;
            return this;
        }

        public Builder setObjectString(String objectString) {
            this.contractPattern.objectString = objectString;
            return this;
        }

        public Builder setDomainId(int domainId) {
            this.contractPattern.domainId = domainId;
            return this;
        }

        public Builder setGroups(long groups) {
            this.contractPattern.groups = groups;
            return this;
        }

        public Builder setPatternMode(String patternMode) {
            this.contractPattern.patternMode = patternMode;
            return this;
        }

        public Builder setScriptList(List<Integer> scriptIds) {
            this.contractPattern.scriptList = scriptIds;
            return this;
        }

        public Builder setMasterRequiredParameterIds(Set<Integer> masterRequiredParameterIds) {
            this.contractPattern.masterRequiredParameterIds = masterRequiredParameterIds;
            return this;
        }

        public Builder setMasterOptionalParameterIds(Set<Integer> masterOptionalParameterIds) {
            this.contractPattern.masterOptionalParameterIds = masterOptionalParameterIds;
            return this;
        }

        public Builder setMasterHandlerClass(String masterHandlerClass) {
            this.contractPattern.masterHandlerClass = masterHandlerClass;
            return this;
        }

        public Builder setMasterTariffMode(String masterTariffMode) {
            this.contractPattern.masterTariffMode = masterTariffMode;
            return this;
        }

        public ContractPattern build() {
            ContractPattern a = this.contractPattern;
            this.contractPattern = null;
            return a;
        }
    }
}

