/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import bitel.billing.module.admin.DBInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGDialog;

public class UserAuthR
extends BGDialog {
    private BGTextField serverTitle = new BGTextField();
    private BGTextField serverURL = new BGTextField();
    private BGTextField userLogin = new BGTextField();
    private JPasswordField userPswd = new JPasswordField();
    private BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
    private DBInfo dbInfo = null;

    public UserAuthR() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.pack();
        this.moveWindowToCenterScreen();
    }

    public DBInfo getDbInfo() {
        return this.dbInfo;
    }

    public void setDbInfo(DBInfo dbInfo) {
        this.dbInfo = dbInfo;
        if (dbInfo != null) {
            this.serverTitle.setText(dbInfo.getDbServerTitle());
            this.serverURL.setText(dbInfo.getDbServerURL());
        }
    }

    @Override
    public void setData() {
        if (this.dbInfo != null) {
            this.userLogin.setText(this.dbInfo.getDbServerLogin());
            this.userPswd.setText(this.dbInfo.getDbServerPassword());
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                UserAuthR.this.this_windowOpened(windowEvent);
            }
        });
        this.okCancelPanel.addActionListener(e -> this.okCancelPanelActionPerformed(e));
        this.getContentPane().add((Component)this.getConnectPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.okCancelPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 20, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.getRootPane().setDefaultButton(this.okCancelPanel.getButtonOk());
    }

    private void okCancelPanelActionPerformed(ActionEvent actionEvent) {
        if (BGButtonPanel.OK.getActionCommand().equals(actionEvent.getActionCommand())) {
            if (this.performConnect2()) {
                this.result = "ok";
                this.setVisible(false);
                this.dispose();
            }
        } else if (BGButtonPanel.CANCEL.getActionCommand().equals(actionEvent.getActionCommand())) {
            this.result = "cancel";
            this.setVisible(false);
            this.dispose();
        }
    }

    private boolean performConnect2() {
        String login = this.userLogin.getText();
        if (login == null || login.trim().length() == 0) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d \u041b\u041e\u0413\u0418\u041d");
            return false;
        }
        char[] pswd = this.userPswd.getPassword();
        if (pswd == null || pswd.length < 5) {
            ClientUtils.showErrorMessageDialog("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043e\u0442 5 \u0434\u043e 15 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            return false;
        }
        if (this.dbInfo == null) {
            return false;
        }
        this.dbInfo.setDbServerLogin(login);
        this.dbInfo.setDbServerPassword(pswd);
        return true;
    }

    private void this_windowOpened(WindowEvent e) {
        this.userLogin.requestFocusInWindow();
    }

    private JPanel getConnectPanel() {
        this.serverTitle.setColumns(30);
        Color bgColor = this.serverTitle.getBackground();
        this.serverTitle.setEditable(false);
        this.serverTitle.setBackground(bgColor);
        this.serverURL.setEditable(false);
        this.serverURL.setBackground(bgColor);
        JPanel jPanel = new JPanel(new GridBagLayout());
        int gridy = 0;
        jPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.serverTitle, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)new JLabel("\u0421\u0435\u0440\u0432\u0435\u0440:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.serverURL, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)new JLabel("\u041b\u043e\u0433\u0438\u043d:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.userLogin, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.userPswd, new GridBagConstraints(1, gridy++, 2, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 5, 0), 0, 0));
        return jPanel;
    }
}

