/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPasswordLogItem;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ContractPasswordLogDao
extends AbstractDao<ContractPasswordLogItem> {
    private static final String TABLE_LOG_CONTRACT_PSWD = "log_contract_pswd";

    public ContractPasswordLogDao(Connection con) {
        super(con, 0, TABLE_LOG_CONTRACT_PSWD);
        this.fields = new HashMap();
        this.fields.put("lastUpdate", "dt");
        this.fields.put("userName", "uid");
    }

    public void addContractPasswordLogItem(ContractPasswordLogItem item) throws SQLException {
        Objects.requireNonNull(item);
        String query = "INSERT INTO " + this.tableName + " SET dt=?, uid=?, cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)item.getDatetime()));
            ps.setInt(index++, item.getUserId());
            ps.setInt(index++, item.getContractId());
            ps.executeUpdate();
        }
    }

    public void searchContractPasswordLogItemByContractId(SearchResult<ContractPasswordLogItem> searchResult, int contractId) throws SQLException {
        Objects.requireNonNull(searchResult);
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        String query = "SELECT SQL_CALC_FOUND_ROWS log.*, user.name AS userName FROM " + this.tableName + " AS log LEFT JOIN user ON user.id=log.uid  WHERE cid=" + contractId + this.getSQLOrder(searchResult.getSort(), this.fields) + this.sqlLimit(page);
        try (Statement st = this.con.createStatement();){
            try (ResultSet rs = st.executeQuery(query.toString());){
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
            page.setRecordCount(ServerUtils.foundRows(this.con));
        }
    }

    protected ContractPasswordLogItem getFromRS(ResultSet rs) throws SQLException {
        return new ContractPasswordLogItem().setDatetime(rs.getTimestamp("dt")).setContractId(rs.getInt("cid")).setUserId(rs.getInt("uid"));
    }

    protected void updateImpl(ContractPasswordLogItem b) throws SQLException {
    }
}

