/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.client;

import bitel.billing.module.common.ModTreeNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicCodeTree;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.action.BGUAction;

public class CompilationExcludeResources {
    private static CompilationExcludeResources INSTANCE;
    private final Set<String> excludeCompilationClasses = new HashSet<String>();
    private final Set<String> excludeCompilationPackages = new HashSet<String>();
    private final DynamicCodeTree dynamicCodeTree;
    private final DynamicCodeService dynamicCodeService;

    private CompilationExcludeResources(DynamicCodeTree dynamicCodeTree) {
        this.dynamicCodeTree = dynamicCodeTree;
        this.dynamicCodeService = (DynamicCodeService)((ClientContext)dynamicCodeTree.getContext()).getPort(DynamicCodeService.class);
        this.loadExcludeCompilationResources();
    }

    protected static CompilationExcludeResources getInstance(DynamicCodeTree dynamicCodeTree) {
        if (INSTANCE == null) {
            INSTANCE = new CompilationExcludeResources(dynamicCodeTree);
        }
        return INSTANCE;
    }

    private void loadExcludeCompilationResources() {
        this.excludeCompilationClasses.clear();
        this.excludeCompilationPackages.clear();
        try {
            List<String> allResources = this.dynamicCodeService.getExcludeCompilationResources();
            this.excludeCompilationClasses.addAll(allResources.stream().filter(s -> s.startsWith("class::")).toList());
            this.excludeCompilationPackages.addAll(allResources.stream().filter(s -> s.startsWith("package::")).toList());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    protected boolean packageIsExclude(ModTreeNode node) {
        String packagePath = "package::" + this.getPackagePath(node);
        for (String excludePackage : this.excludeCompilationPackages) {
            if (!excludePackage.equals(packagePath)) continue;
            return true;
        }
        return false;
    }

    private String getPackagePath(ModTreeNode node) {
        if (node.getParent() != null) {
            String parentPath = this.getPackagePath((ModTreeNode)node.getParent());
            return (String)(Utils.isBlankString((String)parentPath) || ".".equals(parentPath) ? "" : parentPath + ".") + String.valueOf(node.getAttribute("name"));
        }
        return (String)node.getAttribute("name");
    }

    protected boolean classCompileExclude(String className) {
        Object name;
        Object object = name = className.startsWith("class::") ? className : "class::" + className;
        if (this.excludeCompilationClasses.contains(name)) {
            return true;
        }
        String cleanClassName = ((String)name).replace("class::", "");
        for (String p : this.excludeCompilationPackages) {
            String cleanPackageName = p.replace("package::", "");
            if (!(cleanPackageName + ".").equals(cleanClassName)) continue;
            return true;
        }
        return false;
    }

    private void addToCompile(boolean isPackage, String resourceName) {
        if (isPackage) {
            String classesPrefix = resourceName.replace("package::", "class::");
            this.excludeCompilationPackages.removeIf(p -> p.equals(resourceName));
            this.excludeCompilationClasses.removeIf(cl -> cl.startsWith(classesPrefix));
        } else {
            this.excludeCompilationClasses.removeIf(p -> p.equals(resourceName));
        }
        String cleanName = isPackage ? resourceName.replace("package::", "") : resourceName.replace("class::", "");
        StringBuilder currentPackage = new StringBuilder();
        String[] parts = cleanName.split("\\.");
        for (int i = 0; i < parts.length - (isPackage ? 0 : 1); ++i) {
            if (i > 0) {
                currentPackage.append(".");
            }
            currentPackage.append(parts[i]);
            boolean hasClassesInPackage = this.excludeCompilationClasses.stream().anyMatch(cl -> cl.startsWith("class::" + String.valueOf(currentPackage) + "."));
            if (hasClassesInPackage) continue;
            this.excludeCompilationPackages.removeIf(p -> p.equals("package::" + String.valueOf(currentPackage)));
        }
        this.updateExcludeCompilationResources();
    }

    private void addToExclude(boolean isPackage, String resourceName, ModTreeNode node) {
        if (isPackage) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                String name;
                ModTreeNode child = (ModTreeNode)node.getChildAt(i);
                Object type = child.getAttribute("type");
                if (type.equals(1)) {
                    String childPackageName = resourceName + "." + String.valueOf(child.getAttribute("name"));
                    this.excludeCompilationPackages.add(childPackageName);
                    this.addToExclude(true, childPackageName, child);
                    continue;
                }
                if (!type.equals(2) || !DynamicClass.isJavaSource(name = (String)child.getAttribute("name"))) continue;
                this.excludeCompilationClasses.add("class::" + name);
            }
            this.excludeCompilationPackages.add(resourceName);
        } else {
            this.excludeCompilationClasses.add(resourceName);
        }
        this.updateExcludeCompilationResources();
    }

    private void updateExcludeCompilationResources() {
        try {
            this.dynamicCodeService.updateExcludeCompilationResources(Stream.concat(this.excludeCompilationClasses.stream(), this.excludeCompilationPackages.stream()).toList());
            this.dynamicCodeTree.recreateTree(this.dynamicCodeService.getDynamicClasses());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    protected static final class ResourcesMenu {
        private static final JPopupMenu MENU = new JPopupMenu();

        protected ResourcesMenu() {
        }

        public static void show(DynamicCodeTree dynamicCodeTree, int x, int y) {
            String resourceName;
            TreePath selected = dynamicCodeTree.getTree().getSelectionPath();
            if (selected == null) {
                return;
            }
            final ModTreeNode modTreeNode = (ModTreeNode)selected.getLastPathComponent();
            final boolean isPackage = modTreeNode.getAttribute("type").equals(1);
            final CompilationExcludeResources excludedResources = CompilationExcludeResources.getInstance(dynamicCodeTree);
            String string = resourceName = isPackage ? ResourcesMenu.getPackageName(selected) : "class::" + String.valueOf(modTreeNode.getAttribute("name"));
            if (resourceName.equals("/")) {
                return;
            }
            final boolean addToCompile = excludedResources.excludeCompilationPackages.contains(resourceName) || excludedResources.excludeCompilationClasses.contains(resourceName);
            String labelName = addToCompile ? "\u0423\u0431\u0440\u0430\u0442\u044c \u0438\u0437 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043d\u0430 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u044e" : "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043d\u0430 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u044e";
            MENU.removeAll();
            MENU.add((Action)new BGUAction("comp", labelName){

                public void actionPerformed(ActionEvent e) {
                    if (addToCompile) {
                        excludedResources.addToCompile(isPackage, resourceName);
                    } else {
                        excludedResources.addToExclude(isPackage, resourceName, modTreeNode);
                    }
                }
            });
            MENU.show((Component)((Object)dynamicCodeTree), x, y);
        }

        private static String getPackageName(TreePath treePath) {
            Object[] nodes = treePath.getPath();
            if (nodes.length <= 1) {
                return "";
            }
            return "package::" + Arrays.stream(nodes).skip(1L).map(node -> ((ModTreeNode)node).getAttribute("name").toString()).collect(Collectors.joining("."));
        }
    }
}

