/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.autopayment.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.client.ContractAutopaymentMethods;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentModeParameter;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.PeriodWithTime;

public class ContractAutopaymentCurrentModePanel
extends BGUPanel {
    private JPanel manualAutopaymentPanel = null;
    private BGButton offButton = new BGButton("\u0432\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c");
    private ContractAutopaymentMethods contractAutopaymentMethods = null;
    private ModeTextField activeTextFild = new ModeTextField();
    private ModeTextField modeTextFild = new ModeTextField();
    private ModeParameterTableModel modeParameterTableModel = new ModeParameterTableModel();
    private BGUTable modeParameterTable = new BGUTable((TableModel)((Object)this.modeParameterTableModel));

    public ContractAutopaymentCurrentModePanel(ContractAutopaymentMethods contractAutopaymentMethods) {
        this.contractAutopaymentMethods = contractAutopaymentMethods;
    }

    protected void jbInit() throws Exception {
        this.modeTextFild.setText("\u041d\u0415\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u041b\u0415\u041d");
        this.activeTextFild.setText("\u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d");
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0440\u0435\u0436\u0438\u043c"));
        this.add(this.getModePanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(BGSwingUtilites.wrapScrollPane((JComponent)this.modeParameterTable, (int)500, (int)80), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.getManualAutopaymentPanel(), new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 5, 5, 5), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getModePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getModeAndButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0441:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.activeTextFild, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getModeAndButtonPanel() {
        this.offButton.setEnabled(false);
        this.offButton.addActionListener(e -> {
            if (ClientUtils.confirm((String)"\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436?", (String)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435")) {
                this.tryCall(() -> this.contractAutopaymentMethods.autopaymentDeactivate(((ClientContext)this.getContext()).getContractId()));
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.modeTextFild, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.offButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getManualAutopaymentPanel() {
        if (this.manualAutopaymentPanel == null) {
            BGTextField sumField = new BGTextField(10);
            sumField.setHorizontalAlignment(0);
            BGButton button = new BGButton("\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c");
            button.addActionListener(e -> this.tryCall(() -> {
                BigDecimal sum = new BigDecimal(sumField.getText());
                DecimalFormat decimalFormat = new DecimalFormat("###,###,###,##0.00");
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 - " + decimalFormat.format(sum), "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0) == 0) {
                    this.contractAutopaymentMethods.doManualAutopayment(((ClientContext)this.getContext()).getContractId(), sum);
                    this.performAction("refresh");
                }
            }));
            this.manualAutopaymentPanel = new JPanel(new GridBagLayout());
            this.manualAutopaymentPanel.setBorder(new TitledBorder("\u0420\u0443\u0447\u043d\u043e\u0439 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436"));
            this.manualAutopaymentPanel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.manualAutopaymentPanel.add((Component)sumField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.manualAutopaymentPanel.add((Component)button, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.manualAutopaymentPanel.setVisible(false);
        }
        return this.manualAutopaymentPanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            Autopayment autopayment = this.contractAutopaymentMethods.getAutopaymentCurrentMode(((ClientContext)this.getContext()).getContractId());
            if (autopayment != null) {
                ArrayList<String> data = new ArrayList<String>();
                AutopaymentMode autopaymentMode = autopayment.getMode();
                if (autopaymentMode != null) {
                    this.modeTextFild.setText(autopaymentMode.toString());
                    this.offButton.setEnabled(autopaymentMode != AutopaymentMode.OFF);
                    this.manualAutopaymentPanel.setVisible(autopaymentMode.getCode() == AutopaymentMode.AUTO.getCode());
                    Preferences preferences = new Preferences(autopayment.getModeData(), "\n");
                    if (AutopaymentMode.WEEK.getCode() == autopaymentMode.getCode()) {
                        this.setDataForModeParameterTableModel(preferences, data, "autopayment.mode.week.");
                    } else if (AutopaymentMode.MONTH.getCode() == autopaymentMode.getCode()) {
                        this.setDataForModeParameterTableModel(preferences, data, "autopayment.mode.month.");
                    } else if (AutopaymentMode.AUTO.getCode() == autopaymentMode.getCode()) {
                        this.setDataForModeParameterTableModel(preferences, data, "autopayment.mode.auto.");
                    }
                }
                this.modeParameterTableModel.setData(data);
                this.activeTextFild.setText("\u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d");
                PeriodWithTime period = autopayment.getPeriod();
                if (period != null && period.getDateFrom() != null) {
                    this.activeTextFild.setText(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(period.getDateFrom()));
                }
            }
        });
    }

    private void setDataForModeParameterTableModel(Preferences preferences, List<String> data, String prefix) {
        ParameterMap parameterMap = preferences.sub(prefix);
        for (Map.Entry entry : parameterMap.entrySet()) {
            data.add(prefix + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
    }

    class ModeTextField
    extends JTextField {
        public ModeTextField() {
            this.setColumns(15);
            this.setEditable(false);
            this.setBackground(Color.WHITE);
            this.setHorizontalAlignment(0);
        }
    }

    class ModeParameterTableModel
    extends BGTableModel<String> {
        public ModeParameterTableModel() {
            super(ModeParameterTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 50, 200, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 50, 100, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
        }

        public Object getValue(String value, int column) throws Exception {
            int pos = value.indexOf(61);
            if ("name".equals(this.getIdentifier(column))) {
                AutopaymentModeParameter modeParameter = AutopaymentModeParameter.getAutopaymentModeParameterByKey(value.substring(0, pos));
                return modeParameter != null ? modeParameter.getTitle() : value.substring(0, pos);
            }
            if ("value".equals(this.getIdentifier(column))) {
                return value.substring(pos + 1);
            }
            return super.getValue((Object)value, column);
        }
    }
}

