/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSetRealmMap;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.tlv.Tlv;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.ref.ConcurrentReferenceHashMap;

public class RadiusAttributeSet
implements Cloneable {
    protected final Map<Integer, List<RadiusAttribute<?>>> standartAttributes;
    protected final Map<Integer, Map<Integer, List<RadiusAttribute<?>>>> vendorAttributes;
    private static ConcurrentReferenceHashMap<RadiusAttributeSet, RadiusAttributeSet> attributeSetCache = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    protected RadiusAttributeSet(Map<Integer, List<RadiusAttribute<?>>> standartAttributes, Map<Integer, Map<Integer, List<RadiusAttribute<?>>>> vendorAttributes) {
        this.standartAttributes = standartAttributes;
        this.vendorAttributes = vendorAttributes;
    }

    public RadiusAttributeSet() {
        this.standartAttributes = new HashMap();
        this.vendorAttributes = new HashMap(4);
    }

    public static RadiusAttributeSet newRadiusAttributeSet(String attributes) {
        RadiusAttributeSet result = new RadiusAttributeSet();
        for (RadiusAttribute<?> ra : RadiusDictionary.parseAttributes(attributes)) {
            result.addAttribute(ra);
        }
        return result;
    }

    public static RadiusAttributeSet getRadiusAttributeSet(String attributes) {
        RadiusAttributeSet result = RadiusAttributeSet.newRadiusAttributeSet(attributes);
        return RadiusAttributeSet.intern(result);
    }

    public static RadiusAttributeSet newRadiusAttributeSet(Map<Integer, RadiusAttributeSet> setMap, Set<Integer> ids) {
        RadiusAttributeSet result = new RadiusAttributeSet();
        for (Integer id : ids) {
            RadiusAttributeSet set = setMap.get(id);
            if (set == null) continue;
            result.addAttributes(set);
        }
        return result;
    }

    public static RadiusAttributeSet getRadiusAttributeSet(Map<Integer, RadiusAttributeSet> setMap, Set<Integer> ids) {
        RadiusAttributeSet result = RadiusAttributeSet.newRadiusAttributeSet(setMap, ids);
        return RadiusAttributeSet.intern(result);
    }

    private static RadiusAttributeSet intern(RadiusAttributeSet attributeSet) {
        if (attributeSet == null) {
            return attributeSet;
        }
        RadiusAttributeSet result = (RadiusAttributeSet)attributeSetCache.get((Object)attributeSet);
        if (result != null) {
            return result;
        }
        result = (RadiusAttributeSet)attributeSetCache.putIfAbsent((Object)attributeSet, (Object)attributeSet);
        if (result == null) {
            result = attributeSet;
        }
        return result;
    }

    public static Map<Integer, RadiusAttributeSet> newRadiusAttributeSetMap(ParameterMap params, String prefix, String param) {
        HashMap<Integer, RadiusAttributeSet> result = new HashMap<Integer, RadiusAttributeSet>();
        for (Map.Entry e : params.subIndexed(prefix).entrySet()) {
            result.put((Integer)e.getKey(), RadiusAttributeSet.getRadiusAttributeSet(((ParameterMap)e.getValue()).get(param, null)));
        }
        return result;
    }

    public static RadiusAttributeSetRealmMap newRadiusAttributeSetRealmMap(ParameterMap params, String prefix, String param) {
        HashMap<String, Map<Integer, RadiusAttributeSet>> result = new HashMap<String, Map<Integer, RadiusAttributeSet>>(8);
        HashMap<Integer, RadiusAttributeSet> defaultRealmMap = new HashMap<Integer, RadiusAttributeSet>();
        result.put("default", defaultRealmMap);
        for (Map.Entry e : params.subIndexed(prefix).entrySet()) {
            Integer key = (Integer)e.getKey();
            for (Map.Entry ee : ((ParameterMap)e.getValue()).subKeyed("").entrySet()) {
                String key2 = (String)ee.getKey();
                if (param.equals(key2)) {
                    defaultRealmMap.put(key, RadiusAttributeSet.getRadiusAttributeSet(((ParameterMap)ee.getValue()).get("", null)));
                    continue;
                }
                HashMap<Integer, RadiusAttributeSet> map = (HashMap<Integer, RadiusAttributeSet>)result.get(key2);
                if (map == null) {
                    map = new HashMap<Integer, RadiusAttributeSet>();
                    result.put(key2, map);
                }
                map.put(key, RadiusAttributeSet.getRadiusAttributeSet(((ParameterMap)ee.getValue()).get(param, null)));
            }
        }
        return new RadiusAttributeSetRealmMap(result);
    }

    public static Map<String, RadiusAttributeSet> newRadiusAttributeRealmMap(ParameterMap params, String prefix, String param) {
        HashMap<String, RadiusAttributeSet> result = new HashMap<String, RadiusAttributeSet>();
        for (Map.Entry e : params.subKeyed(prefix).entrySet()) {
            result.put((String)e.getKey(), RadiusAttributeSet.getRadiusAttributeSet(((ParameterMap)e.getValue()).get(param, null)));
        }
        return result;
    }

    private void addAttributes(int vendor, int type, List<RadiusAttribute<?>> attributes) {
        if (vendor < 0) {
            List<RadiusAttribute<?>> list = this.standartAttributes.get(type);
            if (list == null) {
                this.standartAttributes.put(type, attributes);
            } else {
                list.addAll(attributes);
            }
        } else {
            List<RadiusAttribute<?>> list;
            Map<Integer, List<RadiusAttribute<?>>> attributeMap = this.vendorAttributes.get(vendor);
            if (attributeMap == null) {
                attributeMap = new HashMap();
                this.vendorAttributes.put(vendor, attributeMap);
            }
            if ((list = attributeMap.get(type)) == null) {
                attributeMap.put(type, attributes);
            } else {
                list.addAll(attributes);
            }
        }
    }

    private List<RadiusAttribute<?>> clone(List<RadiusAttribute<?>> ras) {
        ArrayList result = new ArrayList(ras.size());
        for (RadiusAttribute<?> ra : ras) {
            result.add((RadiusAttribute<?>)ra.clone());
        }
        return result;
    }

    public void addAttributes(RadiusAttributeSet set) {
        for (Map.Entry<Integer, List<RadiusAttribute<?>>> entry : set.standartAttributes.entrySet()) {
            int type = entry.getKey();
            this.addAttributes(-1, type, this.clone(entry.getValue()));
        }
        for (Map.Entry<Integer, Object> entry : set.vendorAttributes.entrySet()) {
            int vendor = entry.getKey();
            for (Map.Entry elist : ((Map)entry.getValue()).entrySet()) {
                int type = (Integer)elist.getKey();
                this.addAttributes(vendor, type, this.clone((List)elist.getValue()));
            }
        }
    }

    public void setAttributes(RadiusAttributeSet set) {
        for (Map.Entry<Integer, List<RadiusAttribute<?>>> entry : set.standartAttributes.entrySet()) {
            int type = entry.getKey();
            this.setAttributes(-1, type, this.clone(entry.getValue()));
        }
        for (Map.Entry<Integer, Object> entry : set.vendorAttributes.entrySet()) {
            int vendor = entry.getKey();
            for (Map.Entry elist : ((Map)entry.getValue()).entrySet()) {
                int type = (Integer)elist.getKey();
                this.setAttributes(vendor, type, this.clone((List)elist.getValue()));
            }
        }
    }

    public void addAttribute(RadiusAttribute<?> attribute) {
        if (((RadiusAttributeInfo)attribute.info).vendor < 0) {
            this.addAttribute(this.standartAttributes, attribute);
        } else {
            Map<Integer, List<RadiusAttribute<?>>> attributeMap = this.vendorAttributes.get(((RadiusAttributeInfo)attribute.info).vendor);
            if (attributeMap == null) {
                attributeMap = new HashMap();
                this.vendorAttributes.put(((RadiusAttributeInfo)attribute.info).vendor, attributeMap);
            }
            this.addAttribute(attributeMap, attribute);
        }
    }

    private void addAttribute(Map<Integer, List<RadiusAttribute<?>>> attributeMap, RadiusAttribute<?> attribute) {
        List<RadiusAttribute<?>> list = attributeMap.get(((RadiusAttributeInfo)attribute.info).type);
        if (list == null) {
            ArrayList attributes = new ArrayList(3);
            attributes.add(attribute);
            attributeMap.put(((RadiusAttributeInfo)attribute.info).type, attributes);
        } else {
            list.add(attribute);
        }
    }

    public void setAttributes(int vendor, int type, List<RadiusAttribute<?>> attributes) {
        for (RadiusAttribute<?> ra : attributes) {
            if (((RadiusAttributeInfo)ra.info).vendor == vendor && ((RadiusAttributeInfo)ra.info).type == type) continue;
            throw new IllegalArgumentException();
        }
        this.setAttributes0(vendor, type, attributes);
    }

    private void setAttributes0(int vendor, int type, List<RadiusAttribute<?>> attributes) {
        assert (attributes.size() > 0);
        if (vendor < 0) {
            this.standartAttributes.put(type, attributes);
        } else {
            Map<Integer, List<RadiusAttribute<?>>> attributeMap = this.vendorAttributes.get(vendor);
            if (attributeMap == null) {
                attributeMap = new HashMap();
                this.vendorAttributes.put(vendor, attributeMap);
            }
            attributeMap.put(type, attributes);
        }
    }

    public void setAttribute(RadiusAttribute<?> attribute) {
        ArrayList attributes = new ArrayList(1);
        attributes.add(attribute);
        this.setAttributes0(((RadiusAttributeInfo)attribute.info).vendor, ((RadiusAttributeInfo)attribute.info).type, attributes);
    }

    public List<RadiusAttribute<?>> getAttributes(int vendor, int type) {
        if (vendor < 0) {
            return this.standartAttributes.get(type);
        }
        Map<Integer, List<RadiusAttribute<?>>> attributes = this.vendorAttributes.get(vendor);
        if (attributes != null) {
            return attributes.get(type);
        }
        return null;
    }

    public <A extends RadiusAttribute> A getAttribute(int vendor, int type) {
        List<RadiusAttribute<?>> result = this.getAttributes(vendor, type);
        if (result != null) {
            return (A)result.get(0);
        }
        return null;
    }

    public Integer getIntAttribute(int vendor, int type, Integer def) {
        Integer intResult;
        Object v;
        Object result = this.getAttribute(vendor, type);
        return result != null && (v = ((Tlv)result).getValue()) instanceof Integer ? (intResult = (Integer)v) : def;
    }

    public String getStringAttribute(int vendor, int type, String def) {
        String strResult;
        Object v;
        Object result = this.getAttribute(vendor, type);
        return result != null && (v = ((Tlv)result).getValue()) instanceof String ? (strResult = (String)v) : def;
    }

    public byte[] getByteAttribute(int vendor, int type, byte[] def) {
        Object result = this.getAttribute(vendor, type);
        return result != null ? ((Tlv)result).getDataAsByteArray() : def;
    }

    public void setIntAttribute(int vendor, int type, int value) {
        this.setAttribute(new RadiusAttribute.RadiusAttributeInteger(vendor, type, value));
    }

    public void setStringAttribute(int vendor, int type, String value) {
        this.setAttribute(new RadiusAttribute.RadiusAttributeString(vendor, type, value));
    }

    public void setByteAttribute(int vendor, int type, byte[] value) {
        this.setAttribute(new RadiusAttribute(vendor, type, 0, ByteBuffer.wrap(value)));
    }

    public void removeAttributes(int vendor, int type) {
        if (vendor < 0) {
            this.standartAttributes.remove(type);
        } else {
            Map<Integer, List<RadiusAttribute<?>>> attributeMap = this.vendorAttributes.get(vendor);
            if (attributeMap != null) {
                attributeMap.remove(type);
            }
        }
    }

    public boolean contains(RadiusAttributeSet attributeSet) {
        for (Map.Entry<Integer, List<RadiusAttribute<?>>> entry : attributeSet.standartAttributes.entrySet()) {
            List<RadiusAttribute<?>> other = entry.getValue();
            if (other == null || other.size() == 0) continue;
            List<RadiusAttribute<RadiusAttribute<?>>> list = this.standartAttributes.get(entry.getKey());
            if (list == null) {
                return false;
            }
            if (list.containsAll(other)) continue;
            return false;
        }
        for (Map.Entry<Integer, Object> entry : attributeSet.vendorAttributes.entrySet()) {
            Map<Integer, List<RadiusAttribute<?>>> thisMap = this.vendorAttributes.get(entry.getKey());
            for (Map.Entry e : ((Map)entry.getValue()).entrySet()) {
                List other = (List)e.getValue();
                if (other == null || other.size() == 0) continue;
                if (thisMap == null) {
                    return false;
                }
                List<RadiusAttribute<?>> list = thisMap.get(e.getKey());
                if (list == null) {
                    return false;
                }
                if (list.containsAll(other)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        RadiusAttributeSet attributeSet = (RadiusAttributeSet)o;
        boolean result = this.eq(attributeSet);
        assert (result == (this.contains(attributeSet) && attributeSet.contains(this)));
        return result;
    }

    private boolean eq(RadiusAttributeSet attributeSet) {
        for (Map.Entry<Integer, List<RadiusAttribute<?>>> entry : attributeSet.standartAttributes.entrySet()) {
            List<RadiusAttribute<?>> other = entry.getValue();
            List<RadiusAttribute<?>> list = this.standartAttributes.get(entry.getKey());
            if (other == null || other.size() == 0) {
                if (list == null || list.size() == 0) continue;
                return false;
            }
            if (list == null) {
                return false;
            }
            if (list.equals(other)) continue;
            return false;
        }
        for (Map.Entry<Integer, Object> entry : attributeSet.vendorAttributes.entrySet()) {
            Map<Integer, List<RadiusAttribute<?>>> thisMap = this.vendorAttributes.get(entry.getKey());
            for (Map.Entry e : ((Map)entry.getValue()).entrySet()) {
                List<RadiusAttribute<?>> list;
                List other = (List)e.getValue();
                if (other == null || other.size() == 0) {
                    if (thisMap == null || (list = thisMap.get(e.getKey())) == null || list.size() == 0) continue;
                    return false;
                }
                if (thisMap == null) {
                    return false;
                }
                list = thisMap.get(e.getKey());
                if (list == null || list.size() == 0) {
                    return false;
                }
                if (list.equals(other)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        this.toString(this.standartAttributes.entrySet(), sb);
        for (Map<Integer, List<RadiusAttribute<?>>> map : this.vendorAttributes.values()) {
            this.toString(map.entrySet(), sb);
        }
        return sb.toString();
    }

    protected final void toString(Set<Map.Entry<Integer, List<RadiusAttribute<?>>>> entrySet, StringBuilder sb) {
        for (Map.Entry<Integer, List<RadiusAttribute<?>>> e : entrySet) {
            for (RadiusAttribute<?> ra : e.getValue()) {
                sb.append("\n\t").append(ra.toString(true));
            }
        }
    }

    public boolean isEmpty() {
        if (this.standartAttributes.size() > 0) {
            return false;
        }
        if (this.vendorAttributes.size() == 0) {
            return true;
        }
        for (Map<Integer, List<RadiusAttribute<?>>> map : this.vendorAttributes.values()) {
            if (map.size() <= 0) continue;
            return false;
        }
        return true;
    }

    public String getStringAttribute(int vendor, int type, String prefix, String def) {
        if (vendor < -1 || type <= 0) {
            return def;
        }
        if (Utils.isBlankString((String)prefix)) {
            return this.getStringAttribute(vendor, type, def);
        }
        List<RadiusAttribute<?>> ras = this.getAttributes(vendor, type);
        if (ras == null) {
            return def;
        }
        int size = ras.size();
        for (int i = 0; i < size; ++i) {
            String stringValue;
            RadiusAttribute<?> ra = ras.get(i);
            Object value = ra.getValue();
            if (!(value instanceof String) || !(stringValue = (String)value).startsWith(prefix)) continue;
            return stringValue.substring(prefix.length());
        }
        return def;
    }

    public Object getAttributeValue(int vendor, int type, String prefix, Object def) {
        return this.getAttributeValue(vendor, type, prefix, null, def);
    }

    public Object getAttributeValue(int vendor, int type, String prefix, Pattern regex, Object def) {
        if (vendor < -1 || type <= 0) {
            return def;
        }
        if (Utils.isBlankString((String)prefix)) {
            Object ra = this.getAttribute(vendor, type);
            if (ra != null) {
                Object result = ((Tlv)ra).getValue();
                if (regex != null && result instanceof String) {
                    String resultString = (String)result;
                    Matcher m = regex.matcher(resultString);
                    if (m.find()) {
                        return m.groupCount() > 0 ? m.group(1) : m.group();
                    }
                    return def;
                }
                return result;
            }
        } else {
            List<RadiusAttribute<?>> ras = this.getAttributes(vendor, type);
            if (ras == null) {
                return def;
            }
            int size = ras.size();
            for (int i = 0; i < size; ++i) {
                String stringValue;
                RadiusAttribute<?> ra = ras.get(i);
                Object value = ra.getValue();
                if (!(value instanceof String) || !(stringValue = (String)value).startsWith(prefix)) continue;
                String result = stringValue.substring(prefix.length());
                if (regex != null) {
                    Matcher m = regex.matcher(result);
                    if (!m.find()) continue;
                    return m.groupCount() > 0 ? m.group(1) : m.group();
                }
                return result;
            }
        }
        return def;
    }
}

