/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.common.BGPopup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormatSymbols;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.TimeUtils;

public class BGControlPanelMonth
extends JPanel {
    private LocalDate dateNew = LocalDate.now();
    private MonthActionListener monthActionListener = new MonthActionListener();
    private StepButton addMonth = new StepButton("to_next.gif", "", "1", this.monthActionListener);
    private StepButton decMonth = new StepButton("to_prev.gif", "", "-1", this.monthActionListener);
    private BGButton monthYearButton = new BGButton();
    private BGPopup popup = null;
    static final DateFormatSymbols fs = new DateFormatSymbols(){

        @Override
        public String[] getMonths() {
            return TimeUtils.monthNames;
        }
    };

    public BGControlPanelMonth() {
        super(new GridBagLayout());
        this.dateNew = this.dateNew.withDayOfMonth(1);
        this.setDateText(this.dateNew);
        Dimension dimension = this.monthYearButton.getPreferredSize();
        dimension.width = 150;
        this.monthYearButton.setPreferredSize(dimension);
        this.monthYearButton.addActionListener(e -> this.setPopupVisible(true));
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.add((Component)this.decMonth, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.monthYearButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.addMonth, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public BGControlPanelMonth(Border border) {
        this();
        this.setBorder(border);
    }

    public LocalDate getLocalDate() {
        return this.dateNew;
    }

    public void setLocalDate(LocalDate date) {
        LocalDate calendarOld = this.dateNew;
        this.dateNew = date;
        this.firePropertyChange("date", calendarOld, this.dateNew);
        this.setDateText(this.dateNew);
    }

    private void setDateText(LocalDate month) {
        this.monthYearButton.setText(DateTimeFormatter.ofPattern("LLLL yyyy").format(month));
    }

    private void month_actionPerformed(int step) {
        if (step != 0) {
            this.setLocalDate(this.dateNew.plusMonths(step));
        }
    }

    public String getDateString() {
        return DateTimeFormatter.ofPattern("dd.MM.yyyy").format(this.getLocalDate());
    }

    public void setPopupVisible(boolean visible) {
        if (visible) {
            this.popup = new BGPopup();
            this.popup.addPropertyChangeListener(new MYPropertyChangeListener());
            this.popup.setLocalDate(this.dateNew == null ? LocalDate.now() : this.dateNew);
            this.popup.show(this.decMonth, 0, this.decMonth.getHeight() + 1);
        } else if (this.popup != null) {
            this.popup.setVisible(false);
            this.popup = null;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.decMonth.setEnabled(enabled);
        this.addMonth.setEnabled(enabled);
        this.monthYearButton.setEnabled(enabled);
    }

    private class MonthActionListener
    implements ActionListener {
        private MonthActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BGControlPanelMonth.this.month_actionPerformed(Integer.parseInt(e.getActionCommand()));
        }
    }

    class StepButton
    extends BGButton {
        public StepButton(String icon, String text, String actionCommand, ActionListener actionListener) {
            this.setIcon(ClientUtils.getIcon(icon));
            this.setText(text);
            this.setActionCommand(actionCommand);
            this.addActionListener(actionListener);
        }
    }

    private class MYPropertyChangeListener
    implements PropertyChangeListener {
        private MYPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            if ("currentSelectDate".equals(propertyName)) {
                BGControlPanelMonth.this.setDateText((LocalDate)event.getNewValue());
            } else if ("selectDate".equals(propertyName)) {
                BGControlPanelMonth.this.setLocalDate((LocalDate)event.getNewValue());
            }
        }
    }
}

