/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.field;

import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import ru.bitel.common.Utils;

public class BGPasswordField
extends JPasswordField
implements FocusListener {
    private static final char[] stars;
    private static final char zeroChar = '\u0000';
    private static final char defaultEchoChar;

    public BGPasswordField() {
        this(0);
    }

    public BGPasswordField(int columns) {
        super(columns);
        this.setMinimumSize(new Dimension(10, 24));
        this.setPreferredSize(new Dimension(10, 24));
        this.addFocusListener(this);
    }

    @Override
    public char[] getPassword() {
        char[] pswd = super.getPassword();
        if (Arrays.equals(stars, pswd)) {
            return new char[0];
        }
        return pswd;
    }

    @Override
    public void setText(String t) {
        if (Utils.isEmptyString(t)) {
            this.setText();
        } else {
            super.setText(t);
        }
    }

    public void setText() {
        this.setText(new String(stars));
    }

    @Override
    public void focusGained(FocusEvent e) {
        char[] pswd = super.getPassword();
        if (Arrays.equals(stars, pswd)) {
            super.setText("");
        }
        Arrays.fill(pswd, '\u0000');
    }

    @Override
    public void focusLost(FocusEvent e) {
        char[] pswd = super.getPassword();
        if (pswd.length == 0) {
            super.setText(new String(stars));
        }
        Arrays.fill(pswd, '\u0000');
    }

    public void setNoSecret(boolean nosecret) {
        this.setEchoChar(nosecret ? (char)'\u0000' : defaultEchoChar);
    }

    static {
        Character echoChar = (Character)UIManager.getDefaults().get("PasswordField.echoChar");
        defaultEchoChar = (char)(echoChar != null ? (int)echoChar.charValue() : 42);
        stars = new char[]{defaultEchoChar, defaultEchoChar, defaultEchoChar, defaultEchoChar, defaultEchoChar, defaultEchoChar, defaultEchoChar, defaultEchoChar};
    }
}

