/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.api;

import jakarta.servlet.ServletContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.ws.server.DynamicJaxWsHandler;
import ru.bitel.bgbilling.kernel.container.ws.server.ModuleKey;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.server.util.Setup;

public class CustomApiWsHandler
extends DynamicJaxWsHandler {
    public CustomApiWsHandler(ServletContext context) throws BGException {
        super(context);
    }

    @Override
    protected Class<?> findEndpointClass(ModuleKey moduleKey) {
        Class<?> clazz = null;
        try {
            Setup setup = Setup.getSetup();
            String className = "api." + moduleKey.module + ".impl." + moduleKey.service + "Impl";
            if (setup.getBoolean("api.enable", false)) {
                clazz = DynamicClassManager.getInstance().loadClass(className);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return clazz;
    }

    @Override
    protected String getLoggingEnabledParam() {
        return "api.ws.log";
    }

    @Override
    protected String getUrlPatternName(ModuleKey moduleKey, Class<?> implementorClass) {
        return "/api/" + moduleKey.module + "/" + (String)(moduleKey.moduleId > 0 ? moduleKey.moduleId + "/" : "") + moduleKey.service;
    }
}

