/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public class InetIpCategoryTreePanel
extends BGUPanel {
    public static final String ACTION_CATEGORY_SELECTED = "ip.category.selected";
    public static final String ACTION_CATEGORY_EDIT = "ip.category.edit";
    private boolean border;
    private ActionListener actionListener;
    private IpCategory selectedCategory;
    private ResourceService resourceService = null;
    private IpCategoryTreeTableModel treeModel = new IpCategoryTreeTableModel();
    private BGUTreeTable treeTable = new BGUTreeTable(this.treeModel);

    public InetIpCategoryTreePanel(ActionListener actionListener, boolean border, ClientContext context) {
        super(context);
        this.actionListener = actionListener;
        this.border = border;
    }

    @Override
    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        this.treeTable = new BGUTreeTable(this.treeModel);
        this.treeTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.selectedCategory = (IpCategory)this.treeModel.getSelectedRow();
                if (this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 0, ACTION_CATEGORY_SELECTED));
                }
            }
        });
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    InetIpCategoryTreePanel.this.actionListener.actionPerformed(new ActionEvent(this, 0, InetIpCategoryTreePanel.ACTION_CATEGORY_EDIT));
                }
            }
        });
        this.treeTable.getSelectionModel().setSelectionMode(0);
        if (!this.border) {
            this.add((Component)new JScrollPane(this.treeTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        } else {
            this.add((Component)BGSwingUtilites.wrapBorder(new JScrollPane(this.treeTable), "\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            IpCategory selected = (IpCategory)this.treeModel.getSelectedRow();
            IpCategory ipCategoryRoot = this.getResourceService().ipCategoryRoot();
            if (ipCategoryRoot != null) {
                this.treeModel.setData(ipCategoryRoot);
                this.treeModel.setSelectedRow(selected);
            }
        });
    }

    public IpCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    public void setSelectedCategoryId(Integer categoryId) {
        this.treeModel.setSelectedRow(categoryId);
    }

    public BGUTreeTable getTreeTable() {
        return this.treeTable;
    }

    public BGTreeTableModel<IpCategory> getTreeModel() {
        return this.treeModel;
    }

    private ResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = ((ClientContext)this.getContext()).getPort(ResourceService.class);
        }
        return this.resourceService;
    }

    class IpCategoryTreeTableModel
    extends BGTreeTableModel<IpCategory> {
        public IpCategoryTreeTableModel() {
            super(IpCategoryTreeTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", IpCategory.class, -1, 300, -1, "title", false);
            this.addColumnId(false);
        }
    }
}

