/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.util.FileBackedLIFOQueue;

public class FileBackedFIFOQueue<E>
extends FileBackedLIFOQueue<E> {
    private FileChannel channel;
    private ByteBuffer byteBuffer = ByteBuffer.allocate(131072);

    public FileBackedFIFOQueue(File file, int capacity) throws BGException {
        super(file, capacity);
        try {
            this.channel = this.file.getChannel();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    @Override
    protected E extract() {
        try {
            long position = ((FileBackedLIFOQueue.FilePointer)this.filePointers.peekFirst()).value;
            long count = ((FileBackedLIFOQueue.FilePointer)this.filePointers.peekLast()).value - position;
            this.file.seek(this.initialPosition);
            if ((long)this.byteBuffer.capacity() < count) {
                this.byteBuffer = ByteBuffer.allocate((int)count);
            }
            this.byteBuffer.clear();
            this.channel.read(this.byteBuffer, position);
            this.byteBuffer.flip();
            this.channel.position(this.initialPosition);
            this.channel.write(this.byteBuffer);
            this.file.setLength(count + this.initialPosition);
            Object e = this.queue.pollFirst();
            this.filePointers.pollFirst();
            for (FileBackedLIFOQueue.FilePointer filePointer : this.filePointers) {
                filePointer.value -= position - this.initialPosition;
            }
            --this.count;
            this.notFull.signal();
            return e;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    protected void insert(E e, boolean signal) {
        try {
            this.out.writeObject(e);
            this.out.reset();
            this.out.flush();
            this.filePointers.add(new FileBackedLIFOQueue.FilePointer(this, this.file.getFilePointer()));
            this.queue.offer(e);
            ++this.count;
            if (signal) {
                this.notEmpty.signal();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

